/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.junit.runner.Description;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;

public class TestEnvironment {
    @CheckForNull
    public final HudsonTestCase testCase;
    @CheckForNull
    private final Description description;
    public final TemporaryDirectoryAllocator temporaryDirectoryAllocator = new TemporaryDirectoryAllocator();
    private static TestEnvironment CURRENT;

    public TestEnvironment(@Nonnull HudsonTestCase testCase) {
        this.testCase = testCase;
        this.description = null;
    }

    public TestEnvironment(@Nonnull Description description) {
        this.testCase = null;
        this.description = description;
    }

    @Nonnull
    public Description description() {
        if (this.description != null) {
            return this.description;
        }
        assert (this.testCase != null);
        return Description.createTestDescription(((Object)((Object)this.testCase)).getClass(), (String)this.testCase.getName());
    }

    public void pin() {
        CURRENT = this;
    }

    public void dispose() throws IOException, InterruptedException {
        this.temporaryDirectoryAllocator.dispose();
        CURRENT = null;
    }

    public static TestEnvironment get() {
        return CURRENT;
    }
}

