/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.RunAction;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class RunLoadCounter {
    private static final ThreadLocal<String> currProject = new ThreadLocal();
    private static final ThreadLocal<AtomicInteger> currCount = new ThreadLocal();

    public static void prepare(AbstractProject<?, ?> project) throws IOException {
        project.getPublishersList().add((Object)new MarkerAdder());
        for (AbstractBuild build : project._getRuns()) {
            Marker.add(build);
            build.save();
        }
    }

    public static int countLoads(AbstractProject<?, ?> project, Runnable thunk) {
        project._getRuns().purgeCache();
        currProject.set(project.getFullName());
        currCount.set(new AtomicInteger());
        thunk.run();
        return currCount.get().get();
    }

    public static <T> T assertMaxLoads(AbstractProject<?, ?> project, int max, Callable<T> thunk) throws Exception {
        project._getRuns().purgeCache();
        currProject.set(project.getFullName());
        currCount.set(new AtomicInteger(-(max + 1)));
        return thunk.call();
    }

    private RunLoadCounter() {
    }

    @Restricted(value={NoExternalUse.class})
    public static final class MarkerAdder
    extends Notifier {
        public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
            Marker.add(build);
            return true;
        }

        public BuildStepMonitor getRequiredMonitorService() {
            return BuildStepMonitor.NONE;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class Marker
    implements RunAction {
        private final String project;
        private final int build;

        static void add(AbstractBuild<?, ?> build) {
            build.addAction((Action)new Marker(((AbstractProject)build.getParent()).getFullName(), build.getNumber()));
        }

        Marker(String project, int build) {
            this.project = project;
            this.build = build;
        }

        public void onLoad() {
            if (this.project.equals(currProject.get())) {
                System.err.println("loaded " + this.project + " #" + this.build);
                assert (((AtomicInteger)currCount.get()).incrementAndGet() != 0) : "too many build records loaded from " + this.project;
            }
        }

        public void onAttached(Run r) {
        }

        public void onBuildComplete() {
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }
}

