/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.cli.CLICommand;
import java.io.File;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.JellyTestSuiteBuilder;

public class PluginAutomaticTestBuilder {
    public static TestSuite build(Map<String, ?> params) throws Exception {
        TestSuite suite = new TestSuite();
        if (params.containsKey("outputDirectory") || PluginAutomaticTestBuilder.notSkipTests("JellyTest")) {
            File outputDirectory = new File((String)params.get("outputDirectory"));
            suite.addTest((Test)JellyTestSuiteBuilder.build(outputDirectory, PluginAutomaticTestBuilder.toBoolean(params.get("requirePI"))));
        }
        suite.addTestSuite(CliSanityTest.class);
        return suite;
    }

    private static boolean toBoolean(Object requirePI) {
        if (requirePI == null) {
            return false;
        }
        if (requirePI instanceof Boolean) {
            return (Boolean)requirePI;
        }
        return Boolean.parseBoolean(requirePI.toString());
    }

    private static boolean notSkipTests(String propertyName) {
        return !Boolean.getBoolean("hpiTest.skip" + propertyName);
    }

    public static class CliSanityTest
    extends HudsonTestCase {
        public void testCliSanity() {
            CLICommand.clone((String)"help");
        }
    }
}

