/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptEngine
implements Serializable {
    private static final long serialVersionUID = -5414040051465432088L;
    private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);
    private final WebClient webClient_;
    private final HtmlUnitContextFactory contextFactory_;
    private static final ThreadLocal<Boolean> javaScriptRunning_ = new ThreadLocal();
    private static final ThreadLocal<List<PostponedAction>> postponedActions_ = new ThreadLocal();
    public static final String KEY_STARTING_SCOPE = "startingScope";
    public static final String KEY_STARTING_PAGE = "startingPage";

    public JavaScriptEngine(WebClient webClient) {
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient);
    }

    public final WebClient getWebClient() {
        return this.webClient_;
    }

    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    public void initialize(final WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                try {
                    JavaScriptEngine.this.init(webWindow, cx);
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
                    throw new ScriptException(null, (Throwable)e);
                }
                return null;
            }
        };
        this.getContextFactory().call(action);
    }

    private void init(WebWindow webWindow, Context context) throws Exception {
        String[] undesirableWindowProps;
        WebClient webClient = webWindow.getWebClient();
        HashMap<Class<? extends SimpleScriptable>, Scriptable> prototypes = new HashMap<Class<? extends SimpleScriptable>, Scriptable>();
        HashMap<String, ScriptableObject> prototypesPerJSName = new HashMap<String, ScriptableObject>();
        Window window = new Window(this);
        JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
        context.initStandardObjects((ScriptableObject)window);
        for (String property : undesirableWindowProps = new String[]{"javax", "org", "com", "edu", "net", "JavaAdapter", "JavaImporter", "Continuation"}) {
            window.delete(property);
        }
        if (webClient.getBrowserVersion().isIE()) {
            String[] undesirableWindowPropsIE;
            for (String property : undesirableWindowPropsIE = new String[]{"Packages", "java", "getClass", "XML", "XMLList", "Namespace", "QName"}) {
                window.delete(property);
            }
        }
        ScriptableObject fallbackCaller = new ScriptableObject(){
            private static final long serialVersionUID = -7124423159070941606L;

            public Object get(String name, Scriptable start) {
                if (start instanceof ScriptableWithFallbackGetter) {
                    return ((ScriptableWithFallbackGetter)start).getWithFallback(name);
                }
                return NOT_FOUND;
            }

            public String getClassName() {
                return "htmlUnitHelper-fallbackCaller";
            }
        };
        ScriptableObject.getObjectPrototype((Scriptable)window).setPrototype((Scriptable)fallbackCaller);
        for (String jsClassName : jsConfig.keySet()) {
            ClassConfiguration config = jsConfig.getClassConfiguration(jsClassName);
            boolean isWindow = Window.class.getName().equals(config.getLinkedClass().getName());
            if (isWindow) {
                this.configureConstantsPropertiesAndFunctions(config, window);
                continue;
            }
            ScriptableObject prototype = this.configureClass(config, window);
            if (config.isJsObject()) {
                if (!this.getWebClient().getBrowserVersion().isIE()) {
                    SimpleScriptable obj = config.getLinkedClass().newInstance();
                    prototype.defineProperty("__proto__", (Object)prototype, 2);
                    obj.defineProperty("prototype", prototype, 2);
                    obj.setParentScope(window);
                    ScriptableObject.defineProperty((Scriptable)window, (String)config.getClassName(), (Object)obj, (int)2);
                    this.configureConstants(config, obj);
                    if (obj.getClass() == Element.class && webWindow.getEnclosedPage() instanceof HtmlPage) {
                        HtmlElement domNode = new HtmlElement(null, "", (SgmlPage)webWindow.getEnclosedPage(), null){
                            private static final long serialVersionUID = -5614158965497997095L;
                        };
                        obj.setDomNode(domNode);
                    }
                }
                prototypes.put(config.getLinkedClass(), (Scriptable)prototype);
            }
            prototypesPerJSName.put(config.getClassName(), prototype);
        }
        Scriptable objectPrototype = ScriptableObject.getObjectPrototype((Scriptable)window);
        for (Map.Entry entry : prototypesPerJSName.entrySet()) {
            String name = (String)entry.getKey();
            ClassConfiguration config = jsConfig.getClassConfiguration(name);
            Scriptable prototype = (Scriptable)entry.getValue();
            if (prototype.getPrototype() != null) {
                prototype = prototype.getPrototype();
            }
            if (!StringUtils.isEmpty((String)config.getExtendedClass())) {
                Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClass());
                prototype.setPrototype(parentPrototype);
                continue;
            }
            prototype.setPrototype(objectPrototype);
        }
        Class[] evalFnTypes = new Class[]{String.class};
        Method evalFn = Window.class.getMethod("custom_eval", evalFnTypes);
        FunctionObject jsCustomEval = new FunctionObject("eval", (Member)evalFn, (Scriptable)window);
        window.associateValue("custom_eval", jsCustomEval);
        for (String jsClassName : jsConfig.keySet()) {
            Scriptable prototype;
            ClassConfiguration config = jsConfig.getClassConfiguration(jsClassName);
            Method jsConstructor = config.getJsConstructor();
            if (jsConstructor == null || (prototype = (Scriptable)prototypesPerJSName.get(jsClassName)) == null) continue;
            FunctionObject jsCtor = new FunctionObject(jsClassName, (Member)jsConstructor, (Scriptable)window);
            jsCtor.addAsConstructor((Scriptable)window, prototype);
        }
        if (webClient.getBrowserVersion().isIE()) {
            String[] objectPropertiesToRemove = new String[]{"__defineGetter__", "__defineSetter__", "__lookupGetter__", "__lookupSetter__", "toSource"};
            this.removePrototypeProperties(window, "Object", objectPropertiesToRemove);
            String[] arrayPropertiesToRemove = new String[]{"every", "filter", "forEach", "indexOf", "lastIndexOf", "map", "some", "toSource"};
            this.removePrototypeProperties(window, "Array", arrayPropertiesToRemove);
        }
        window.setPrototypes(prototypes);
        window.initialize(webWindow);
    }

    private void removePrototypeProperties(Window window, String className, String[] properties) {
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)className);
        for (String property : properties) {
            prototype.delete(property);
        }
    }

    private ScriptableObject configureClass(ClassConfiguration config, Scriptable window) throws InstantiationException, IllegalAccessException {
        Class<? extends SimpleScriptable> jsHostClass = config.getLinkedClass();
        ScriptableObject prototype = jsHostClass.newInstance();
        prototype.setParentScope(window);
        this.configureConstantsPropertiesAndFunctions(config, prototype);
        return prototype;
    }

    private void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        this.configureConstants(config, scriptable);
        for (String propertyName : config.propertyKeys()) {
            Method readMethod = config.getPropertyReadMethod(propertyName);
            Method writeMethod = config.getPropertyWriteMethod(propertyName);
            scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
        }
        int attributes = 0;
        if (this.webClient_.getBrowserVersion().isIE()) {
            attributes = 2;
        }
        for (String functionName : config.functionKeys()) {
            Method method = config.getFunctionMethod(functionName);
            FunctionObject functionObject = new FunctionObject(functionName, (Member)method, (Scriptable)scriptable);
            scriptable.defineProperty(functionName, (Object)functionObject, attributes);
        }
    }

    private void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        for (String constant : config.constants()) {
            Class<? extends SimpleScriptable> linkedClass = config.getLinkedClass();
            try {
                Object value = linkedClass.getField(constant).get(null);
                scriptable.defineProperty(constant, value, 0);
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("Cannot get field '" + constant + "' for type: " + config.getClassName()));
            }
        }
    }

    public Script compile(HtmlPage htmlPage, String sourceCode, final String sourceName, final int startLine) {
        WebAssert.notNull("sourceCode", sourceCode);
        Scriptable scope = this.getScope(htmlPage, null);
        final String source = sourceCode;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return cx.compileString(source, sourceName, startLine, null);
            }

            protected String getSourceCode(Context cx) {
                return source;
            }
        };
        return (Script)this.getContextFactory().call(action);
    }

    public Object execute(HtmlPage htmlPage, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(htmlPage, sourceCode, sourceName, startLine);
        return this.execute(htmlPage, script);
    }

    public Object execute(HtmlPage htmlPage, final Script script) {
        final Scriptable scope = this.getScope(htmlPage, null);
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        Object r = this.getContextFactory().call(action);
        this.processPostponedActions();
        return r;
    }

    public Object callFunction(final HtmlPage htmlPage, Object javaScriptFunction, final Object thisObject, final Object[] args, DomNode htmlElement) {
        final Scriptable scope = this.getScope(htmlPage, htmlElement);
        final Function function = (Function)javaScriptFunction;
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, htmlPage){

            public Object doRun(Context cx) {
                return JavaScriptEngine.this.callFunction(htmlPage, function, cx, scope, (Scriptable)thisObject, args);
            }

            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().call(action);
    }

    private Scriptable getScope(HtmlPage htmlPage, DomNode htmlElement) {
        Object scope = htmlElement != null ? htmlElement.getScriptObject() : (Window)htmlPage.getEnclosingWindow().getScriptObject();
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(HtmlPage htmlPage, Function function, Context context, Scriptable scope, Scriptable thisObject, Object[] args) {
        HtmlPage htmlPage2 = htmlPage;
        synchronized (htmlPage2) {
            Object result = function.call(context, scope, thisObject, args);
            this.processPostponedActions();
            return result;
        }
    }

    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(javaScriptRunning_.get());
    }

    private void processPostponedActions() {
        List<PostponedAction> actions;
        block2: while ((actions = postponedActions_.get()) != null) {
            postponedActions_.set(null);
            try {
                Iterator<PostponedAction> i$ = actions.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    PostponedAction action = i$.next();
                    action.execute();
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    public void addPostponedAction(PostponedAction action) {
        List<PostponedAction> actions = postponedActions_.get();
        if (actions == null) {
            actions = new ArrayList<PostponedAction>();
            postponedActions_.set(actions);
        }
        actions.add(action);
    }

    protected void handleJavaScriptException(ScriptException scriptException) {
        Window w;
        WebWindow window;
        HtmlPage page = scriptException.getPage();
        if (page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptObject()) != null) {
            w.triggerOnError(scriptException);
        }
        if (this.getWebClient().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
        LOG.info((Object)"Caught script exception", (Throwable)scriptException);
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction {
        private final Scriptable scope_;
        private final HtmlPage htmlPage_;

        public HtmlUnitContextAction(Scriptable scope, HtmlPage htmlPage) {
            this.scope_ = scope;
            this.htmlPage_ = htmlPage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object run(Context cx) {
            Boolean javaScriptAlreadyRunning = (Boolean)javaScriptRunning_.get();
            javaScriptRunning_.set(Boolean.TRUE);
            try {
                cx.putThreadLocal((Object)JavaScriptEngine.KEY_STARTING_SCOPE, (Object)this.scope_);
                cx.putThreadLocal((Object)JavaScriptEngine.KEY_STARTING_PAGE, (Object)this.htmlPage_);
                HtmlPage htmlPage = this.htmlPage_;
                synchronized (htmlPage) {
                    try {
                        Object response = this.doRun(cx);
                        JavaScriptEngine.this.processPostponedActions();
                        Object object = response;
                        return object;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Exception e) {
                            JavaScriptEngine.this.handleJavaScriptException(new ScriptException(this.htmlPage_, e, this.getSourceCode(cx)));
                            Object var4_7 = null;
                            return var4_7;
                        }
                        catch (TimeoutError e) {
                            if (JavaScriptEngine.this.getWebClient().isThrowExceptionOnScriptError()) {
                                throw new RuntimeException(e);
                            }
                            LOG.info((Object)"Caught script timeout error", (Throwable)e);
                            Object var4_8 = null;
                            return var4_8;
                        }
                    }
                }
            }
            finally {
                javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

