/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlForm
extends ClickableElement {
    private static final long serialVersionUID = 5338964478788825866L;
    public static final String TAG_NAME = "form";
    private static final Collection<String> SUBMITTABLE_ELEMENT_NAMES = Arrays.asList("input", "button", "select", "textarea", "isindex");
    private final List<HtmlElement> lostChildren_ = new ArrayList<HtmlElement>();
    private boolean isPreventDefault_;

    HtmlForm(String namespaceURI, String qualifiedName, SgmlPage htmlPage, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, htmlPage, attributes);
    }

    public Page submit() throws IOException {
        return this.submit(this.getSubmitButton());
    }

    public Page submit(SubmittableElement submitElement) throws IOException {
        URL url;
        HttpMethod method;
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        if (htmlPage.getWebClient().isJavaScriptEnabled()) {
            String action;
            if (submitElement != null) {
                this.isPreventDefault_ = false;
                ScriptResult scriptResult = this.fireEvent("submit");
                if (this.isPreventDefault_) {
                    return scriptResult.getNewPage();
                }
            }
            if (TextUtil.startsWithIgnoreCase(action = this.getActionAttribute(), "javascript:")) {
                return htmlPage.executeJavaScriptIfPossible(action, "Form action", this.getStartLineNumber()).getNewPage();
            }
        } else if (TextUtil.startsWithIgnoreCase(this.getActionAttribute(), "javascript:")) {
            return htmlPage;
        }
        List<NameValuePair> parameters = this.getParameterListForSubmit(submitElement);
        String methodAttribute = this.getMethodAttribute();
        if ("post".equalsIgnoreCase(methodAttribute)) {
            method = HttpMethod.POST;
        } else {
            if (!"get".equalsIgnoreCase(methodAttribute) && methodAttribute.trim().length() > 0) {
                this.notifyIncorrectness("Incorrect submit method >" + this.getMethodAttribute() + "<. Using >GET<.");
            }
            method = HttpMethod.GET;
        }
        String actionUrl = this.getActionAttribute();
        if (HttpMethod.GET == method) {
            String anchor = StringUtils.substringAfter((String)actionUrl, (String)"#");
            actionUrl = StringUtils.substringBefore((String)actionUrl, (String)"#");
            NameValuePair[] pairs = new NameValuePair[parameters.size()];
            parameters.toArray(pairs);
            String queryFromFields = EncodingUtil.formUrlEncode((NameValuePair[])pairs, (String)this.getPage().getPageEncoding());
            actionUrl = StringUtils.substringBefore((String)actionUrl, (String)"?");
            BrowserVersion browserVersion = this.getPage().getWebClient().getBrowserVersion();
            if (!browserVersion.isIE() || !(browserVersion.getBrowserVersionNumeric() >= 7.0f) || queryFromFields.length() > 0) {
                actionUrl = actionUrl + "?" + queryFromFields;
            }
            if (anchor.length() > 0) {
                actionUrl = actionUrl + "#" + anchor;
            }
            parameters.clear();
        }
        try {
            if (actionUrl.length() == 0) {
                url = htmlPage.getWebResponse().getRequestSettings().getUrl();
            } else if (actionUrl.startsWith("?")) {
                String urlString = htmlPage.getWebResponse().getRequestSettings().getUrl().toExternalForm();
                if (urlString.indexOf(63) != -1) {
                    urlString = urlString.substring(0, urlString.indexOf(63));
                }
                url = new URL(urlString + actionUrl);
            } else {
                url = htmlPage.getFullyQualifiedUrl(actionUrl);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Not a valid url: " + actionUrl);
        }
        WebRequestSettings settings = new WebRequestSettings(url, method);
        settings.setRequestParameters(parameters);
        settings.setEncodingType(FormEncodingType.getInstance(this.getEnctypeAttribute()));
        settings.setCharset(this.getSubmitCharset());
        settings.setAdditionalHeader("Referer", htmlPage.getWebResponse().getRequestSettings().getUrl().toExternalForm());
        WebWindow webWindow = htmlPage.getEnclosingWindow();
        return htmlPage.getWebClient().getPage(webWindow, htmlPage.getResolvedTarget(this.getTargetAttribute()), settings);
    }

    private String getSubmitCharset() {
        if (this.getAcceptCharsetAttribute().length() > 0) {
            return this.getAcceptCharsetAttribute().trim().replaceAll("[ ,].*", "");
        }
        return this.getPage().getPageEncoding();
    }

    private List<NameValuePair> getParameterListForSubmit(SubmittableElement submitElement) {
        Collection<SubmittableElement> submittableElements = this.getSubmittableElements(submitElement);
        ArrayList<NameValuePair> parameterList = new ArrayList<NameValuePair>(submittableElements.size());
        for (SubmittableElement element : submittableElements) {
            for (NameValuePair pair : element.getSubmitKeyValuePairs()) {
                parameterList.add(pair);
            }
        }
        return parameterList;
    }

    public Page reset() {
        SgmlPage htmlPage = this.getPage();
        ScriptResult scriptResult = this.fireEvent("reset");
        if (ScriptResult.isFalse(scriptResult)) {
            return scriptResult.getNewPage();
        }
        for (HtmlElement next : this.getAllHtmlChildElements()) {
            if (!(next instanceof SubmittableElement)) continue;
            ((SubmittableElement)((Object)next)).reset();
        }
        return htmlPage;
    }

    Collection<SubmittableElement> getSubmittableElements(SubmittableElement submitElement) {
        ArrayList<SubmittableElement> submittableElements = new ArrayList<SubmittableElement>();
        for (HtmlElement element : this.getAllHtmlChildElements()) {
            if (!this.isSubmittable(element, submitElement)) continue;
            submittableElements.add((SubmittableElement)((Object)element));
        }
        for (HtmlElement element : this.lostChildren_) {
            if (!this.isSubmittable(element, submitElement)) continue;
            submittableElements.add((SubmittableElement)((Object)element));
        }
        return submittableElements;
    }

    private boolean isValidForSubmission(HtmlElement element, SubmittableElement submitElement) {
        String type;
        String tagName = element.getTagName();
        if (!SUBMITTABLE_ELEMENT_NAMES.contains(tagName)) {
            return false;
        }
        if (element.hasAttribute("disabled")) {
            return false;
        }
        if (element == submitElement && element instanceof HtmlImageInput) {
            return true;
        }
        if (!tagName.equals("isindex") && !element.hasAttribute("name")) {
            return false;
        }
        if (!tagName.equals("isindex") && element.getAttribute("name").equals("")) {
            return false;
        }
        if (element instanceof HtmlInput && ((type = element.getAttribute("type").toLowerCase()).equals("radio") || type.equals("checkbox"))) {
            return element.hasAttribute("checked");
        }
        if (tagName.equals("select")) {
            return ((HtmlSelect)element).isValidForSubmission();
        }
        return true;
    }

    private boolean isSubmittable(HtmlElement element, SubmittableElement submitElement) {
        HtmlInput input;
        String type;
        String tagName = element.getTagName();
        if (!this.isValidForSubmission(element, submitElement)) {
            return false;
        }
        if (element == submitElement) {
            return true;
        }
        if (element instanceof HtmlInput && ((type = (input = (HtmlInput)element).getTypeAttribute().toLowerCase()).equals("submit") || type.equals("image") || type.equals("reset") || type.equals("button"))) {
            return false;
        }
        return !tagName.equals("button");
    }

    public List<HtmlSubmitInput> getSubmitButtons() throws ElementNotFoundException {
        List<HtmlSubmitInput> list = this.getElementsByAttribute("input", "type", "submit");
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlSubmitInput)) continue;
            list.add((HtmlSubmitInput)elt);
        }
        return list;
    }

    public HtmlSubmitInput getSubmitButton() throws ElementNotFoundException {
        return this.getSubmitButtons().get(0);
    }

    public List<HtmlInput> getInputsByName(String name) {
        List<HtmlInput> list = this.getElementsByAttribute("input", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlInput) || !name.equals(elt.getAttribute("name"))) continue;
            list.add((HtmlInput)elt);
        }
        return list;
    }

    public final <I extends HtmlInput> I getInputByName(String name) throws ElementNotFoundException {
        List<HtmlInput> inputs = this.getInputsByName(name);
        if (inputs.isEmpty()) {
            throw new ElementNotFoundException("input", "name", name);
        }
        return (I)inputs.get(0);
    }

    public List<HtmlSelect> getSelectsByName(String name) {
        List<HtmlSelect> list = this.getElementsByAttribute("select", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlSelect) || !name.equals(elt.getAttribute("name"))) continue;
            list.add((HtmlSelect)elt);
        }
        return list;
    }

    public HtmlSelect getSelectByName(String name) throws ElementNotFoundException {
        List<HtmlSelect> list = this.getSelectsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("select", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlButton> getButtonsByName(String name) {
        List<HtmlButton> list = this.getElementsByAttribute("button", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlButton) || !name.equals(elt.getAttribute("name"))) continue;
            list.add((HtmlButton)elt);
        }
        return list;
    }

    public HtmlButton getButtonByName(String name) throws ElementNotFoundException {
        List<HtmlButton> list = this.getButtonsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("button", "name", name);
        }
        return list.get(0);
    }

    public HtmlButton getButtonByCaption(String caption) throws ElementNotFoundException {
        for (HtmlElement b : this.getHtmlElementsByTagName("button")) {
            if (!b.getTextContent().trim().equals(caption)) continue;
            return (HtmlButton)b;
        }
        throw new ElementNotFoundException("button", "caption", caption);
    }

    public List<HtmlTextArea> getTextAreasByName(String name) {
        List<HtmlTextArea> list = this.getElementsByAttribute("textarea", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlTextArea) || !name.equals(elt.getAttribute("name"))) continue;
            list.add((HtmlTextArea)elt);
        }
        return list;
    }

    public HtmlTextArea getTextAreaByName(String name) throws ElementNotFoundException {
        List<HtmlTextArea> list = this.getTextAreasByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("textarea", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlRadioButtonInput> getRadioButtonsByName(String name) {
        WebAssert.notNull("name", name);
        ArrayList<HtmlRadioButtonInput> results = new ArrayList<HtmlRadioButtonInput>();
        for (HtmlInput element : this.getInputsByName(name)) {
            if (!(element instanceof HtmlRadioButtonInput)) continue;
            results.add((HtmlRadioButtonInput)element);
        }
        return results;
    }

    void setCheckedRadioButton(HtmlRadioButtonInput radioButtonInput) {
        if (!this.isAncestorOf(radioButtonInput) && !this.lostChildren_.contains(radioButtonInput)) {
            throw new IllegalArgumentException("HtmlRadioButtonInput is not child of this HtmlForm");
        }
        List<HtmlRadioButtonInput> radios = this.getRadioButtonsByName(radioButtonInput.getNameAttribute());
        for (HtmlRadioButtonInput input : radios) {
            if (input == radioButtonInput) {
                input.setAttribute("checked", "checked");
                continue;
            }
            input.removeAttribute("checked");
        }
    }

    public HtmlRadioButtonInput getCheckedRadioButton(String name) {
        WebAssert.notNull("name", name);
        for (HtmlRadioButtonInput input : this.getRadioButtonsByName(name)) {
            if (!input.isChecked()) continue;
            return input;
        }
        return null;
    }

    public final String getActionAttribute() {
        return this.getAttribute("action");
    }

    public final void setActionAttribute(String action) {
        this.setAttribute("action", action);
    }

    public final String getMethodAttribute() {
        return this.getAttribute("method");
    }

    public final void setMethodAttribute(String method) {
        this.setAttribute("method", method);
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttribute("name", name);
    }

    public final String getEnctypeAttribute() {
        return this.getAttribute("enctype");
    }

    public final void setEnctypeAttribute(String encoding) {
        this.setAttribute("enctype", encoding);
    }

    public final String getOnSubmitAttribute() {
        return this.getAttribute("onsubmit");
    }

    public final String getOnResetAttribute() {
        return this.getAttribute("onreset");
    }

    public final String getAcceptAttribute() {
        return this.getAttribute("accept");
    }

    public final String getAcceptCharsetAttribute() {
        return this.getAttribute("accept-charset");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    public final void setTargetAttribute(String target) {
        this.setAttribute("target", target);
    }

    public <I extends HtmlInput> I getInputByValue(String value) throws ElementNotFoundException {
        List<HtmlInput> list = this.getInputsByValue(value);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("input", "value", value);
        }
        return (I)list.get(0);
    }

    public List<HtmlInput> getInputsByValue(String value) {
        List<HtmlInput> results = this.getElementsByAttribute("input", "value", value);
        for (HtmlElement element : this.getLostChildren()) {
            if (!(element instanceof HtmlInput) || !value.equals(element.getAttribute("value"))) continue;
            results.add((HtmlInput)element);
        }
        return results;
    }

    void addLostChild(HtmlElement field) {
        this.lostChildren_.add(field);
        field.setOwningForm(this);
    }

    public List<HtmlElement> getLostChildren() {
        return this.lostChildren_;
    }

    @Override
    protected void preventDefault() {
        this.isPreventDefault_ = true;
    }
}

