/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.spring.web.context.support;

import javax.servlet.http.HttpSession;

import org.springframework.context.ApplicationEvent;

/**
 * Event about a HttpSession.
 * 
 * @author Eric Dalquist
 * @version $Revision$
 */
public abstract class HttpSessionEvent extends ApplicationEvent {
    private static final long serialVersionUID = 1L;

    /**
     * @param source The HttpSession the event is about.
     */
    public HttpSessionEvent(HttpSession source) {
        super(source);
    }

    public final HttpSession getSession() {
        return (HttpSession) super.getSource();
    }

}