/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.services.stats;

import org.jasig.portal.UserProfile;
import org.jasig.portal.events.EventPublisherLocator;
import org.jasig.portal.events.support.ChannelAddedToLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelMovedInLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelRemovedFromLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelUpdatedInLayoutPortalEvent;
import org.jasig.portal.events.support.UserAddedFolderToLayoutPortalEvent;
import org.jasig.portal.events.support.UserMovedFolderInLayoutPortalEvent;
import org.jasig.portal.events.support.UserRemovedFolderFromLayoutPortalEvent;
import org.jasig.portal.events.support.UserUpdatedFolderInLayoutPortalEvent;
import org.jasig.portal.layout.LayoutEvent;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.LayoutMoveEvent;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.security.IPerson;

/**
 * Listens to events generated by an <code>IUserLayoutManager</code>.
 * The information in the event is passed along to the
 * <code>StatsRecorder</code> service.
 * @author Ken Weiner, kweiner@unicon.net
 * @version $Revision: 19776 $
 */
public class StatsRecorderLayoutEventListener implements LayoutEventListener {
  
  IPerson person;
  UserProfile profile;

  /**
   * Constructor for <code>StatsRecorderLayoutEventListener</code>.
   * @param person the owner of the layout for which this listener is listening
   * @param profile the profile of the layout for which this listener is listening
   */  
  public StatsRecorderLayoutEventListener(IPerson person, UserProfile profile) {
    this.person = person;
    this.profile = profile;
  }
 
  // Channels...
  public void channelAdded(LayoutEvent ev) {
    IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
    EventPublisherLocator.getApplicationEventPublisher().publishEvent(new ChannelAddedToLayoutPortalEvent(this, person, profile, channelDesc, ev.getParentNode()));
  }
  
  public void channelUpdated(LayoutEvent ev) {
    IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
    EventPublisherLocator.getApplicationEventPublisher().publishEvent(new ChannelUpdatedInLayoutPortalEvent(this, person, profile, channelDesc, ev.getParentNode()));
  }
  
  public void channelMoved(LayoutMoveEvent ev) {
    IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
    EventPublisherLocator.getApplicationEventPublisher().publishEvent(new ChannelMovedInLayoutPortalEvent(this, person, profile, channelDesc, ev.getOldParentNode(), ev.getParentNode()));
  }
  
  public void channelDeleted(LayoutMoveEvent ev) {
	  IUserLayoutChannelDescription channelDesc = (IUserLayoutChannelDescription)ev.getNodeDescription();
	  EventPublisherLocator.getApplicationEventPublisher().publishEvent(new ChannelRemovedFromLayoutPortalEvent(this, person, profile, channelDesc, ev.getOldParentNode()));
  }

  // Folders...
  public void folderAdded(LayoutEvent ev) {
    IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
    EventPublisherLocator.getApplicationEventPublisher().publishEvent(new UserAddedFolderToLayoutPortalEvent(this, person, profile, folderDesc));
  }
  
  public void folderUpdated(LayoutEvent ev) {
    IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
    EventPublisherLocator.getApplicationEventPublisher().publishEvent(new UserUpdatedFolderInLayoutPortalEvent(this, person, profile, folderDesc));   
  }
  
  public void folderMoved(LayoutMoveEvent ev) {
    IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
    EventPublisherLocator.getApplicationEventPublisher().publishEvent(new UserMovedFolderInLayoutPortalEvent(this, person, profile, folderDesc));   
  }
  
  public void folderDeleted(LayoutMoveEvent ev) {
    IUserLayoutFolderDescription folderDesc = (IUserLayoutFolderDescription)ev.getNodeDescription();
    EventPublisherLocator.getApplicationEventPublisher().publishEvent(new UserRemovedFolderFromLayoutPortalEvent(this, person, profile, folderDesc));   
  }

  // Layout...
  public void layoutLoaded() {
  }
  
  public void layoutSaved() {
  }
}
