/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.portlets.registerportal.data;

import java.util.LinkedHashMap;
import java.util.Map;

import org.jasig.portal.portlets.registerportal.IPortalDataCollector;
import org.jasig.portal.tools.versioning.Version;
import org.jasig.portal.tools.versioning.VersionsManager;

/**
 * Gathers JVM System Properties
 * 
 * @author Eric Dalquist
 * @version $Revision: 19776 $
 */
public class PortalVersionsCollector implements IPortalDataCollector {
    
    /* (non-Javadoc)
     * @see org.jasig.portal.portlets.registerportal.IPortalDataCollector#getData()
     */
    public Map<String, String> getData() {
        final VersionsManager versionsManager = VersionsManager.getInstance();
        
        final Map<String, String> data = new LinkedHashMap<String, String>();
        
        final Version[] versions = versionsManager.getVersions();
        for (final Version version : versions) {
            data.put(version.getFname(), version.dottedTriple());
        }
        
        return data;
    }

    /* (non-Javadoc)
     * @see org.jasig.portal.portlets.registerportal.IPortalDataCollector#getKey()
     */
    public String getKey() {
        return "uPortalVersions";
    }
}
