/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Wrapper class to make com.oreilly.servlet.multipart.FilePart object
 * available as a DataSource.
 *
 * We have to buffer the data stream since the MimePart class will try to
 * read the stream several times (??) and we can't rewind the HttpRequest stream.
 * <p>
 * <b>Note</b>: The clients of this class must explictly call <code>dispose()</code> 
 * method to release temp files associated with this object.
 * </p>
 * 
 * @author George Lindholm, ITServices, UBC
 * @version $Revision: 19776 $
*/
package org.jasig.portal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartFile;

/**
 * @deprecated All IChannel implementations should be migrated to portlets
 */
@Deprecated
public class MultipartDataSource implements DataSource {
    private static final Log log = LogFactory.getLog(MultipartDataSource.class);

    java.io.File tempfile;
    ByteArrayOutputStream buff = null;
    String contentType = null;
    String filename = null;
    String errorMessage = null;
    boolean isAvailable = false;

    public MultipartDataSource(MultipartFile multipartFile) {
        contentType = multipartFile.getContentType();
        filename = multipartFile.getOriginalFilename();
        
        try {
            tempfile = java.io.File.createTempFile("uPdata", null);
            tempfile.deleteOnExit();
            
            multipartFile.transferTo(tempfile);
        }
        catch (IOException ioe) {
            log.error("MultipartDataSource unable to create temp file", ioe);
            if (tempfile != null) {
                try {
                    tempfile.delete();
                }
                catch (Exception e) {
                }
                tempfile = null;
            }
            buff = new ByteArrayOutputStream();
            
            try {
                buff.write(multipartFile.getBytes());
            }
            catch (IOException ioe2) {
                log.error("MultipartDataSource unable to store data in ByteArrayOutputStream", ioe2);
            }
        }
        this.isAvailable = true;
    }

    public MultipartDataSource(String fileName, String errorMessage) {
        this.filename = fileName;
        this.errorMessage = errorMessage;
        this.isAvailable = false;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    /**
     * Releases tempfile associated with this object any memory they consume
     * will be returned to the OS.
     * @since uPortal 2.5.  Prior to uPortal 2.5, tempfile deletion was a side effect
     * of the finalizer.
     */
    public void dispose() {
        buff = null;
        if (tempfile != null) {
            boolean success = tempfile.delete();
            if (!success) {
                log.error("Unable to delete temp file [" + tempfile.getPath() + "]");
            }

            tempfile = null;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!isAvailable())
            throw new IOException(this.getErrorMessage());

        if (tempfile != null) {
            return new BufferedInputStream(new FileInputStream(tempfile));
        }
        else {
            return new ByteArrayInputStream(buff.toByteArray());
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("getOutputStream() not implemented");
    }

    public String getContentType() {
        return contentType;
    }

    public String getName() {
        return filename;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

}
