/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.view;

import java.util.HashSet;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.SourceBase;
import org.graphstream.ui.view.ViewerListener;

public class ViewerPipe
extends SourceBase
implements ProxyPipe {
    private String id;
    protected ProxyPipe pipeIn;
    protected HashSet<ViewerListener> viewerListeners = new HashSet();

    protected ViewerPipe(String id, ProxyPipe pipeIn) {
        this.id = id;
        this.pipeIn = pipeIn;
        pipeIn.addSink(this);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void pump() {
        this.pipeIn.pump();
    }

    @Override
    public void blockingPump() throws InterruptedException {
        this.pipeIn.blockingPump();
    }

    @Override
    public void blockingPump(long timeout) throws InterruptedException {
        this.pipeIn.blockingPump(timeout);
    }

    public void addViewerListener(ViewerListener listener) {
        this.viewerListeners.add(listener);
    }

    public void removeViewerListener(ViewerListener listener) {
        this.viewerListeners.remove(listener);
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.sendEdgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.sendEdgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.sendEdgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.sendGraphAttributeAdded(sourceId, timeId, attribute, value);
        if (attribute.equals("ui.viewClosed") && value instanceof String) {
            for (ViewerListener listener : this.viewerListeners) {
                listener.viewClosed((String)value);
            }
            this.sendGraphAttributeRemoved(this.id, attribute);
        } else if (attribute.equals("ui.clicked") && value instanceof String) {
            for (ViewerListener listener : this.viewerListeners) {
                listener.buttonPushed((String)value);
            }
            this.sendGraphAttributeRemoved(this.id, attribute);
        }
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.sendGraphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.sendGraphAttributeRemoved(sourceId, timeId, attribute);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.sendNodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
        if (attribute.equals("ui.clicked")) {
            for (ViewerListener listener : this.viewerListeners) {
                listener.buttonPushed(nodeId);
            }
        }
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.sendNodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.sendNodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
        if (attribute.equals("ui.clicked")) {
            for (ViewerListener listener : this.viewerListeners) {
                listener.buttonReleased(nodeId);
            }
        }
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.sendEdgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.sendEdgeRemoved(sourceId, timeId, edgeId);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.sendGraphCleared(sourceId, timeId);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.sendNodeAdded(sourceId, timeId, nodeId);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.sendNodeRemoved(sourceId, timeId, nodeId);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.sendStepBegins(sourceId, timeId, step);
    }
}

