/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout.springbox.implementations;

import java.util.Iterator;
import org.graphstream.ui.geom.Vector3;
import org.graphstream.ui.layout.springbox.EdgeSpring;
import org.graphstream.ui.layout.springbox.Energies;
import org.graphstream.ui.layout.springbox.GraphCellData;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.graphstream.ui.layout.springbox.implementations.LinLog;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.ntree.Cell;

public class LinLogNodeParticle
extends NodeParticle {
    public LinLogNodeParticle(LinLog box, String id) {
        this(box, id, box.getRandom().nextDouble() * 2.0 * box.k - box.k, box.getRandom().nextDouble() * 2.0 * box.k - box.k, box.is3D() ? box.getRandom().nextDouble() * 2.0 * box.k - box.k : 0.0);
        this.box = box;
    }

    public LinLogNodeParticle(LinLog box, String id, double x, double y, double z) {
        super(box, id, x, y, z);
    }

    @Override
    protected void repulsionN2(Vector3 delta) {
        LinLog box = (LinLog)this.box;
        boolean is3D = box.is3D();
        ParticleBox nodes = box.getSpatialIndex();
        Energies energies = box.getEnergies();
        Iterator i = nodes.getParticleIdIterator();
        int deg = this.neighbours.size();
        while (i.hasNext()) {
            LinLogNodeParticle node = (LinLogNodeParticle)nodes.getParticle(i.next());
            if (node == this) continue;
            delta.set(node.pos.x - this.pos.x, node.pos.y - this.pos.y, is3D ? node.pos.z - this.pos.z : 0.0);
            double len = delta.length();
            if (!(len > 0.0)) continue;
            double degFactor = box.edgeBased ? (double)(deg * node.neighbours.size()) : 1.0;
            double factor = 1.0;
            double r = box.r;
            factor = -degFactor * Math.pow(len, r - 2.0) * node.weight * this.weight * box.rFactor;
            if (factor < -box.maxR) {
                factor = -box.maxR;
            }
            energies.accumulateEnergy(factor);
            delta.scalarMult(factor);
            this.disp.add(delta);
            this.repE += factor;
        }
    }

    @Override
    protected void repulsionNLogN(Vector3 delta) {
        this.recurseRepulsion(this.box.getSpatialIndex().getNTree().getRootCell(), delta);
    }

    protected void recurseRepulsion(Cell cell, Vector3 delta) {
        LinLog box = (LinLog)this.box;
        boolean is3D = box.is3D();
        Energies energies = box.getEnergies();
        int deg = this.neighbours.size();
        if (this.intersection(cell)) {
            if (cell.isLeaf()) {
                Iterator i = cell.getParticles();
                while (i.hasNext()) {
                    LinLogNodeParticle node = (LinLogNodeParticle)((Object)i.next());
                    if (node == this) continue;
                    delta.set(node.pos.x - this.pos.x, node.pos.y - this.pos.y, is3D ? node.pos.z - this.pos.z : 0.0);
                    double len = delta.length();
                    if (!(len > 0.0)) continue;
                    double degFactor = box.edgeBased ? (double)(deg * node.neighbours.size()) : 1.0;
                    double factor = 1.0;
                    double r = box.r;
                    factor = -degFactor * Math.pow(len, r - 2.0) * node.weight * this.weight * box.rFactor;
                    if (factor < -box.maxR) {
                        factor = -box.maxR;
                    }
                    energies.accumulateEnergy(factor);
                    delta.scalarMult(factor);
                    this.disp.add(delta);
                    this.repE += factor;
                }
            } else {
                int div = cell.getSpace().getDivisions();
                for (int i = 0; i < div; ++i) {
                    this.recurseRepulsion(cell.getSub(i), delta);
                }
            }
        } else if (cell != this.cell) {
            GraphCellData bary = (GraphCellData)cell.getData();
            double dist = bary.distanceFrom(this.pos);
            double size = cell.getSpace().getSize();
            if (!cell.isLeaf() && size / dist > box.getBarnesHutTheta()) {
                int div = cell.getSpace().getDivisions();
                for (int i = 0; i < div; ++i) {
                    this.recurseRepulsion(cell.getSub(i), delta);
                }
            } else if (bary.weight != 0.0) {
                delta.set(bary.center.x - this.pos.x, bary.center.y - this.pos.y, is3D ? bary.center.z - this.pos.z : 0.0);
                double len = delta.length();
                if (len > 0.0) {
                    double degFactor = box.edgeBased ? (double)deg * bary.degree : 1.0;
                    double factor = 1.0;
                    double r = box.r;
                    factor = -degFactor * Math.pow(len, r - 2.0) * bary.weight * this.weight * box.rFactor;
                    if (factor < -box.maxR) {
                        factor = -box.maxR;
                    }
                    energies.accumulateEnergy(factor);
                    delta.scalarMult(factor);
                    this.disp.add(delta);
                    this.repE += factor;
                }
            }
        }
    }

    @Override
    protected void attraction(Vector3 delta) {
        LinLog box = (LinLog)this.box;
        boolean is3D = box.is3D();
        Energies energies = box.getEnergies();
        for (EdgeSpring edge : this.neighbours) {
            if (edge.ignored) continue;
            LinLogNodeParticle other = (LinLogNodeParticle)edge.getOpposite(this);
            delta.set(other.pos.x - this.pos.x, other.pos.y - this.pos.y, is3D ? other.pos.z - this.pos.z : 0.0);
            double len = delta.length();
            if (!(len > 0.0)) continue;
            double factor = 1.0;
            double a = box.a;
            factor = Math.pow(len, a - 2.0) * edge.weight * box.aFactor;
            energies.accumulateEnergy(factor);
            delta.scalarMult(factor);
            this.disp.add(delta);
            this.attE += factor;
        }
    }

    @Override
    protected void gravity(Vector3 delta) {
    }

    protected boolean intersection(Cell cell) {
        LinLog box = (LinLog)this.box;
        double k = box.k;
        double vz = box.getViewZone();
        double x1 = cell.getSpace().getLoAnchor().x;
        double y1 = cell.getSpace().getLoAnchor().y;
        double z1 = cell.getSpace().getLoAnchor().z;
        double x2 = cell.getSpace().getHiAnchor().x;
        double y2 = cell.getSpace().getHiAnchor().y;
        double z2 = cell.getSpace().getHiAnchor().z;
        double X1 = this.pos.x - k * vz;
        double Y1 = this.pos.y - k * vz;
        double Z1 = this.pos.z - k * vz;
        double X2 = this.pos.x + k * vz;
        double Y2 = this.pos.y + k * vz;
        double Z2 = this.pos.z + k * vz;
        if (X2 < x1 || X1 > x2) {
            return false;
        }
        if (Y2 < y1 || Y1 > y2) {
            return false;
        }
        return !(Z2 < z1) && !(Z1 > z2);
    }
}

