/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupListener;
import org.graphstream.ui.graphicGraph.stylesheet.Rule;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheet;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheetListener;

public class StyleGroupSet
implements StyleSheetListener {
    protected StyleSheet stylesheet;
    protected final Map<String, StyleGroup> groups = new TreeMap<String, StyleGroup>();
    protected final Map<String, String> byNodeIdGroups = new TreeMap<String, String>();
    protected final Map<String, String> byEdgeIdGroups = new TreeMap<String, String>();
    protected final Map<String, String> bySpriteIdGroups = new TreeMap<String, String>();
    protected final Map<String, String> byGraphIdGroups = new TreeMap<String, String>();
    protected NodeSet nodeSet = new NodeSet();
    protected EdgeSet edgeSet = new EdgeSet();
    protected SpriteSet spriteSet = new SpriteSet();
    protected GraphSet graphSet = new GraphSet();
    protected EventSet eventSet = new EventSet();
    protected ZIndex zIndex = new ZIndex();
    protected ShadowSet shadow = new ShadowSet();
    protected boolean removeEmptyGroups = true;
    protected ArrayList<StyleGroupListener> listeners = new ArrayList();

    public StyleGroupSet(StyleSheet stylesheet) {
        this.stylesheet = stylesheet;
        stylesheet.addListener(this);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public StyleGroup getGroup(String groupId) {
        return this.groups.get(groupId);
    }

    public Iterator<? extends StyleGroup> getGroupIterator() {
        return this.groups.values().iterator();
    }

    public Iterable<? extends StyleGroup> groups() {
        return this.groups.values();
    }

    public Iterator<HashSet<StyleGroup>> getZIterator() {
        return this.zIndex.getIterator();
    }

    public Iterable<HashSet<StyleGroup>> zIndex() {
        return this.zIndex;
    }

    public Iterator<StyleGroup> getShadowIterator() {
        return this.shadow.getIterator();
    }

    public Iterable<StyleGroup> shadows() {
        return this.shadow;
    }

    public boolean containsNode(String id) {
        return this.byNodeIdGroups.containsKey(id);
    }

    public boolean containsEdge(String id) {
        return this.byEdgeIdGroups.containsKey(id);
    }

    public boolean containsSprite(String id) {
        return this.bySpriteIdGroups.containsKey(id);
    }

    public boolean containsGraph(String id) {
        return this.byGraphIdGroups.containsKey(id);
    }

    protected Element getElement(String id, Map<String, String> elt2grp) {
        String gid = elt2grp.get(id);
        if (gid != null) {
            StyleGroup group = this.groups.get(gid);
            return group.getElement(id);
        }
        return null;
    }

    public Node getNode(String id) {
        return (Node)this.getElement(id, this.byNodeIdGroups);
    }

    public Edge getEdge(String id) {
        return (Edge)this.getElement(id, this.byEdgeIdGroups);
    }

    public GraphicSprite getSprite(String id) {
        return (GraphicSprite)this.getElement(id, this.bySpriteIdGroups);
    }

    public Graph getGraph(String id) {
        return (Graph)this.getElement(id, this.byGraphIdGroups);
    }

    public int getNodeCount() {
        return this.byNodeIdGroups.size();
    }

    public int getEdgeCount() {
        return this.byEdgeIdGroups.size();
    }

    public int getSpriteCount() {
        return this.bySpriteIdGroups.size();
    }

    public Iterator<? extends Node> getNodeIterator() {
        return new ElementIterator(this.byNodeIdGroups);
    }

    public Iterator<? extends Graph> getGraphIterator() {
        return new ElementIterator(this.byGraphIdGroups);
    }

    public Iterable<? extends Node> nodes() {
        return this.nodeSet;
    }

    public Iterable<? extends Graph> graphs() {
        return this.graphSet;
    }

    public Iterator<? extends Edge> getEdgeIterator() {
        return new ElementIterator(this.byEdgeIdGroups);
    }

    public Iterable<? extends Edge> edges() {
        return this.edgeSet;
    }

    public Iterator<? extends GraphicSprite> getSpriteIterator() {
        return new ElementIterator(this.bySpriteIdGroups);
    }

    public Iterable<? extends GraphicSprite> sprites() {
        return this.spriteSet;
    }

    public String getElementGroup(Element element) {
        if (element instanceof Node) {
            return this.byNodeIdGroups.get(element.getId());
        }
        if (element instanceof Edge) {
            return this.byEdgeIdGroups.get(element.getId());
        }
        if (element instanceof GraphicSprite) {
            return this.bySpriteIdGroups.get(element.getId());
        }
        if (element instanceof Graph) {
            return this.byGraphIdGroups.get(element.getId());
        }
        throw new RuntimeException("What ?");
    }

    public StyleGroup getStyleForElement(Element element) {
        String gid = this.getElementGroup(element);
        return this.groups.get(gid);
    }

    public StyleGroup getStyleFor(Node node) {
        String gid = this.byNodeIdGroups.get(node.getId());
        return this.groups.get(gid);
    }

    public StyleGroup getStyleFor(Edge edge) {
        String gid = this.byEdgeIdGroups.get(edge.getId());
        return this.groups.get(gid);
    }

    public StyleGroup getStyleFor(GraphicSprite sprite) {
        String gid = this.bySpriteIdGroups.get(sprite.getId());
        return this.groups.get(gid);
    }

    public StyleGroup getStyleFor(Graph graph) {
        String gid = this.byGraphIdGroups.get(graph.getId());
        return this.groups.get(gid);
    }

    public boolean areEmptyGroupRemoved() {
        return this.removeEmptyGroups;
    }

    public ZIndex getZIndex() {
        return this.zIndex;
    }

    public ShadowSet getShadowSet() {
        return this.shadow;
    }

    public void release() {
        this.stylesheet.removeListener(this);
    }

    public void clear() {
        this.byEdgeIdGroups.clear();
        this.byNodeIdGroups.clear();
        this.bySpriteIdGroups.clear();
        this.byGraphIdGroups.clear();
        this.groups.clear();
        this.zIndex.clear();
        this.shadow.clear();
    }

    public void setRemoveEmptyGroups(boolean on) {
        if (!this.removeEmptyGroups && on) {
            Iterator<StyleGroup> i = this.groups.values().iterator();
            while (i.hasNext()) {
                StyleGroup g = i.next();
                if (!g.isEmpty()) continue;
                i.remove();
            }
        }
        this.removeEmptyGroups = on;
    }

    protected StyleGroup addGroup(String id, ArrayList<Rule> rules, Element firstElement) {
        StyleGroup group = new StyleGroup(id, rules, firstElement, this.eventSet);
        this.groups.put(id, group);
        this.zIndex.groupAdded(group);
        this.shadow.groupAdded(group);
        return group;
    }

    protected void removeGroup(StyleGroup group) {
        this.zIndex.groupRemoved(group);
        this.shadow.groupRemoved(group);
        this.groups.remove(group.getId());
        group.release();
    }

    public StyleGroup addElement(Element element) {
        StyleGroup group = this.addElement_(element);
        for (StyleGroupListener listener : this.listeners) {
            listener.elementStyleChanged(element, null, group);
        }
        return group;
    }

    protected StyleGroup addElement_(Element element) {
        ArrayList<Rule> rules = this.stylesheet.getRulesFor(element);
        String gid = this.stylesheet.getStyleGroupIdFor(element, rules);
        StyleGroup group = this.groups.get(gid);
        if (group == null) {
            group = this.addGroup(gid, rules, element);
        } else {
            group.addElement(element);
        }
        this.addElementToReverseSearch(element, gid);
        return group;
    }

    public void removeElement(Element element) {
        String gid = this.getElementGroup(element);
        if (null == gid) {
            return;
        }
        StyleGroup group = this.groups.get(gid);
        if (group != null) {
            group.removeElement(element);
            this.removeElementFromReverseSearch(element);
            if (this.removeEmptyGroups && group.isEmpty()) {
                this.removeGroup(group);
            }
        }
    }

    public void checkElementStyleGroup(Element element) {
        StyleGroup oldGroup = this.getGroup(this.getElementGroup(element));
        boolean isDyn = false;
        StyleGroup.ElementEvents events = null;
        if (oldGroup != null) {
            isDyn = oldGroup.isElementDynamic(element);
            events = oldGroup.getEventsFor(element);
        }
        this.removeElement(element);
        this.addElement_(element);
        StyleGroup newGroup = this.getGroup(this.getElementGroup(element));
        if (newGroup != null && events != null) {
            for (String event : events.events) {
                this.pushEventFor(element, event);
            }
        }
        for (StyleGroupListener listener : this.listeners) {
            listener.elementStyleChanged(element, oldGroup, newGroup);
        }
        if (newGroup != null && isDyn) {
            newGroup.pushElementAsDynamic(element);
        }
    }

    protected void addElementToReverseSearch(Element element, String groupId) {
        if (element instanceof Node) {
            this.byNodeIdGroups.put(element.getId(), groupId);
        } else if (element instanceof Edge) {
            this.byEdgeIdGroups.put(element.getId(), groupId);
        } else if (element instanceof GraphicSprite) {
            this.bySpriteIdGroups.put(element.getId(), groupId);
        } else if (element instanceof Graph) {
            this.byGraphIdGroups.put(element.getId(), groupId);
        } else {
            throw new RuntimeException("What ?");
        }
    }

    protected void removeElementFromReverseSearch(Element element) {
        if (element instanceof Node) {
            this.byNodeIdGroups.remove(element.getId());
        } else if (element instanceof Edge) {
            this.byEdgeIdGroups.remove(element.getId());
        } else if (element instanceof GraphicSprite) {
            this.bySpriteIdGroups.remove(element.getId());
        } else if (element instanceof Graph) {
            this.byGraphIdGroups.remove(element.getId());
        } else {
            throw new RuntimeException("What ?");
        }
    }

    public void pushEvent(String event) {
        this.eventSet.pushEvent(event);
    }

    public void pushEventFor(Element element, String event) {
        StyleGroup group = this.getGroup(this.getElementGroup(element));
        if (group != null) {
            group.pushEventFor(element, event);
        }
    }

    public void popEvent(String event) {
        this.eventSet.popEvent(event);
    }

    public void popEventFor(Element element, String event) {
        StyleGroup group = this.getGroup(this.getElementGroup(element));
        if (group != null) {
            group.popEventFor(element, event);
        }
    }

    public void pushElementAsDynamic(Element element) {
        StyleGroup group = this.getGroup(this.getElementGroup(element));
        if (group != null) {
            group.pushElementAsDynamic(element);
        }
    }

    public void popElementAsDynamic(Element element) {
        StyleGroup group = this.getGroup(this.getElementGroup(element));
        if (group != null) {
            group.popElementAsDynamic(element);
        }
    }

    public void addListener(StyleGroupListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(StyleGroupListener listener) {
        int index = this.listeners.lastIndexOf(listener);
        if (index >= 0) {
            this.listeners.remove(index);
        }
    }

    @Override
    public void styleAdded(Rule oldRule, Rule newRule) {
        if (oldRule == null) {
            this.checkForNewStyle(newRule);
        } else {
            this.checkZIndexAndShadow(oldRule, newRule);
        }
    }

    @Override
    public void styleSheetCleared() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element element : this.graphs()) {
            elements.add(element);
        }
        for (Element element : this.nodes()) {
            elements.add(element);
        }
        for (Element element : this.edges()) {
            elements.add(element);
        }
        for (Element element : this.sprites()) {
            elements.add(element);
        }
        this.clear();
        for (Element element : elements) {
            this.removeElement(element);
        }
        for (Element element : elements) {
            this.addElement(element);
        }
    }

    protected void checkZIndexAndShadow(Rule oldRule, Rule newRule) {
        block2: {
            block3: {
                if (oldRule == null) break block2;
                if (oldRule.selector.getId() == null && oldRule.selector.getClazz() == null) break block3;
                if (oldRule.getGroups() == null) break block2;
                for (String s : oldRule.getGroups()) {
                    StyleGroup group = this.groups.get(s);
                    if (group == null) continue;
                    this.zIndex.groupChanged(group);
                    this.shadow.groupChanged(group);
                }
                break block2;
            }
            Selector.Type type = oldRule.selector.type;
            for (StyleGroup group : this.groups.values()) {
                if (group.getType() != type) continue;
                this.zIndex.groupChanged(group);
                this.shadow.groupChanged(group);
            }
        }
    }

    protected void checkForNewStyle(Rule newRule) {
        switch (newRule.selector.type) {
            case GRAPH: {
                if (newRule.selector.getId() != null) {
                    this.checkForNewIdStyle(newRule, this.byGraphIdGroups);
                    break;
                }
                this.checkForNewStyle(newRule, this.byGraphIdGroups);
                break;
            }
            case NODE: {
                if (newRule.selector.getId() != null) {
                    this.checkForNewIdStyle(newRule, this.byNodeIdGroups);
                    break;
                }
                this.checkForNewStyle(newRule, this.byNodeIdGroups);
                break;
            }
            case EDGE: {
                if (newRule.selector.getId() != null) {
                    this.checkForNewIdStyle(newRule, this.byEdgeIdGroups);
                    break;
                }
                this.checkForNewStyle(newRule, this.byEdgeIdGroups);
                break;
            }
            case SPRITE: {
                if (newRule.selector.getId() != null) {
                    this.checkForNewIdStyle(newRule, this.bySpriteIdGroups);
                    break;
                }
                this.checkForNewStyle(newRule, this.bySpriteIdGroups);
                break;
            }
            default: {
                throw new RuntimeException("What ?");
            }
        }
    }

    protected void checkForNewIdStyle(Rule newRule, Map<String, String> elt2grp) {
        Element element = this.getElement(newRule.selector.getId(), elt2grp);
        if (element != null) {
            this.checkElementStyleGroup(element);
        }
    }

    protected void checkForNewStyle(Rule newRule, Map<String, String> elt2grp) {
        ArrayList<Element> elementsToCheck = new ArrayList<Element>();
        for (String eltId : elt2grp.keySet()) {
            elementsToCheck.add(this.getElement(eltId, elt2grp));
        }
        for (Element element : elementsToCheck) {
            this.checkElementStyleGroup(element);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Style groups (%d) :%n", this.groups.size()));
        for (StyleGroup group : this.groups.values()) {
            builder.append(group.toString(1));
            builder.append(String.format("%n", new Object[0]));
        }
        return builder.toString();
    }

    protected class GraphSet
    implements Iterable<GraphicGraph> {
        protected GraphSet() {
        }

        @Override
        public Iterator<GraphicGraph> iterator() {
            return StyleGroupSet.this.getGraphIterator();
        }
    }

    protected class SpriteSet
    implements Iterable<GraphicSprite> {
        protected SpriteSet() {
        }

        @Override
        public Iterator<GraphicSprite> iterator() {
            return StyleGroupSet.this.getSpriteIterator();
        }
    }

    protected class EdgeSet
    implements Iterable<Edge> {
        protected EdgeSet() {
        }

        @Override
        public Iterator<Edge> iterator() {
            return StyleGroupSet.this.getEdgeIterator();
        }
    }

    protected class NodeSet
    implements Iterable<Node> {
        protected NodeSet() {
        }

        @Override
        public Iterator<Node> iterator() {
            return StyleGroupSet.this.getNodeIterator();
        }
    }

    protected class ElementIterator<E extends Element>
    implements Iterator<E> {
        protected Map<String, String> elt2grp;
        protected Iterator<String> elts;

        public ElementIterator(Map<String, String> elements2groups) {
            this.elt2grp = elements2groups;
            this.elts = elements2groups.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.elts.hasNext();
        }

        @Override
        public E next() {
            String eid = this.elts.next();
            String gid = this.elt2grp.get(eid);
            StyleGroup grp = StyleGroupSet.this.groups.get(gid);
            return (E)grp.getElement(eid);
        }

        @Override
        public void remove() {
            throw new RuntimeException("remove not implemented in this iterator");
        }
    }

    public class ShadowSet
    implements Iterable<StyleGroup> {
        protected HashSet<StyleGroup> shadowSet = new HashSet();

        protected Iterator<StyleGroup> getIterator() {
            return this.shadowSet.iterator();
        }

        @Override
        public Iterator<StyleGroup> iterator() {
            return this.getIterator();
        }

        protected void groupAdded(StyleGroup group) {
            if (group.getShadowMode() != StyleConstants.ShadowMode.NONE) {
                this.shadowSet.add(group);
            }
        }

        protected void groupChanged(StyleGroup group) {
            if (group.getShadowMode() == StyleConstants.ShadowMode.NONE) {
                this.shadowSet.remove(group);
            } else {
                this.shadowSet.add(group);
            }
        }

        protected void groupRemoved(StyleGroup group) {
            this.shadowSet.remove(group);
        }

        protected void clear() {
            this.shadowSet.clear();
        }
    }

    public class ZIndex
    implements Iterable<HashSet<StyleGroup>> {
        public ArrayList<HashSet<StyleGroup>> zIndex = new ArrayList();
        public HashMap<String, Integer> reverseZIndex = new HashMap();

        public ZIndex() {
            this.initZIndex();
        }

        protected void initZIndex() {
            this.zIndex.ensureCapacity(256);
            for (int i = 0; i < 256; ++i) {
                this.zIndex.add(null);
            }
        }

        protected Iterator<HashSet<StyleGroup>> getIterator() {
            return new ZIndexIterator();
        }

        @Override
        public Iterator<HashSet<StyleGroup>> iterator() {
            return this.getIterator();
        }

        protected void groupAdded(StyleGroup group) {
            int z = this.convertZ(group.getZIndex());
            if (this.zIndex.get(z) == null) {
                this.zIndex.set(z, new HashSet());
            }
            this.zIndex.get(z).add(group);
            this.reverseZIndex.put(group.getId(), z);
        }

        protected void groupChanged(StyleGroup group) {
            int newZ;
            int oldZ = this.reverseZIndex.get(group.getId());
            if (oldZ != (newZ = this.convertZ(group.getZIndex()))) {
                HashSet<StyleGroup> map = this.zIndex.get(oldZ);
                if (map != null) {
                    map.remove(group);
                    this.reverseZIndex.remove(group.getId());
                    if (map.isEmpty()) {
                        this.zIndex.set(oldZ, null);
                    }
                }
                this.groupAdded(group);
            }
        }

        protected void groupRemoved(StyleGroup group) {
            int z = this.convertZ(group.getZIndex());
            HashSet<StyleGroup> map = this.zIndex.get(z);
            if (map != null) {
                map.remove(group);
                this.reverseZIndex.remove(group.getId());
                if (map.isEmpty()) {
                    this.zIndex.set(z, null);
                }
            } else {
                throw new RuntimeException("Inconsistency in Z-index");
            }
        }

        public void clear() {
            this.zIndex.clear();
            this.reverseZIndex.clear();
            this.initZIndex();
        }

        protected int convertZ(int z) {
            if ((z += 127) < 0) {
                z = 0;
            } else if (z > 255) {
                z = 255;
            }
            return z;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Z index :%n", new Object[0]));
            for (int i = 0; i < 256; ++i) {
                if (this.zIndex.get(i) == null) continue;
                sb.append(String.format("    * %d -> ", i - 127));
                HashSet<StyleGroup> map = this.zIndex.get(i);
                for (StyleGroup g : map) {
                    sb.append(String.format("%s ", g.getId()));
                }
                sb.append(String.format("%n", new Object[0]));
            }
            return sb.toString();
        }

        public class ZIndexIterator
        implements Iterator<HashSet<StyleGroup>> {
            public int index = 0;

            public ZIndexIterator() {
                this.zapUntilACell();
            }

            protected void zapUntilACell() {
                while (this.index < 256 && ZIndex.this.zIndex.get(this.index) == null) {
                    ++this.index;
                }
            }

            @Override
            public boolean hasNext() {
                return this.index < 256;
            }

            @Override
            public HashSet<StyleGroup> next() {
                if (this.hasNext()) {
                    HashSet<StyleGroup> cell = ZIndex.this.zIndex.get(this.index);
                    ++this.index;
                    this.zapUntilACell();
                    return cell;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new RuntimeException("This iterator does not support removal.");
            }
        }
    }

    public class EventSet {
        public ArrayList<String> eventSet = new ArrayList();
        public String[] events = new String[0];

        public void pushEvent(String event) {
            this.eventSet.add(event);
            this.events = this.eventSet.toArray(this.events);
        }

        public void popEvent(String event) {
            int index = this.eventSet.lastIndexOf(event);
            if (index >= 0) {
                this.eventSet.remove(index);
            }
            this.events = this.eventSet.toArray(this.events);
        }

        public String[] getEvents() {
            return this.events;
        }
    }
}

