/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin.tools;

import groovy.lang.GroovyRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.grails.launcher.GrailsLauncher;
import org.grails.launcher.RootLoader;

public class ForkedGrailsRuntime {
    private ExecutionContext executionContext;
    private int maxMemory = 1024;
    private int minMemory = 512;
    private int maxPerm = 256;
    private boolean debug;
    private File reloadingAgent;

    public ForkedGrailsRuntime(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
    }

    public void setMinMemory(int minMemory) {
        this.minMemory = minMemory;
    }

    public void setMaxPerm(int maxPerm) {
        this.maxPerm = maxPerm;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void fork() {
        block26: {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            StringBuilder cp = new StringBuilder();
            for (File file : this.executionContext.getBuildDependencies()) {
                cp.append(file).append(File.pathSeparator);
            }
            FileOutputStream fos = null;
            File tempFile = null;
            try {
                String baseName = this.executionContext.getBaseDir().getCanonicalFile().getName();
                tempFile = File.createTempFile(baseName, "grails-execution-context");
                tempFile.deleteOnExit();
                fos = new FileOutputStream(tempFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this.executionContext);
                ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("java", "-Xmx" + this.maxMemory + "M", "-Xms" + this.minMemory + "M", "-XX:MaxPermSize=" + this.maxPerm + "m", "-Dgrails.build.execution.context=" + tempFile.getCanonicalPath(), "-cp", cp.toString()));
                if (this.debug) {
                    cmd.addAll(Arrays.asList("-Xdebug", "-Xnoagent", "-Dgrails.full.stacktrace=true", "-Djava.compiler=NONE", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005"));
                }
                if (this.reloadingAgent != null) {
                    cmd.addAll(Arrays.asList("-javaagent:" + this.reloadingAgent.getCanonicalPath(), "-noverify", "-Dspringloaded=profile=grails"));
                }
                if (null != this.executionContext.getForkedVmArgs() && this.executionContext.getForkedVmArgs().size() > 0) {
                    cmd.addAll(this.executionContext.getForkedVmArgs());
                }
                if (this.executionContext.grailsBuildListener != null) {
                    cmd.add("-Dgrails.build.listeners=" + this.executionContext.grailsBuildListener);
                }
                if (this.executionContext.dependencyFileLocation != null) {
                    cmd.add("-Dorg.grails.ide.eclipse.dependencies.filename=" + this.executionContext.dependencyFileLocation);
                }
                cmd.add(this.getClass().getName());
                processBuilder.directory(this.executionContext.baseDir).redirectErrorStream(false).command(cmd);
                Process process = processBuilder.start();
                InputStream is = process.getInputStream();
                InputStream es = process.getErrorStream();
                Thread t1 = new Thread(new TextDumper(is, System.out));
                Thread t2 = new Thread(new TextDumper(es, System.err));
                t1.start();
                t2.start();
                int result = process.waitFor();
                if (result != 1) break block26;
                try {
                    t1.join();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    t1.join();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    es.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                try {
                    is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw new RuntimeException("Forked Grails VM exited with error");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Fatal error forking Grails JVM: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Fatal error forking Grails JVM: " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Fatal error forking Grails JVM: " + e.getMessage(), e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String location = System.getProperty("grails.build.execution.context");
        if (location != null) {
            File f = new File(location);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fis);
                ExecutionContext ec = (ExecutionContext)ois.readObject();
                URL[] urls = ForkedGrailsRuntime.generateBuildPath(ec.getBuildDependencies());
                RootLoader rootLoader = new RootLoader(urls, ClassLoader.getSystemClassLoader());
                System.setProperty("grails.console.enable.terminal", "false");
                System.setProperty("grails.console.enable.interactive", "false");
                List<File> compileDependencies = ec.getCompileDependencies();
                ForkedGrailsRuntime.addLoggingJarsToRootLoader(rootLoader, compileDependencies);
                GrailsLauncher launcher = new GrailsLauncher((ClassLoader)rootLoader, null, ec.getBaseDir().getAbsolutePath());
                launcher.setPlainOutput(true);
                launcher.setDependenciesExternallyConfigured(true);
                launcher.setProvidedDependencies(ec.getProvidedDependencies());
                launcher.setCompileDependencies(compileDependencies);
                launcher.setTestDependencies(ec.getTestDependencies());
                launcher.setRuntimeDependencies(ec.getRuntimeDependencies());
                launcher.setGrailsWorkDir(ec.getGrailsWorkDir());
                launcher.setProjectWorkDir(ec.getProjectWorkDir());
                launcher.setClassesDir(ec.getClassesDir());
                launcher.setTestClassesDir(ec.getTestClassesDir());
                launcher.setResourcesDir(ec.getResourcesDir());
                launcher.setProjectPluginsDir(ec.getProjectPluginsDir());
                launcher.setBuildDependencies(ec.getBuildDependencies());
                System.exit(launcher.launch(ec.getScriptName(), ec.getArgs(), ec.getEnv()));
            }
            catch (FileNotFoundException e) {
                ForkedGrailsRuntime.fatalError(e);
            }
            catch (ClassNotFoundException e) {
                ForkedGrailsRuntime.fatalError(e);
            }
            catch (IOException e) {
                ForkedGrailsRuntime.fatalError(e);
            }
            catch (Throwable e) {
                ForkedGrailsRuntime.fatalError(e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            System.exit(1);
        }
    }

    public static void addLoggingJarsToRootLoader(RootLoader rootLoader, List<File> compileDependencies) throws MalformedURLException, ClassNotFoundException {
        ArrayList<File> loggingBootstrapJars = new ArrayList<File>();
        for (File file : compileDependencies) {
            String name = file.getName();
            if (!name.contains("slf4j") && !name.contains("log4j") && !name.contains("spring-core")) continue;
            loggingBootstrapJars.add(file);
        }
        if (!loggingBootstrapJars.isEmpty()) {
            for (File loggingBootstrapJar : loggingBootstrapJars) {
                rootLoader.addURL(loggingBootstrapJar.toURI().toURL());
            }
            Class cls = rootLoader.loadClass("org.springframework.util.Log4jConfigurer");
            ForkedGrailsRuntime.invokeStaticMethod(cls, "initLogging", new Object[]{"classpath:grails-maven/log4j.properties"});
        }
    }

    protected static void fatalError(Throwable e) {
        System.out.println();
        System.out.println("Fatal error forking Grails JVM: " + e.getMessage());
        e.printStackTrace(System.out);
        System.out.flush();
        System.exit(1);
    }

    private static URL[] generateBuildPath(List<File> systemDependencies) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File systemDependency : systemDependencies) {
            try {
                urls.add(systemDependency.toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static Object invokeStaticMethod(Class target, String name, Object[] args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        try {
            return target.getMethod(name, argTypes).invoke((Object)target, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setReloadingAgent(File file) {
        this.reloadingAgent = file;
    }

    private static class TextDumper
    implements Runnable {
        InputStream in;
        Appendable app;

        public TextDumper(InputStream in, Appendable app) {
            this.in = in;
            this.app = app;
        }

        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(this.in);
            BufferedReader br = new BufferedReader(isr);
            try {
                String next;
                while ((next = br.readLine()) != null) {
                    if (this.app == null) continue;
                    this.app.append(next);
                    this.app.append("\n");
                }
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("exception while reading process stream", (Throwable)e);
            }
        }
    }

    public static class ExecutionContext
    implements Serializable {
        private List<File> compileDependencies;
        private List<File> runtimeDependencies;
        private List<File> buildDependencies;
        private List<File> providedDependencies;
        private List<File> testDependencies;
        private List forkedVmArgs;
        private File grailsWorkDir;
        private File projectWorkDir;
        private File classesDir;
        private File testClassesDir;
        private File resourcesDir;
        private File projectPluginsDir;
        private File baseDir;
        private File dependencyFileLocation;
        private String scriptName;
        private String env;
        private String args;
        private String grailsBuildListener;

        public String getScriptName() {
            return this.scriptName;
        }

        public void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public String getEnv() {
            return this.env;
        }

        public void setEnv(String env) {
            this.env = env;
        }

        public String getArgs() {
            return this.args;
        }

        public void setArgs(String args) {
            this.args = args;
        }

        public List<String> getForkedVmArgs() {
            return this.forkedVmArgs;
        }

        public void setForkedVmArgs(List<String> forkedVmArgs) {
            this.forkedVmArgs = forkedVmArgs;
        }

        public File getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(File baseDir) {
            this.baseDir = baseDir;
        }

        public List<File> getCompileDependencies() {
            return this.compileDependencies;
        }

        public void setCompileDependencies(List<File> compileDependencies) {
            this.compileDependencies = compileDependencies;
        }

        public List<File> getRuntimeDependencies() {
            return this.runtimeDependencies;
        }

        public void setRuntimeDependencies(List<File> runtimeDependencies) {
            this.runtimeDependencies = runtimeDependencies;
        }

        public List<File> getBuildDependencies() {
            return this.buildDependencies;
        }

        public void setBuildDependencies(List<File> buildDependencies) {
            this.buildDependencies = buildDependencies;
        }

        public List<File> getProvidedDependencies() {
            return this.providedDependencies;
        }

        public void setProvidedDependencies(List<File> providedDependencies) {
            this.providedDependencies = providedDependencies;
        }

        public List<File> getTestDependencies() {
            return this.testDependencies;
        }

        public void setTestDependencies(List<File> testDependencies) {
            this.testDependencies = testDependencies;
        }

        public File getGrailsWorkDir() {
            return this.grailsWorkDir;
        }

        public void setGrailsWorkDir(File grailsWorkDir) {
            this.grailsWorkDir = grailsWorkDir;
        }

        public File getProjectWorkDir() {
            return this.projectWorkDir;
        }

        public void setProjectWorkDir(File projectWorkDir) {
            this.projectWorkDir = projectWorkDir;
        }

        public File getClassesDir() {
            return this.classesDir;
        }

        public void setClassesDir(File classesDir) {
            this.classesDir = classesDir;
        }

        public File getTestClassesDir() {
            return this.testClassesDir;
        }

        public void setTestClassesDir(File testClassesDir) {
            this.testClassesDir = testClassesDir;
        }

        public File getResourcesDir() {
            return this.resourcesDir;
        }

        public void setResourcesDir(File resourcesDir) {
            this.resourcesDir = resourcesDir;
        }

        public File getProjectPluginsDir() {
            return this.projectPluginsDir;
        }

        public void setProjectPluginsDir(File projectPluginsDir) {
            this.projectPluginsDir = projectPluginsDir;
        }

        public File getDependencyFileLocation() {
            return this.dependencyFileLocation;
        }

        public void setDependencyFileLocation(File dependencyFile) {
            this.dependencyFileLocation = dependencyFile;
        }

        public String getGrailsBuildListener() {
            return this.grailsBuildListener;
        }

        public void setGrailsBuildListener(String buildListener) {
            this.grailsBuildListener = buildListener;
        }
    }
}

