/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin.tools;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.groovy.grails.io.support.FileSystemResource;
import org.codehaus.groovy.grails.io.support.Resource;
import org.codehaus.groovy.grails.plugins.AstPluginDescriptorReader;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.grails.maven.plugin.tools.GrailsPluginProject;
import org.grails.maven.plugin.tools.GrailsProject;
import org.grails.maven.plugin.tools.GrailsServices;

public class DefaultGrailsServices
extends AbstractLogEnabled
implements GrailsServices {
    private static final String FILE_SUFFIX = "GrailsPlugin.groovy";
    private File _basedir;

    private File getBasedir() {
        if (this._basedir != null) {
            return this._basedir;
        }
        throw new RuntimeException("The basedir has to be set before any of the service methods are invoked.");
    }

    @Override
    public void setBasedir(File basedir) {
        this._basedir = basedir;
    }

    @Override
    public MavenProject createPOM(String groupId, GrailsProject grailsProjectDescriptor, String mtgGroupId, String grailsPluginArtifactId, String mtgVersion) {
        return this.createPOM(groupId, grailsProjectDescriptor, mtgGroupId, grailsPluginArtifactId, mtgVersion, false);
    }

    @Override
    public MavenProject createPOM(String groupId, GrailsProject grailsProjectDescriptor, String mtgGroupId, String grailsPluginArtifactId, String mtgVersion, boolean addEclipseSettings) {
        MavenProject pom = new MavenProject();
        if (pom.getBuild().getPluginManagement() == null) {
            pom.getBuild().setPluginManagement(new PluginManagement());
        }
        PluginManagement pluginMgt = pom.getPluginManagement();
        pom.setModelVersion("4.0.0");
        pom.setPackaging("grails-app");
        pom.getModel().getProperties().setProperty("grailsHome", "${env.GRAILS_HOME}");
        pom.getModel().getProperties().setProperty("grailsVersion", grailsProjectDescriptor.getAppGrailsVersion());
        Plugin grailsPlugin = new Plugin();
        grailsPlugin.setGroupId(mtgGroupId);
        grailsPlugin.setArtifactId(grailsPluginArtifactId);
        grailsPlugin.setVersion(mtgVersion);
        grailsPlugin.setExtensions(true);
        pom.addPlugin(grailsPlugin);
        Plugin compilerPlugin = new Plugin();
        compilerPlugin.setGroupId("org.apache.maven.plugins");
        compilerPlugin.setArtifactId("maven-compiler-plugin");
        Xpp3Dom compilerConfig = new Xpp3Dom("configuration");
        Xpp3Dom source = new Xpp3Dom("source");
        source.setValue("1.5");
        compilerConfig.addChild(source);
        Xpp3Dom target = new Xpp3Dom("target");
        target.setValue("1.5");
        compilerConfig.addChild(target);
        compilerPlugin.setConfiguration((Object)compilerConfig);
        pom.addPlugin(compilerPlugin);
        if (addEclipseSettings) {
            Plugin warPlugin = new Plugin();
            warPlugin.setGroupId("org.apache.maven.plugins");
            warPlugin.setArtifactId("maven-war-plugin");
            Xpp3Dom warConfig = new Xpp3Dom("configuration");
            Xpp3Dom warSourceDirectory = new Xpp3Dom("warSourceDirectory");
            warSourceDirectory.setValue("web-app");
            warConfig.addChild(warSourceDirectory);
            warPlugin.setConfiguration((Object)warConfig);
            pluginMgt.addPlugin(warPlugin);
            Plugin eclipsePlugin = new Plugin();
            eclipsePlugin.setGroupId("org.apache.maven.plugins");
            eclipsePlugin.setArtifactId("maven-eclipse-plugin");
            Xpp3Dom configuration = new Xpp3Dom("configuration");
            Xpp3Dom projectnatures = new Xpp3Dom("additionalProjectnatures");
            Xpp3Dom projectnature = new Xpp3Dom("projectnature");
            projectnature.setValue("org.codehaus.groovy.eclipse.groovyNature");
            projectnatures.addChild(projectnature);
            configuration.addChild(projectnatures);
            Xpp3Dom additionalBuildcommands = new Xpp3Dom("additionalBuildcommands");
            Xpp3Dom buildcommand = new Xpp3Dom("buildcommand");
            buildcommand.setValue("org.codehaus.groovy.eclipse.groovyBuilder");
            additionalBuildcommands.addChild(buildcommand);
            configuration.addChild(additionalBuildcommands);
            Xpp3Dom packaging = new Xpp3Dom("packaging");
            packaging.setValue("war");
            configuration.addChild(packaging);
            eclipsePlugin.setConfiguration((Object)configuration);
            pluginMgt.addPlugin(eclipsePlugin);
        }
        pom.getModel().getBuild().setOutputDirectory("web-app/WEB-INF/classes");
        pom.setArtifactId(grailsProjectDescriptor.getAppName());
        pom.setName(grailsProjectDescriptor.getAppName());
        pom.setGroupId(groupId);
        pom.setVersion(grailsProjectDescriptor.getAppVersion());
        if (!grailsProjectDescriptor.getAppVersion().endsWith("SNAPSHOT")) {
            this.getLogger().warn("=====================================================================");
            this.getLogger().warn("If your project is currently in development, in accordance with maven ");
            this.getLogger().warn("standards, its version must be " + grailsProjectDescriptor.getAppVersion() + "-SNAPSHOT and not " + grailsProjectDescriptor.getAppVersion() + ".");
            this.getLogger().warn("Please, change your version in the application.properties descriptor");
            this.getLogger().warn("and regenerate your pom.");
            this.getLogger().warn("=====================================================================");
        }
        return pom;
    }

    @Override
    public GrailsProject readProjectDescriptor() throws MojoExecutionException {
        GrailsProject grailsProject;
        FileInputStream fis = null;
        try {
            Properties properties = new Properties();
            fis = new FileInputStream(new File(this.getBasedir(), "application.properties"));
            properties.load(fis);
            GrailsProject grailsProject2 = new GrailsProject();
            grailsProject2.setAppGrailsVersion(properties.getProperty("app.grails.version"));
            grailsProject2.setAppName(properties.getProperty("app.name"));
            grailsProject2.setAppVersion(properties.getProperty("app.version"));
            grailsProject = grailsProject2;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to read grails project descriptor.", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fis);
        return grailsProject;
    }

    @Override
    public void writeProjectDescriptor(File projectDir, GrailsProject grailsProjectDescriptor) throws MojoExecutionException {
        String description = "Grails Descriptor updated by grails-maven-plugin on " + new Date();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(projectDir, "application.properties"));
            Properties properties = new Properties();
            properties.setProperty("app.grails.version", grailsProjectDescriptor.getAppGrailsVersion());
            properties.setProperty("app.name", grailsProjectDescriptor.getAppName());
            properties.setProperty("app.version", grailsProjectDescriptor.getAppVersion());
            properties.store(fos, description);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to write grails project descriptor.", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)fos);
    }

    @Override
    public GrailsPluginProject readGrailsPluginProject() throws MojoExecutionException {
        GrailsPluginProject pluginProject = new GrailsPluginProject();
        File[] files = this.getBasedir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith(DefaultGrailsServices.FILE_SUFFIX) && s.length() > DefaultGrailsServices.FILE_SUFFIX.length();
            }
        });
        if (files == null || files.length != 1) {
            throw new MojoExecutionException("Could not find a plugin descriptor. Expected to find exactly one file called FooGrailsPlugin.groovy in '" + this.getBasedir().getAbsolutePath() + "'.");
        }
        File descriptor = files[0];
        pluginProject.setFileName(descriptor);
        String className = descriptor.getName().substring(0, descriptor.getName().length() - ".groovy".length());
        String pluginName = GrailsNameUtils.getScriptName((String)GrailsNameUtils.getLogicalName((String)className, (String)"GrailsPlugin"));
        pluginProject.setPluginName(pluginName);
        GroovyClassLoader classLoader = new GroovyClassLoader();
        AstPluginDescriptorReader reader = new AstPluginDescriptorReader(classLoader);
        GrailsPluginInfo info = reader.readPluginInfo((Resource)new FileSystemResource(descriptor));
        String version = info.getVersion();
        if (version == null || version.trim().length() == 0) {
            throw new MojoExecutionException("Plugin does not have a version!");
        }
        pluginProject.setVersion(version);
        return pluginProject;
    }
}

