/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.grails.maven.plugin.AbstractGrailsMojo;
import org.grails.maven.plugin.tools.GrailsPluginProject;

public class MvnPluginValidateMojo
extends AbstractGrailsMojo {
    private String artifactId;
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getGrailsServices().readProjectDescriptor();
        }
        catch (MojoExecutionException e) {
            this.getLog().info((CharSequence)"No Grails project found - skipping validation.");
            return;
        }
        GrailsPluginProject grailsProject = this.getGrailsServices().readGrailsPluginProject();
        String pluginName = grailsProject.getPluginName();
        if (!this.artifactId.equals(pluginName) && !this.artifactId.equals("grails-" + pluginName)) {
            throw new MojoFailureException("The plugin name in the pom.xml [" + this.artifactId + "]" + " is not the expected '" + pluginName + "' or '" + "grails-" + pluginName + "'. " + "Please correct the pom.xml or the plugin " + "descriptor.");
        }
        String pomVersion = this.version.trim();
        String grailsVersion = grailsProject.getVersion();
        if (!grailsVersion.equals(pomVersion)) {
            throw new MojoFailureException("The version specified in the plugin descriptor [" + grailsVersion + "] is different from the version in the pom.xml [" + pomVersion + "] ");
        }
    }
}

