/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.grails.maven.plugin.AbstractGrailsMojo;

public class GrailsPackagePluginMojo
extends AbstractGrailsMojo {
    private Artifact artifact;
    protected ArtifactHandler artifactHandler;
    protected ArtifactHandler binaryArtifactHandler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String targetDir;
        File jarFile;
        this.runGrails("PackagePlugin");
        String zipFileName = this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip";
        if (!zipFileName.startsWith("grails-")) {
            zipFileName = "grails-" + zipFileName;
        }
        File zipGeneratedByGrails = new File(this.getBasedir(), zipFileName);
        ArtifactHandler handler = this.artifactHandler;
        if (!zipGeneratedByGrails.exists() && (jarFile = new File(targetDir = this.project.getBuild().getDirectory(), "grails-plugin-" + this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar")).exists()) {
            zipGeneratedByGrails = jarFile;
            zipFileName = this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar";
            handler = this.binaryArtifactHandler;
        }
        File mavenZipFile = new File(this.project.getBuild().getDirectory(), zipFileName);
        mavenZipFile.delete();
        if (!zipGeneratedByGrails.renameTo(mavenZipFile)) {
            throw new MojoExecutionException("Unable to copy the plugin ZIP to the target directory");
        }
        this.getLog().info((CharSequence)("Moved plugin ZIP to '" + mavenZipFile + "'."));
        this.artifact.setFile(mavenZipFile);
        this.artifact.setArtifactHandler(handler);
    }
}

