/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin;

import grails.util.Metadata;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jline.Terminal;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.grails.launcher.GrailsLauncher;
import org.grails.launcher.RootLoader;
import org.grails.maven.plugin.tools.ForkedGrailsRuntime;
import org.grails.maven.plugin.tools.GrailsServices;

public abstract class AbstractGrailsMojo
extends AbstractMojo {
    public static final String DEPENDENCY_FILE_LOC = "org.grails.ide.eclipse.dependencies.filename";
    public static final String GRAILS_BUILD_LISTENERS = "grails.build.listeners";
    public static final String PLUGIN_PREFIX = "grails-";
    private static final String GRAILS_PLUGIN_NAME_FORMAT = "plugins.%s:%s";
    public static final String APP_GRAILS_VERSION = "app.grails.version";
    public static final String APP_VERSION = "app.version";
    public static final String SPRING_LOADED_VERSION = "1.1.1";
    protected boolean activateAgent;
    protected File basedir;
    protected String env;
    protected String grailsEnv;
    protected String grailsWorkDir;
    protected boolean nonInteractive;
    protected boolean showStacktrace;
    protected boolean fork = false;
    protected List forkedVmArgs;
    protected boolean forkDebug = false;
    protected int forkPermGen = 256;
    protected int forkMaxMemory = 1024;
    protected int forkMinMemory = 512;
    protected File pluginsDir;
    protected File grailsHome;
    protected Settings settings;
    protected MavenProject project;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactCollector artifactCollector;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private String extraClasspathEntries;
    private String grailsBuildListener;
    private String dependencyFileLocation;
    private MavenProjectBuilder projectBuilder;
    private GrailsServices grailsServices;
    private static List<String> BOOTSTRAP_DEPENDENCIES = new ArrayList<String>(){
        {
            this.add("grails-launcher");
            this.add("ivy");
            this.add("ant");
            this.add("jansi");
            this.add("jline");
            this.add("grails-maven-plugin");
        }
    };

    protected File getBasedir() {
        if (this.basedir == null) {
            throw new RuntimeException("Your subclass have a field called 'basedir'. Remove it and use getBasedir() instead.");
        }
        return this.basedir;
    }

    protected String getEnvironment() {
        if (this.env == null) {
            return this.grailsEnv;
        }
        return this.env;
    }

    protected GrailsServices getGrailsServices() {
        this.grailsServices.setBasedir(this.basedir);
        return this.grailsServices;
    }

    protected void runGrails(String targetName) throws MojoExecutionException {
        this.runGrails(targetName, System.getProperty("grails.cli.args"));
    }

    protected void runGrails(String targetName, String args) throws MojoExecutionException {
        if (this.fork) {
            String targetDir = this.project.getBuild().getDirectory();
            ForkedGrailsRuntime.ExecutionContext ec = new ForkedGrailsRuntime.ExecutionContext();
            ec.setBuildDependencies(this.resolveGrailsExecutionPathJars(true));
            List<File> providedDependencies = this.resolveArtifacts(this.getProvidedArtifacts(this.project));
            ec.setProvidedDependencies(providedDependencies);
            ec.setCompileDependencies(this.getCompileFiles());
            ec.setTestDependencies(this.getTestFiles());
            ec.setRuntimeDependencies(this.getRuntimeFiles());
            ec.setGrailsWorkDir(new File(this.grailsWorkDir));
            ec.setProjectWorkDir(new File(targetDir));
            ec.setClassesDir(new File(targetDir, "classes"));
            ec.setTestClassesDir(new File(targetDir, "test-classes"));
            ec.setResourcesDir(new File(targetDir, "resources"));
            ec.setProjectPluginsDir(this.pluginsDir);
            ec.setForkedVmArgs(this.forkedVmArgs);
            if (this.nonInteractive) {
                String string = args = args != null ? "--non-interactive " + args : "--non-interactive ";
            }
            if (this.showStacktrace) {
                String string = args = args != null ? "--stacktrace " + args : "--stacktrace ";
            }
            if (this.grailsBuildListener != null) {
                ec.setGrailsBuildListener(this.grailsBuildListener);
            }
            if (this.dependencyFileLocation != null) {
                ec.setDependencyFileLocation(new File(this.dependencyFileLocation));
            }
            args = args != null ? "--plain-output " + args : "--plain-output";
            ec.setArgs(args);
            ec.setScriptName(targetName);
            ec.setBaseDir(this.project.getBasedir());
            ec.setEnv(this.getEnvironment());
            ForkedGrailsRuntime fgr = new ForkedGrailsRuntime(ec);
            if (this.activateAgent) {
                List<File> springLoadedJar = this.resolveArtifacts(Collections.singleton(this.artifactFactory.createArtifact("org.springsource.springloaded", "springloaded-core", SPRING_LOADED_VERSION, "compile", "jar")));
                if (!springLoadedJar.isEmpty()) {
                    fgr.setReloadingAgent(springLoadedJar.get(0));
                } else {
                    this.getLog().warn((CharSequence)"Grails Start with Reloading: org.springsource.springloaded:springloaded-core1.1.1 not found");
                    this.getLog().error((CharSequence)"Grails Start with Reloading: not enabled");
                }
            }
            fgr.setDebug(this.forkDebug);
            fgr.setMaxMemory(this.forkMaxMemory);
            fgr.setMaxPerm(this.forkPermGen);
            fgr.setMinMemory(this.forkMinMemory);
            try {
                this.handleVersionSync();
                fgr.fork();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        } else {
            this.getLog().warn((CharSequence)"Grails Start with out fork");
            this.runGrailsInline(targetName, args);
        }
    }

    private List<File> getCompileFiles() throws MojoExecutionException {
        List compileClasspathElements = null;
        try {
            compileClasspathElements = this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to create classpath for Grails execution.", (Exception)((Object)e));
        }
        List<File> dependencyFiles = this.getDependencyFiles(compileClasspathElements);
        Collection<Artifact> compileArtifacts = this.getCompileArtifacts(this.project);
        List<File> files = this.artifactsToFiles(compileArtifacts);
        dependencyFiles.addAll(this.zipFilesOnly(files));
        return dependencyFiles;
    }

    private Collection<? extends File> zipFilesOnly(List<File> files) {
        ArrayList<File> newFiles = new ArrayList<File>();
        for (File file : files) {
            if (file == null || !file.getName().endsWith(".zip")) continue;
            newFiles.add(file);
        }
        return newFiles;
    }

    private List<File> getRuntimeFiles() throws MojoExecutionException {
        List runtimeClasspathElements;
        try {
            runtimeClasspathElements = this.project.getRuntimeClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to create classpath for Grails execution.", (Exception)((Object)e));
        }
        List<File> dependencyFiles = this.getDependencyFiles(runtimeClasspathElements);
        Collection<Artifact> compileArtifacts = this.getRuntimeArtifacts(this.project);
        List<File> files = this.artifactsToFiles(compileArtifacts);
        dependencyFiles.addAll(this.zipFilesOnly(files));
        return dependencyFiles;
    }

    private List<File> getTestFiles() throws MojoExecutionException {
        List testClasspathElements;
        try {
            testClasspathElements = this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to create classpath for Grails execution.", (Exception)((Object)e));
        }
        List<File> dependencyFiles = this.getDependencyFiles(testClasspathElements);
        Collection<Artifact> testArtifacts = this.getTestArtifacts(this.project);
        List<File> files = this.artifactsToFiles(testArtifacts);
        dependencyFiles.addAll(this.zipFilesOnly(files));
        return dependencyFiles;
    }

    private List<File> getDependencyFiles(List compileClasspathElements) {
        ArrayList<File> files = new ArrayList<File>();
        for (Object compileClasspathElement : compileClasspathElements) {
            files.add(new File(compileClasspathElement.toString()));
        }
        return files;
    }

    protected List<File> resolveArtifacts(Collection<Artifact> artifacts) throws MojoExecutionException {
        try {
            ArtifactResolutionResult result = this.artifactCollector.collect(new HashSet<Artifact>(artifacts), this.project.getArtifact(), this.localRepository, this.remoteRepositories, this.artifactMetadataSource, null, Collections.EMPTY_LIST);
            Set newArtifacts = result.getArtifacts();
            for (Artifact currentArtifact : newArtifacts) {
                if (currentArtifact.getArtifactId().equals("tools") || currentArtifact.getGroupId().equals("com.sun")) continue;
                this.artifactResolver.resolve(currentArtifact, this.remoteRepositories, this.localRepository);
            }
            return this.artifactsToFiles(newArtifacts);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to create classpath for Grails execution.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Failed to create classpath for Grails execution.", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runGrailsInline(String targetName, String args) throws MojoExecutionException {
        InputStream currentIn = System.in;
        PrintStream currentOutput = System.out;
        try {
            this.configureMavenProxy();
            URL[] classpath = this.generateGrailsExecutionClasspath();
            String grailsHomePath = this.grailsHome != null ? this.grailsHome.getAbsolutePath() : null;
            RootLoader rootLoader = new RootLoader(classpath, ClassLoader.getSystemClassLoader());
            System.setProperty("grails.console.enable.terminal", "false");
            System.setProperty("grails.console.enable.interactive", "false");
            Class cls = rootLoader.loadClass("org.springframework.util.Log4jConfigurer");
            this.invokeStaticMethod(cls, "initLogging", new Object[]{"classpath:grails-maven/log4j.properties"});
            GrailsLauncher launcher = new GrailsLauncher((ClassLoader)rootLoader, grailsHomePath, this.basedir.getAbsolutePath());
            launcher.setPlainOutput(true);
            this.configureBuildSettings(launcher);
            this.handleVersionSync();
            if (this.nonInteractive) {
                String string = args = args != null ? "--non-interactive " + args : "--non-interactive ";
            }
            if (this.showStacktrace) {
                args = args != null ? "--stacktrace " + args : "--stacktrace ";
            }
            args = args != null ? "--plain-output " + args : "--plain-output";
            String oldBuildListeners = System.getProperty(GRAILS_BUILD_LISTENERS);
            if (this.grailsBuildListener != null) {
                System.setProperty(GRAILS_BUILD_LISTENERS, this.grailsBuildListener);
                this.getLog().info((CharSequence)("Grails build listener: " + this.grailsBuildListener));
            }
            String oldDependenciesFile = System.getProperty(DEPENDENCY_FILE_LOC);
            if (this.dependencyFileLocation != null) {
                System.setProperty(DEPENDENCY_FILE_LOC, this.dependencyFileLocation);
                this.getLog().info((CharSequence)("Dependency file location: " + this.dependencyFileLocation));
            }
            try {
                int retval = launcher.launch(targetName, args, this.getEnvironment());
                if (retval != 0) {
                    throw new MojoExecutionException("Grails returned non-zero value: " + retval);
                }
            }
            finally {
                if (oldBuildListeners != null) {
                    System.setProperty(GRAILS_BUILD_LISTENERS, oldBuildListeners);
                }
                if (oldDependenciesFile != null) {
                    System.setProperty(DEPENDENCY_FILE_LOC, oldDependenciesFile);
                }
            }
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to start Grails", ex);
        }
        finally {
            Terminal.resetTerminal();
            System.setIn(currentIn);
            System.setOut(currentOutput);
        }
    }

    private void handleVersionSync() {
        Metadata metadata = Metadata.getInstance((File)new File(this.getBasedir(), "application.properties"));
        boolean metadataModified = this.syncVersions(metadata);
        if (metadataModified) {
            metadata.persist();
        }
    }

    private boolean syncVersions(Metadata metadata) {
        Object appVersion;
        boolean result = false;
        Object grailsVersion = metadata.get((Object)APP_GRAILS_VERSION);
        Artifact grailsDependency = this.findGrailsDependency(this.project);
        if (grailsDependency != null && !grailsDependency.getVersion().equals(grailsVersion)) {
            metadata.put((Object)APP_GRAILS_VERSION, (Object)grailsDependency.getVersion());
            result = true;
        }
        if ((appVersion = metadata.get((Object)APP_VERSION)) != null && !this.project.getVersion().equals(appVersion)) {
            metadata.put((Object)APP_VERSION, (Object)this.project.getVersion());
            result = true;
        }
        return result;
    }

    private boolean isGrailsPlugin(File basedir) {
        try {
            File[] files = basedir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().endsWith("GrailsPlugin.groovy")) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Artifact findGrailsDependency(MavenProject project) {
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Object o : dependencyArtifacts) {
            Artifact artifact = (Artifact)o;
            if (!artifact.getArtifactId().equals("grails-dependencies")) continue;
            return artifact;
        }
        return null;
    }

    private void configureMavenProxy() {
        Proxy activeProxy;
        if (this.settings != null && (activeProxy = this.settings.getActiveProxy()) != null) {
            String host = activeProxy.getHost();
            int port = activeProxy.getPort();
            String username = activeProxy.getUsername();
            String password = activeProxy.getPassword();
            System.setProperty("http.proxyHost", host);
            System.setProperty("http.proxyPort", String.valueOf(port));
            if (username != null) {
                System.setProperty("http.proxyUser", username);
            }
            if (password != null) {
                System.setProperty("http.proxyPassword", password);
            }
        }
    }

    private Object invokeStaticMethod(Class target, String name, Object[] args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        try {
            return target.getMethod(name, argTypes).invoke((Object)target, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private URL[] generateGrailsExecutionClasspath() throws MojoExecutionException {
        try {
            List<File> jars = this.resolveGrailsExecutionPathJars();
            ArrayList<URL> classpath = new ArrayList<URL>();
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                if (url == null) continue;
                classpath.add(url);
            }
            return classpath.toArray(new URL[classpath.size()]);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create classpath for Grails execution.", e);
        }
    }

    private List<File> resolveGrailsExecutionPathJars() throws MojoExecutionException {
        return this.resolveGrailsExecutionPathJars(false);
    }

    private List<File> resolveGrailsExecutionPathJars(boolean pluginOnly) throws MojoExecutionException {
        try {
            ArrayList<Dependency> unresolvedDependencies = new ArrayList<Dependency>();
            HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
            MavenProject pluginProject = this.getPluginProject();
            if (pluginOnly) {
                Dependency mavenPluginDependency = new Dependency();
                Artifact currentArtifact = this.getPluginProject().getArtifact();
                mavenPluginDependency.setGroupId(currentArtifact.getGroupId());
                mavenPluginDependency.setVersion(currentArtifact.getVersion());
                mavenPluginDependency.setArtifactId(currentArtifact.getArtifactId());
                unresolvedDependencies.add(mavenPluginDependency);
                Dependency grailsLauncherDep = this.findDependency(this.getPluginProject().getDependencies(), "grails-launcher");
                unresolvedDependencies.add(grailsLauncherDep);
            } else {
                unresolvedDependencies.addAll(this.filterDependencies(pluginProject.getDependencies(), "org.grails"));
                unresolvedDependencies.addAll(this.project.getDependencies());
            }
            List<Artifact> unresolvedArtifacts = this.dependenciesToArtifacts(unresolvedDependencies);
            for (Artifact unresolvedArtifact : unresolvedArtifacts) {
                resolvedArtifacts.addAll(this.resolveDependenciesToArtifacts(unresolvedArtifact, unresolvedDependencies));
            }
            ArrayList<String> pluginDependencies = new ArrayList<String>();
            for (Object o : pluginProject.getDependencies()) {
                Dependency d = (Dependency)o;
                pluginDependencies.add(d.getArtifactId());
            }
            pluginDependencies.addAll(BOOTSTRAP_DEPENDENCIES);
            HashSet<File> jars = new HashSet<File>();
            boolean index = false;
            block4: for (Artifact resolvedArtifact : resolvedArtifacts) {
                File file = resolvedArtifact.getFile();
                if (file != null && !pluginOnly) {
                    jars.add(file);
                    continue;
                }
                if (file == null) continue;
                for (String dependency : pluginDependencies) {
                    if (!file.getName().contains(dependency)) continue;
                    jars.add(file);
                    continue block4;
                }
            }
            String javaHome = System.getProperty("java.home");
            File toolsJar = new File(javaHome, "../lib/tools.jar");
            if (!toolsJar.exists()) {
                toolsJar = new File(javaHome, "tools.jar");
            }
            if (toolsJar.exists() && toolsJar != null) {
                jars.add(toolsJar);
            }
            if (this.extraClasspathEntries != null) {
                String[] entriesArr = this.extraClasspathEntries.split(",");
                for (int i = 0; i < entriesArr.length; ++i) {
                    String entry = entriesArr[i].endsWith("\\") && i < entriesArr.length - 1 ? entriesArr[i] + "," + entriesArr[++i] : entriesArr[i];
                    File file = new File(entry);
                    if (!file.exists()) {
                        this.getLog().warn((CharSequence)("Grails extra classpath entry " + file + " does not exist."), (Throwable)new Exception());
                    }
                    jars.add(file);
                }
            }
            return new ArrayList<File>(jars);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create classpath for Grails execution.", e);
        }
    }

    private Dependency findDependency(List dependencies, String artifactId) {
        for (Object o : dependencies) {
            Dependency d = (Dependency)o;
            if (!d.getArtifactId().equals(artifactId)) continue;
            return d;
        }
        return null;
    }

    private MavenProject getPluginProject() throws ProjectBuildingException {
        Artifact pluginArtifact = this.findArtifact(this.project.getPluginArtifacts(), "org.grails", "grails-maven-plugin");
        return this.projectBuilder.buildFromRepository(pluginArtifact, this.remoteRepositories, this.localRepository);
    }

    private List<Dependency> filterDependencies(List<Dependency> dependencies, String groupId) {
        ArrayList<Dependency> filteredDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            if (!dependency.getGroupId().equals(groupId)) continue;
            filteredDependencies.add(dependency);
        }
        return filteredDependencies;
    }

    private Set<Artifact> resolveDependenciesToArtifacts(Artifact artifact, List<Dependency> dependencies) throws MojoExecutionException {
        try {
            MavenProject project = this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
            Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, dependencies, null, null, null);
            ArtifactResolutionResult result = this.artifactCollector.collect(artifacts, project.getArtifact(), this.localRepository, this.remoteRepositories, this.artifactMetadataSource, null, Collections.EMPTY_LIST);
            artifacts.addAll(result.getArtifacts());
            artifacts.add(project.getArtifact());
            for (Artifact currentArtifact : artifacts) {
                if (currentArtifact.getArtifactId().equals("tools") || currentArtifact.getGroupId().equals("com.sun")) continue;
                this.artifactResolver.resolve(currentArtifact, this.remoteRepositories, this.localRepository);
            }
            return artifacts;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Encountered problems resolving dependencies of the executable in preparation for its execution.", ex);
        }
    }

    private void configureBuildSettings(GrailsLauncher launcher) throws ProjectBuildingException, MojoExecutionException {
        String targetDir = this.project.getBuild().getDirectory();
        launcher.setDependenciesExternallyConfigured(true);
        launcher.setProvidedDependencies(this.artifactsToFiles(this.getProvidedArtifacts(this.project)));
        launcher.setCompileDependencies(this.artifactsToFiles(this.getCompileArtifacts(this.project)));
        launcher.setTestDependencies(this.artifactsToFiles(this.getTestArtifacts(this.project)));
        launcher.setRuntimeDependencies(this.artifactsToFiles(this.getRuntimeArtifacts(this.project)));
        launcher.setGrailsWorkDir(new File(this.grailsWorkDir));
        launcher.setProjectWorkDir(new File(targetDir));
        launcher.setClassesDir(new File(targetDir, "classes"));
        launcher.setTestClassesDir(new File(targetDir, "test-classes"));
        launcher.setResourcesDir(new File(targetDir, "resources"));
        launcher.setProjectPluginsDir(this.pluginsDir);
        MavenProject pluginProject = this.getPluginProject();
        ArrayList<Dependency> unresolvedDependencies = new ArrayList<Dependency>();
        HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
        unresolvedDependencies.addAll(this.filterDependencies(pluginProject.getDependencies(), "org.grails"));
        List<Artifact> unresolvedArtifacts = this.dependenciesToArtifacts(unresolvedDependencies);
        for (Artifact unresolvedArtifact : unresolvedArtifacts) {
            resolvedArtifacts.addAll(this.resolveDependenciesToArtifacts(unresolvedArtifact, unresolvedDependencies));
        }
        List<File> files = this.artifactsToFiles(resolvedArtifacts);
        launcher.setBuildDependencies(files);
    }

    private Collection<Artifact> getRuntimeArtifacts(MavenProject project) {
        List runtimeArtifacts = project.getRuntimeArtifacts();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(runtimeArtifacts);
        this.copyScopedDependenciesToTarget(project.getDependencyArtifacts(), artifacts, "runtime");
        return artifacts;
    }

    private Collection<Artifact> getTestArtifacts(MavenProject project) {
        List testArtifacts = project.getTestArtifacts();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(testArtifacts);
        this.copyScopedDependenciesToTarget(project.getDependencyArtifacts(), artifacts, "test");
        return artifacts;
    }

    private Collection<Artifact> getCompileArtifacts(MavenProject project) {
        List compileArtifacts = project.getCompileArtifacts();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(compileArtifacts);
        this.copyScopedDependenciesToTarget(project.getDependencyArtifacts(), artifacts, "compile");
        return artifacts;
    }

    private Collection<Artifact> getProvidedArtifacts(MavenProject project) {
        Set dependencyArtifacts = project.getDependencyArtifacts();
        ArrayList<Artifact> provided = new ArrayList<Artifact>();
        this.copyScopedDependenciesToTarget(dependencyArtifacts, provided, "provided");
        return provided;
    }

    private void copyScopedDependenciesToTarget(Set dependencyArtifacts, List<Artifact> targetArtifacts, String scope) {
        for (Object dependencyArtifact : dependencyArtifacts) {
            Artifact artifact = (Artifact)dependencyArtifact;
            if (!artifact.getScope().equals(scope)) continue;
            targetArtifacts.add(artifact);
        }
    }

    private List<File> artifactsToFiles(Collection<Artifact> artifacts) {
        ArrayList<File> files = new ArrayList<File>(artifacts.size());
        for (Artifact artifact : artifacts) {
            String name;
            File file = artifact.getFile();
            if (file == null || (name = file.getName()).contains("xml-apis") || name.contains("commons-logging")) continue;
            files.add(file);
        }
        return files;
    }

    private Artifact findArtifact(Collection<Artifact> artifacts, String groupId, String artifactId) {
        for (Artifact artifact : artifacts) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact;
        }
        return null;
    }

    private List<Artifact> dependenciesToArtifacts(Collection<Dependency> deps) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(deps.size());
        for (Dependency dep : deps) {
            artifacts.add(this.dependencyToArtifact(dep));
        }
        return artifacts;
    }

    private Artifact dependencyToArtifact(Dependency dep) {
        return this.artifactFactory.createBuildArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), "pom");
    }
}

