/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.LocalConfigurationMetaData;
import org.gradle.internal.component.model.ConfigurationMetaData;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.language.base.internal.DependentSourceSetInternal;
import org.gradle.language.base.internal.model.DefaultVariantsMetaData;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.language.base.internal.resolve.DependentSourceSetResolveContext;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.DependencySpec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyResolvingClasspath
extends AbstractFileCollection {
    private final GlobalDependencyResolutionRules globalRules = GlobalDependencyResolutionRules.NO_OP;
    private final List<ResolutionAwareRepository> remoteRepositories;
    private final JarBinarySpec binary;
    private final DependentSourceSetInternal sourceSet;
    private final ArtifactDependencyResolver dependencyResolver;
    private final DependentSourceSetResolveContext resolveContext;
    private ResolveResult resolveResult;

    public DependencyResolvingClasspath(JarBinarySpec binarySpec, DependentSourceSetInternal sourceSet, ArtifactDependencyResolver dependencyResolver, ModelSchemaStore schemaStore, List<ResolutionAwareRepository> remoteRepositories) {
        this.binary = binarySpec;
        this.sourceSet = sourceSet;
        this.dependencyResolver = dependencyResolver;
        this.remoteRepositories = remoteRepositories;
        this.resolveContext = new DependentSourceSetResolveContext(this.binary.getId(), sourceSet, this.variantsMetaDataFrom(this.binary, schemaStore), this.allDependencies());
    }

    public String getDisplayName() {
        return "Classpath for " + this.sourceSet.getDisplayName();
    }

    public Set<File> getFiles() {
        this.ensureResolved(true);
        Set artifacts = this.resolveResult.artifactResults.getArtifacts();
        return CollectionUtils.collect((Set)artifacts, (Transformer)new Transformer<File, ResolvedArtifact>(){

            public File transform(ResolvedArtifact resolvedArtifact) {
                return resolvedArtifact.getFile();
            }
        });
    }

    public TaskDependency getBuildDependencies() {
        this.ensureResolved(false);
        return this.resolveResult.taskDependency;
    }

    private Iterable<DependencySpec> allDependencies() {
        return new Iterable<DependencySpec>(){

            @Override
            public Iterator<DependencySpec> iterator() {
                return Iterables.concat((Iterable)DependencyResolvingClasspath.this.sourceSetDependencies(), (Iterable)DependencyResolvingClasspath.this.apiDependencies()).iterator();
            }
        };
    }

    private Collection<DependencySpec> sourceSetDependencies() {
        return this.sourceSet.getDependencies().getDependencies();
    }

    private Collection<DependencySpec> apiDependencies() {
        return this.binary.getApiDependencies();
    }

    private void ensureResolved(boolean failFast) {
        if (this.resolveResult == null) {
            this.resolveResult = this.resolve();
        }
        if (failFast) {
            this.failOnUnresolvedDependency(this.resolveResult.notFound);
        }
    }

    private ResolveResult resolve() {
        ResolveResult result = new ResolveResult();
        this.dependencyResolver.resolve((ResolveContext)this.resolveContext, this.remoteRepositories, this.globalRules, (DependencyGraphVisitor)result, (DependencyArtifactsVisitor)result);
        return result;
    }

    private void failOnUnresolvedDependency(List<Throwable> notFound) {
        if (!notFound.isEmpty()) {
            throw new LibraryResolveException(String.format("Could not resolve all dependencies for '%s' source set '%s'", this.binary.getDisplayName(), this.sourceSet.getDisplayName()), notFound);
        }
    }

    private VariantsMetaData variantsMetaDataFrom(JarBinarySpec binary, ModelSchemaStore schemaStore) {
        return DefaultVariantsMetaData.extractFrom((BinarySpec)binary, (ModelSchemaStore)schemaStore);
    }

    class ResolveResult
    implements DependencyGraphVisitor,
    DependencyArtifactsVisitor {
        public final DefaultTaskDependency taskDependency = new DefaultTaskDependency();
        public final List<Throwable> notFound = new LinkedList<Throwable>();
        public final DefaultResolvedArtifactResults artifactResults = new DefaultResolvedArtifactResults();

        ResolveResult() {
        }

        public void start(DependencyGraphNode root) {
        }

        public void visitNode(DependencyGraphNode resolvedConfiguration) {
            ConfigurationMetaData configurationMetaData = resolvedConfiguration.getMetaData();
            if (configurationMetaData instanceof LocalConfigurationMetaData) {
                TaskDependency directBuildDependencies = ((LocalConfigurationMetaData)configurationMetaData).getDirectBuildDependencies();
                this.taskDependency.add(new Object[]{directBuildDependencies});
            }
            for (DependencyGraphEdge dependency : resolvedConfiguration.getOutgoingEdges()) {
                ModuleVersionResolveException failure = dependency.getFailure();
                if (failure == null) continue;
                this.notFound.add((Throwable)failure);
            }
        }

        public void visitEdge(DependencyGraphNode resolvedConfiguration) {
        }

        public void finish(DependencyGraphNode root) {
        }

        public void visitArtifacts(ResolvedConfigurationIdentifier parent, ResolvedConfigurationIdentifier child, ArtifactSet artifacts) {
            this.artifactResults.addArtifactSet(artifacts);
        }

        public void finishArtifacts() {
            this.artifactResults.resolveNow();
        }
    }
}

