/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.gaul.modernizer_maven_plugin.Modernizer;
import org.gaul.modernizer_maven_plugin.Utils;
import org.gaul.modernizer_maven_plugin.Violation;
import org.gaul.modernizer_maven_plugin.ViolationOccurrence;
import org.xml.sax.SAXException;

@Mojo(name="modernizer", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true)
public final class ModernizerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testOutputDirectory;
    @Parameter(defaultValue="${javaVersion}", required=true)
    private String javaVersion;
    @Parameter(defaultValue="${failOnViolations}")
    private boolean failOnViolations = true;
    @Parameter(defaultValue="${includeTestClasses}")
    private boolean includeTestClasses = true;
    @Parameter(defaultValue="${violationsFile}")
    private String violationsFile;
    @Parameter(defaultValue="${exclusionsFile}")
    private String exclusionsFile;
    @Parameter
    private Set<String> ignorePackages = new HashSet<String>();
    private Modernizer modernizer;

    public void execute() throws MojoExecutionException {
        Map<String, Violation> violations;
        InputStream is;
        if (this.violationsFile == null) {
            is = Modernizer.class.getResourceAsStream("/modernizer.xml");
        } else {
            File file = new File(this.violationsFile);
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new MojoExecutionException("Error opening violation file: " + file, (Exception)fnfe);
            }
        }
        try {
            violations = Modernizer.parseFromXml(is);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading violation data", (Exception)ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new MojoExecutionException("Error parsing violation data", (Exception)pce);
        }
        catch (SAXException saxe) {
            throw new MojoExecutionException("Error parsing violation data", (Exception)saxe);
        }
        finally {
            Utils.closeQuietly(is);
        }
        HashSet<String> exclusions = new HashSet<String>();
        if (this.exclusionsFile != null) {
            is = null;
            try {
                File file = new File(this.exclusionsFile);
                is = file.exists() ? new FileInputStream(file) : ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.exclusionsFile);
                if (is == null) {
                    throw new MojoExecutionException("Could not find exclusion file: " + this.exclusionsFile);
                }
                exclusions.addAll(Utils.readAllLines(is));
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Error reading exclusion file: " + this.exclusionsFile, (Exception)ioe);
            }
            finally {
                Utils.closeQuietly(is);
            }
        }
        this.modernizer = new Modernizer(this.javaVersion, violations, exclusions, this.ignorePackages);
        try {
            long count = this.recurseFiles(this.outputDirectory);
            if (this.includeTestClasses) {
                count += this.recurseFiles(this.testOutputDirectory);
            }
            if (this.failOnViolations && count != 0L) {
                throw new MojoExecutionException("Found " + count + " violations");
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error reading Java classes", (Exception)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long recurseFiles(File file) throws IOException {
        long count;
        block11: {
            block10: {
                count = 0L;
                if (!file.exists()) {
                    return count;
                }
                if (!file.isDirectory()) break block10;
                String[] children = file.list();
                if (children == null) break block11;
                for (String child : children) {
                    count += this.recurseFiles(new File(file, child));
                }
                break block11;
            }
            if (file.getPath().endsWith(".class")) {
                FileInputStream is = new FileInputStream(file);
                try {
                    Collection<ViolationOccurrence> occurrences = this.modernizer.check(is);
                    for (ViolationOccurrence occurrence : occurrences) {
                        String name = file.getPath();
                        if (name.startsWith(this.outputDirectory.getPath())) {
                            name = this.sourceDirectory.getPath() + name.substring(this.outputDirectory.getPath().length());
                            name = name.substring(0, name.length() - ".class".length()) + ".java";
                        } else if (name.startsWith(this.testOutputDirectory.getPath())) {
                            name = this.testSourceDirectory.getPath() + name.substring(this.testOutputDirectory.getPath().length());
                            name = name.substring(0, name.length() - ".class".length()) + ".java";
                        }
                        this.getLog().error((CharSequence)(name + ":" + occurrence.getLineNumber() + ": " + occurrence.getViolation().getComment()));
                        ++count;
                    }
                }
                finally {
                    Utils.closeQuietly(is);
                }
            }
        }
        return count;
    }
}

