/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.watch;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.xpack.watcher.support.Exceptions;

public class WatchLockService
extends AbstractComponent {
    private final KeyedLock<String> watchLocks = new KeyedLock(true);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private static final TimeValue DEFAULT_MAX_STOP_TIMEOUT = new TimeValue(30L, TimeUnit.SECONDS);
    private static final String DEFAULT_MAX_STOP_TIMEOUT_SETTING = "xpack.watcher.stop.timeout";
    private final TimeValue maxStopTimeout;

    @Inject
    public WatchLockService(Settings settings) {
        super(settings);
        this.maxStopTimeout = settings.getAsTime(DEFAULT_MAX_STOP_TIMEOUT_SETTING, DEFAULT_MAX_STOP_TIMEOUT);
    }

    WatchLockService(TimeValue maxStopTimeout) {
        super(Settings.EMPTY);
        this.maxStopTimeout = maxStopTimeout;
    }

    public Releasable acquire(String name) {
        if (!this.running.get()) {
            throw Exceptions.illegalState("cannot acquire lock for watch [{}]. lock service is not running", name);
        }
        return this.watchLocks.acquire((Object)name);
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            // empty if block
        }
    }

    public void stop() throws ElasticsearchTimeoutException {
        if (this.running.compareAndSet(true, false)) {
            long startWait = System.currentTimeMillis();
            while (this.watchLocks.hasLockedKeys()) {
                TimeValue timeWaiting = new TimeValue(System.currentTimeMillis() - startWait);
                if (timeWaiting.getSeconds() > this.maxStopTimeout.getSeconds()) {
                    throw new ElasticsearchTimeoutException("timed out waiting for watches to complete, after waiting for [{}]", new Object[]{timeWaiting});
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    KeyedLock<String> getWatchLocks() {
        return this.watchLocks;
    }
}

