/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.support;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public enum DayOfWeek implements ToXContent
{
    SUNDAY("SUN"),
    MONDAY("MON"),
    TUESDAY("TUE"),
    WEDNESDAY("WED"),
    THURSDAY("THU"),
    FRIDAY("FRI"),
    SATURDAY("SAT");

    private final String cronKey;

    private DayOfWeek(String cronKey) {
        this.cronKey = cronKey;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.name().toLowerCase(Locale.ROOT));
    }

    public static String cronPart(EnumSet<DayOfWeek> days) {
        StringBuilder sb = new StringBuilder();
        for (DayOfWeek day : days) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(day.cronKey);
        }
        return sb.toString();
    }

    public static DayOfWeek resolve(int day) {
        switch (day) {
            case 1: {
                return SUNDAY;
            }
            case 2: {
                return MONDAY;
            }
            case 3: {
                return TUESDAY;
            }
            case 4: {
                return WEDNESDAY;
            }
            case 5: {
                return THURSDAY;
            }
            case 6: {
                return FRIDAY;
            }
            case 7: {
                return SATURDAY;
            }
        }
        throw new ElasticsearchParseException("unknown day of week number [{}]", new Object[]{day});
    }

    public static DayOfWeek resolve(String day) {
        switch (day.toLowerCase(Locale.ROOT)) {
            case "1": 
            case "sun": 
            case "sunday": {
                return SUNDAY;
            }
            case "2": 
            case "mon": 
            case "monday": {
                return MONDAY;
            }
            case "3": 
            case "tue": 
            case "tuesday": {
                return TUESDAY;
            }
            case "4": 
            case "wed": 
            case "wednesday": {
                return WEDNESDAY;
            }
            case "5": 
            case "thu": 
            case "thursday": {
                return THURSDAY;
            }
            case "6": 
            case "fri": 
            case "friday": {
                return FRIDAY;
            }
            case "7": 
            case "sat": 
            case "saturday": {
                return SATURDAY;
            }
        }
        throw new ElasticsearchParseException("unknown day of week [{}]", new Object[]{day});
    }

    public String toString() {
        return this.cronKey;
    }
}

