/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.search;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchRequestParsers;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.transform.Transform;
import org.elasticsearch.xpack.watcher.transform.search.ExecutableSearchTransform;
import org.elasticsearch.xpack.watcher.watch.Payload;
import org.joda.time.DateTimeZone;

public class SearchTransform
implements Transform {
    public static final String TYPE = "search";
    private final WatcherSearchTemplateRequest request;
    @Nullable
    private final TimeValue timeout;
    @Nullable
    private final DateTimeZone dynamicNameTimeZone;

    public SearchTransform(WatcherSearchTemplateRequest request, @Nullable TimeValue timeout, @Nullable DateTimeZone dynamicNameTimeZone) {
        this.request = request;
        this.timeout = timeout;
        this.dynamicNameTimeZone = dynamicNameTimeZone;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public WatcherSearchTemplateRequest getRequest() {
        return this.request;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public DateTimeZone getDynamicNameTimeZone() {
        return this.dynamicNameTimeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchTransform that = (SearchTransform)o;
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        if (this.timeout != null ? !this.timeout.equals((Object)that.timeout) : that.timeout != null) {
            return false;
        }
        return !(this.dynamicNameTimeZone == null ? that.dynamicNameTimeZone != null : !this.dynamicNameTimeZone.equals((Object)that.dynamicNameTimeZone));
    }

    public int hashCode() {
        int result = this.request != null ? this.request.hashCode() : 0;
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.dynamicNameTimeZone != null ? this.dynamicNameTimeZone.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.request != null) {
            builder.field(Field.REQUEST.getPreferredName(), (ToXContent)this.request);
        }
        if (this.timeout != null) {
            builder.timeValueField(Field.TIMEOUT.getPreferredName(), Field.TIMEOUT_HUMAN.getPreferredName(), this.timeout);
        }
        if (this.dynamicNameTimeZone != null) {
            builder.field(Field.DYNAMIC_NAME_TIMEZONE.getPreferredName(), (Object)this.dynamicNameTimeZone);
        }
        builder.endObject();
        return builder;
    }

    public static SearchTransform parse(Logger transformLogger, String watchId, XContentParser parser, boolean upgradeTransformSource, String defaultLegacyScriptLanguage, ParseFieldMatcher parseFieldMatcher, SearchRequestParsers searchRequestParsers) throws IOException {
        XContentParser.Token token;
        WatcherSearchTemplateRequest request = null;
        TimeValue timeout = null;
        DateTimeZone dynamicNameTimeZone = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.REQUEST)) {
                try {
                    request = WatcherSearchTemplateRequest.fromXContent(transformLogger, parser, ExecutableSearchTransform.DEFAULT_SEARCH_TYPE, upgradeTransformSource, defaultLegacyScriptLanguage, parseFieldMatcher, searchRequestParsers);
                    continue;
                }
                catch (ElasticsearchParseException srpe) {
                    throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. failed to parse [{}]", (Throwable)srpe, new Object[]{TYPE, watchId, currentFieldName});
                }
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TIMEOUT)) {
                timeout = TimeValue.timeValueMillis((long)parser.longValue());
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TIMEOUT_HUMAN)) {
                timeout = WatcherDateTimeUtils.parseTimeValue(parser, Field.TIMEOUT_HUMAN.toString());
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.DYNAMIC_NAME_TIMEZONE)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    dynamicNameTimeZone = DateTimeZone.forID((String)parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. failed to parse [{}]. must be a string value (e.g. 'UTC' or '+01:00').", new Object[]{TYPE, watchId, currentFieldName});
            }
            throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. unexpected field [{}]", new Object[]{TYPE, watchId, currentFieldName});
        }
        if (request == null) {
            throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. missing required [{}] field", new Object[]{TYPE, watchId, Field.REQUEST.getPreferredName()});
        }
        return new SearchTransform(request, timeout, dynamicNameTimeZone);
    }

    public static Builder builder(WatcherSearchTemplateRequest request) {
        return new Builder(request);
    }

    public static interface Field
    extends Transform.Field {
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout_in_millis", new String[0]);
        public static final ParseField TIMEOUT_HUMAN = new ParseField("timeout", new String[0]);
        public static final ParseField DYNAMIC_NAME_TIMEZONE = new ParseField("dynamic_name_timezone", new String[0]);
    }

    public static class Builder
    implements Transform.Builder<SearchTransform> {
        private final WatcherSearchTemplateRequest request;
        private TimeValue timeout;
        private DateTimeZone dynamicNameTimeZone;

        public Builder(WatcherSearchTemplateRequest request) {
            this.request = request;
        }

        public Builder timeout(TimeValue readTimeout) {
            this.timeout = readTimeout;
            return this;
        }

        public Builder dynamicNameTimeZone(DateTimeZone dynamicNameTimeZone) {
            this.dynamicNameTimeZone = dynamicNameTimeZone;
            return this;
        }

        @Override
        public SearchTransform build() {
            return new SearchTransform(this.request, this.timeout, this.dynamicNameTimeZone);
        }
    }

    public static class Result
    extends Transform.Result {
        @Nullable
        private final WatcherSearchTemplateRequest request;

        public Result(WatcherSearchTemplateRequest request, Payload payload) {
            super(SearchTransform.TYPE, payload);
            this.request = request;
        }

        public Result(WatcherSearchTemplateRequest request, Exception e) {
            super(SearchTransform.TYPE, e);
            this.request = request;
        }

        public WatcherSearchTemplateRequest executedRequest() {
            return this.request;
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.request != null) {
                builder.startObject(this.type);
                builder.field(Field.REQUEST.getPreferredName(), (ToXContent)this.request);
                builder.endObject();
            }
            return builder;
        }
    }
}

