/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.xcontent;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.common.xcontent.XContentUtils;
import org.elasticsearch.xpack.watcher.support.xcontent.ObjectPath;

public class XContentSource
implements ToXContent {
    private final BytesReference bytes;
    private final XContentType contentType;
    private Object data;

    public XContentSource(BytesReference bytes, XContentType xContentType) throws ElasticsearchParseException {
        if (xContentType == null) {
            throw new IllegalArgumentException("xContentType must not be null");
        }
        this.bytes = bytes;
        this.contentType = xContentType;
    }

    public XContentSource(XContentBuilder builder) {
        this(builder.bytes(), builder.contentType());
    }

    public XContentSource(ToXContent content) throws IOException {
        this(content.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
    }

    public BytesReference getBytes() {
        return this.bytes;
    }

    public boolean isMap() {
        return this.data() instanceof Map;
    }

    public Map<String, Object> getAsMap() {
        return (Map)this.data();
    }

    public boolean isList() {
        return this.data() instanceof List;
    }

    public List<Object> getAsList() {
        return (List)this.data();
    }

    public <T> T getValue(String path) {
        return ObjectPath.eval(path, this.data());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try (XContentParser parser = this.parser();){
            parser.nextToken();
            XContentHelper.copyCurrentStructure((XContentGenerator)builder.generator(), (XContentParser)parser);
            XContentBuilder xContentBuilder = builder;
            return xContentBuilder;
        }
    }

    public XContentParser parser() throws IOException {
        return this.contentType.xContent().createParser(this.bytes);
    }

    public static XContentSource readFrom(StreamInput in) throws IOException {
        return new XContentSource(in.readBytesReference(), XContentType.readFrom((StreamInput)in));
    }

    public static void writeTo(XContentSource source, StreamOutput out) throws IOException {
        out.writeBytesReference(source.bytes);
        source.contentType.writeTo(out);
    }

    private Object data() {
        if (this.data == null) {
            try (XContentParser parser = this.parser();){
                this.data = XContentUtils.readValue(parser, parser.nextToken());
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to read value", (Throwable)ex, new Object[0]);
            }
        }
        return this.data;
    }
}

