/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.validation;

import java.util.regex.Pattern;
import org.elasticsearch.common.logging.LoggerMessageFormat;

public class Validation {
    private static final Pattern NO_WS_PATTERN = Pattern.compile("\\S+");

    public static Error watchId(String id) {
        if (!NO_WS_PATTERN.matcher(id).matches()) {
            return new Error("Invalid watch id [{}]. Watch id cannot have white spaces", id);
        }
        return null;
    }

    public static Error actionId(String id) {
        if (!NO_WS_PATTERN.matcher(id).matches()) {
            return new Error("Invalid action id [{}]. Action id cannot have white spaces", id);
        }
        return null;
    }

    public static class Error {
        private final String message;

        public Error(String message, Object ... args) {
            this.message = LoggerMessageFormat.format((String)message, (Object[])args);
        }

        public String message() {
            return this.message;
        }

        public String toString() {
            return this.message;
        }
    }
}

