/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.util.Arrays;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.watcher.support.Exceptions;

public final class SearchRequestEquivalence {
    public static final SearchRequestEquivalence INSTANCE = new SearchRequestEquivalence();

    private SearchRequestEquivalence() {
    }

    public boolean equivalent(@Nullable SearchRequest a, @Nullable SearchRequest b) {
        return a == b ? true : (a != null && b != null ? this.doEquivalent(a, b) : false);
    }

    protected boolean doEquivalent(SearchRequest r1, SearchRequest r2) {
        try {
            BytesStreamOutput output1 = new BytesStreamOutput();
            r1.writeTo((StreamOutput)output1);
            byte[] bytes1 = BytesReference.toBytes((BytesReference)output1.bytes());
            output1.reset();
            r2.writeTo((StreamOutput)output1);
            byte[] bytes2 = BytesReference.toBytes((BytesReference)output1.bytes());
            return Arrays.equals(bytes1, bytes2);
        }
        catch (Exception e) {
            throw Exceptions.illegalState("could not compare search requests", e, new Object[0]);
        }
    }
}

