/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Integers {
    private Integers() {
    }

    public static Iterable<Integer> asIterable(final int[] values) {
        Objects.requireNonNull(values);
        return () -> new Iterator<Integer>(){
            private int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < values.length;
            }

            @Override
            public Integer next() {
                if (this.position < values.length) {
                    return values[this.position++];
                }
                throw new NoSuchElementException("position: " + this.position + ", length: " + values.length);
            }
        };
    }

    public static boolean contains(int[] values, int value) {
        return Arrays.stream(values).anyMatch(v -> v == value);
    }
}

