/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.execution.ActionExecutionMode;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchRequestBuilder;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class RestExecuteWatchAction
extends WatcherRestHandler {
    final TriggerService triggerService;

    @Inject
    public RestExecuteWatchAction(Settings settings, RestController controller, TriggerService triggerService) {
        super(settings);
        this.triggerService = triggerService;
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}/_execute", (RestHandler)this, RestRequest.Method.POST, "/_watcher/watch/{id}/_execute", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}/_execute", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/watch/{id}/_execute", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/watch/_execute", (RestHandler)this, RestRequest.Method.POST, "/_watcher/watch/_execute", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/watch/_execute", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/watch/_execute", this.deprecationLogger);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(final RestRequest request, WatcherClient client) throws IOException {
        ExecuteWatchRequest executeWatchRequest = this.parseRequest(request, client);
        return channel -> client.executeWatch(executeWatchRequest, (ActionListener<ExecuteWatchResponse>)new RestBuilderListener<ExecuteWatchResponse>(channel){

            public RestResponse buildResponse(ExecuteWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field(Field.ID.getPreferredName(), response.getRecordId());
                builder.field(Field.WATCH_RECORD.getPreferredName(), (ToXContent)response.getRecordSource(), (ToXContent.Params)request);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    private ExecuteWatchRequest parseRequest(RestRequest request, WatcherClient client) throws IOException {
        XContentParser.Token token;
        ExecuteWatchRequestBuilder builder = client.prepareExecuteWatch();
        builder.setId(request.param("id"));
        builder.setDebug(WatcherParams.debug((ToXContent.Params)request));
        if (request.content() == null || request.content().length() == 0) {
            return (ExecuteWatchRequest)builder.request();
        }
        builder.setRecordExecution(request.paramAsBoolean(Field.RECORD_EXECUTION.getPreferredName(), ((ExecuteWatchRequest)builder.request()).isRecordExecution()));
        builder.setIgnoreCondition(request.paramAsBoolean(Field.IGNORE_CONDITION.getPreferredName(), ((ExecuteWatchRequest)builder.request()).isIgnoreCondition()));
        XContentParser parser = XContentHelper.createParser((BytesReference)request.content());
        parser.nextToken();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.IGNORE_CONDITION)) {
                    builder.setIgnoreCondition(parser.booleanValue());
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.RECORD_EXECUTION)) {
                    builder.setRecordExecution(parser.booleanValue());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch execution request. unexpected boolean field [{}]", new Object[]{currentFieldName});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ALTERNATIVE_INPUT)) {
                    builder.setAlternativeInput(parser.map());
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TRIGGER_DATA)) {
                    builder.setTriggerData(parser.map());
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.WATCH)) {
                    XContentBuilder watcherSource = XContentBuilder.builder((XContent)parser.contentType().xContent());
                    XContentHelper.copyCurrentStructure((XContentGenerator)watcherSource.generator(), (XContentParser)parser);
                    builder.setWatchSource(watcherSource.bytes());
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ACTION_MODES)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            try {
                                ActionExecutionMode mode = ActionExecutionMode.resolve(parser.textOrNull());
                                builder.setActionMode(currentFieldName, mode);
                                continue;
                            }
                            catch (IllegalArgumentException iae) {
                                throw new ElasticsearchParseException("could not parse watch execution request", (Throwable)iae, new Object[0]);
                            }
                        }
                        throw new ElasticsearchParseException("could not parse watch execution request. unexpected array field [{}]", new Object[]{currentFieldName});
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch execution request. unexpected object field [{}]", new Object[]{currentFieldName});
            }
            throw new ElasticsearchParseException("could not parse watch execution request. unexpected token [{}]", new Object[]{token});
        }
        return (ExecuteWatchRequest)builder.request();
    }

    static interface Field {
        public static final ParseField ID = new ParseField("_id", new String[0]);
        public static final ParseField WATCH_RECORD = new ParseField("watch_record", new String[0]);
        public static final ParseField RECORD_EXECUTION = new ParseField("record_execution", new String[0]);
        public static final ParseField ACTION_MODES = new ParseField("action_modes", new String[0]);
        public static final ParseField ALTERNATIVE_INPUT = new ParseField("alternative_input", new String[0]);
        public static final ParseField IGNORE_CONDITION = new ParseField("ignore_condition", new String[0]);
        public static final ParseField TRIGGER_DATA = new ParseField("trigger_data", new String[0]);
        public static final ParseField WATCH = new ParseField("watch", new String[0]);
    }
}

