/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.common.stats.Counters;
import org.elasticsearch.xpack.support.clock.Clock;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.execution.CurrentExecutions;
import org.elasticsearch.xpack.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.watcher.execution.QueuedWatch;
import org.elasticsearch.xpack.watcher.execution.TriggeredExecutionContext;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatchStore;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionSnapshot;
import org.elasticsearch.xpack.watcher.execution.WatchExecutor;
import org.elasticsearch.xpack.watcher.history.HistoryStore;
import org.elasticsearch.xpack.watcher.history.WatchRecord;
import org.elasticsearch.xpack.watcher.input.Input;
import org.elasticsearch.xpack.watcher.transform.Transform;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.watch.WatchLockService;
import org.elasticsearch.xpack.watcher.watch.WatchStore;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ExecutionService
extends AbstractComponent {
    public static final Setting<TimeValue> DEFAULT_THROTTLE_PERIOD_SETTING = Setting.positiveTimeSetting((String)"xpack.watcher.execution.default_throttle_period", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final MeanMetric totalExecutionsTime = new MeanMetric();
    private final Map<String, MeanMetric> actionByTypeExecutionTime = new HashMap<String, MeanMetric>();
    private final HistoryStore historyStore;
    private final TriggeredWatchStore triggeredWatchStore;
    private final WatchExecutor executor;
    private final WatchStore watchStore;
    private final WatchLockService watchLockService;
    private final Clock clock;
    private final TimeValue defaultThrottlePeriod;
    private final TimeValue maxStopTimeout;
    private final ThreadPool threadPool;
    private volatile CurrentExecutions currentExecutions = null;
    private final AtomicBoolean started = new AtomicBoolean(false);

    @Inject
    public ExecutionService(Settings settings, HistoryStore historyStore, TriggeredWatchStore triggeredWatchStore, WatchExecutor executor, WatchStore watchStore, WatchLockService watchLockService, Clock clock, ThreadPool threadPool) {
        super(settings);
        this.historyStore = historyStore;
        this.triggeredWatchStore = triggeredWatchStore;
        this.executor = executor;
        this.watchStore = watchStore;
        this.watchLockService = watchLockService;
        this.clock = clock;
        this.defaultThrottlePeriod = (TimeValue)DEFAULT_THROTTLE_PERIOD_SETTING.get(settings);
        this.maxStopTimeout = (TimeValue)Watcher.MAX_STOP_TIMEOUT_SETTING.get(settings);
        this.threadPool = threadPool;
    }

    public void start(ClusterState state) throws Exception {
        if (this.started.get()) {
            return;
        }
        assert (this.executor.queue().isEmpty()) : "queue should be empty, but contains " + this.executor.queue().size() + " elements.";
        if (this.started.compareAndSet(false, true)) {
            try {
                this.logger.debug("starting execution service");
                this.historyStore.start();
                this.triggeredWatchStore.start();
                this.currentExecutions = new CurrentExecutions();
                Collection<TriggeredWatch> triggeredWatches = this.triggeredWatchStore.loadTriggeredWatches(state);
                this.executeTriggeredWatches(triggeredWatches);
                this.logger.debug("started execution service");
            }
            catch (Exception e) {
                this.started.set(false);
                throw e;
            }
        }
    }

    public boolean validate(ClusterState state) {
        return this.triggeredWatchStore.validate(state);
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.logger.debug("stopping execution service");
            int cancelledTaskCount = this.executor.queue().drainTo(new ArrayList());
            this.currentExecutions.sealAndAwaitEmpty(this.maxStopTimeout);
            this.triggeredWatchStore.stop();
            this.historyStore.stop();
            this.logger.debug("cancelled [{}] queued tasks", (Object)cancelledTaskCount);
            this.logger.debug("stopped execution service");
        }
    }

    public boolean started() {
        return this.started.get();
    }

    public TimeValue defaultThrottlePeriod() {
        return this.defaultThrottlePeriod;
    }

    public long executionThreadPoolQueueSize() {
        return this.executor.queue().size();
    }

    public long executionThreadPoolMaxSize() {
        return this.executor.largestPoolSize();
    }

    public List<WatchExecutionSnapshot> currentExecutions() {
        ArrayList<WatchExecutionSnapshot> currentExecutions = new ArrayList<WatchExecutionSnapshot>();
        for (WatchExecution watchExecution : this.currentExecutions) {
            currentExecutions.add(watchExecution.createSnapshot());
        }
        Collections.sort(currentExecutions, Comparator.comparing(WatchExecutionSnapshot::executionTime));
        return currentExecutions;
    }

    public List<QueuedWatch> queuedWatches() {
        ArrayList snapshot = new ArrayList();
        this.executor.tasks().forEach(t -> snapshot.add(t));
        if (snapshot.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueuedWatch> queuedWatches = new ArrayList<QueuedWatch>(snapshot.size());
        for (Runnable task : snapshot) {
            WatchExecutionTask executionTask = (WatchExecutionTask)task;
            queuedWatches.add(new QueuedWatch(executionTask.ctx));
        }
        Collections.sort(queuedWatches, Comparator.comparing(QueuedWatch::executionTime));
        return queuedWatches;
    }

    void processEventsAsync(Iterable<TriggerEvent> events) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("not started");
        }
        final LinkedList<TriggeredWatch> triggeredWatches = new LinkedList<TriggeredWatch>();
        final LinkedList<TriggeredExecutionContext> contexts = new LinkedList<TriggeredExecutionContext>();
        DateTime now = this.clock.now(DateTimeZone.UTC);
        for (TriggerEvent event : events) {
            Watch watch = this.watchStore.get(event.jobName());
            if (watch == null) {
                this.logger.warn("unable to find watch [{}] in the watch store, perhaps it has been deleted", (Object)event.jobName());
                continue;
            }
            TriggeredExecutionContext ctx = new TriggeredExecutionContext(watch, now, event, this.defaultThrottlePeriod);
            contexts.add(ctx);
            triggeredWatches.add(new TriggeredWatch(ctx.id(), event));
        }
        this.logger.debug("saving watch records [{}]", (Object)triggeredWatches.size());
        this.triggeredWatchStore.putAll(triggeredWatches, new ActionListener<List<Integer>>(){

            public void onResponse(List<Integer> successFullSlots) {
                for (Integer slot : successFullSlots) {
                    TriggeredWatch triggeredWatch = (TriggeredWatch)triggeredWatches.get(slot);
                    try {
                        ExecutionService.this.executeAsync((WatchExecutionContext)contexts.get(slot), triggeredWatch);
                    }
                    catch (Exception e) {
                        ExecutionService.this.logger.error(() -> new ParameterizedMessage("failed to execute watch [{}]", (Object)triggeredWatch.id()), (Throwable)e);
                    }
                }
            }

            public void onFailure(Exception e) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof EsRejectedExecutionException) {
                    ExecutionService.this.logger.debug("failed to store watch records due to overloaded threadpool [{}]", (Object)ExceptionsHelper.detailedMessage((Throwable)e));
                } else {
                    ExecutionService.this.logger.warn("failed to store watch records", (Throwable)e);
                }
            }
        });
    }

    void processEventsSync(Iterable<TriggerEvent> events) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("not started");
        }
        LinkedList<TriggeredWatch> triggeredWatches = new LinkedList<TriggeredWatch>();
        LinkedList<TriggeredExecutionContext> contexts = new LinkedList<TriggeredExecutionContext>();
        DateTime now = this.clock.now(DateTimeZone.UTC);
        for (TriggerEvent event : events) {
            Watch watch = this.watchStore.get(event.jobName());
            if (watch == null) {
                this.logger.warn("unable to find watch [{}] in the watch store, perhaps it has been deleted", (Object)event.jobName());
                continue;
            }
            TriggeredExecutionContext ctx = new TriggeredExecutionContext(watch, now, event, this.defaultThrottlePeriod);
            contexts.add(ctx);
            triggeredWatches.add(new TriggeredWatch(ctx.id(), event));
        }
        this.logger.debug("saving watch records [{}]", (Object)triggeredWatches.size());
        if (triggeredWatches.size() == 0) {
            return;
        }
        List<Integer> slots = this.triggeredWatchStore.putAll(triggeredWatches);
        for (Integer slot : slots) {
            this.executeAsync((WatchExecutionContext)contexts.get(slot), triggeredWatches.get(slot));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchRecord execute(WatchExecutionContext ctx) {
        WatchRecord record = null;
        Releasable releasable = this.watchLockService.acquire(ctx.watch().id());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("acquired lock for [{}] -- [{}]", (Object)ctx.id(), (Object)System.identityHashCode(releasable));
        }
        try {
            this.currentExecutions.put(ctx.watch().id(), new WatchExecution(ctx, Thread.currentThread()));
            if (ctx.knownWatch() && this.watchStore.get(ctx.watch().id()) == null) {
                String message = "unable to find watch for record [" + ctx.id() + "], perhaps it has been deleted, ignoring...";
                this.logger.warn("{}", (Object)message);
                record = ctx.abortBeforeExecution(ExecutionState.NOT_EXECUTED_WATCH_MISSING, message);
            } else {
                this.logger.debug("executing watch [{}]", (Object)ctx.id().watchId());
                record = this.executeInner(ctx);
                if (ctx.recordExecution()) {
                    this.watchStore.updateStatus(ctx.watch());
                }
            }
        }
        catch (Exception e) {
            record = this.createWatchRecord(record, ctx, e);
            this.logWatchRecord(ctx, e);
        }
        finally {
            if (ctx.knownWatch() && record != null && ctx.recordExecution()) {
                try {
                    if (ctx.overrideRecordOnConflict()) {
                        this.historyStore.forcePut(record);
                    } else {
                        this.historyStore.put(record);
                    }
                }
                catch (Exception e) {
                    this.logger.error(() -> new ParameterizedMessage("failed to update watch record [{}]", (Object)ctx.id()), (Throwable)e);
                }
            }
            try {
                this.triggeredWatchStore.delete(ctx.id());
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("failed to delete triggered watch [{}]", (Object)ctx.id()), (Throwable)e);
            }
            this.currentExecutions.remove(ctx.watch().id());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("releasing lock for [{}] -- [{}]", (Object)ctx.id(), (Object)System.identityHashCode(releasable));
            }
            releasable.close();
            this.logger.trace("finished [{}]/[{}]", (Object)ctx.watch().id(), (Object)ctx.id());
        }
        return record;
    }

    private WatchRecord createWatchRecord(WatchRecord existingRecord, WatchExecutionContext ctx, Exception e) {
        if (ctx.executionPhase().sealed()) {
            if (existingRecord == null) {
                return new WatchRecord.ExceptionWatchRecord(ctx, e);
            }
            return new WatchRecord.ExceptionWatchRecord(existingRecord, e);
        }
        return ctx.abortFailedExecution(e);
    }

    private void logWatchRecord(WatchExecutionContext ctx, Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> new ParameterizedMessage("failed to execute watch [{}]", (Object)ctx.id()), (Throwable)e);
        } else {
            this.logger.warn("Failed to execute watch [{}]", (Object)ctx.id());
        }
    }

    private void executeAsync(WatchExecutionContext ctx, TriggeredWatch triggeredWatch) {
        try {
            this.executor.execute(new WatchExecutionTask(ctx));
        }
        catch (EsRejectedExecutionException e) {
            this.threadPool.generic().execute(() -> {
                String message = "failed to run triggered watch [" + triggeredWatch.id() + "] due to thread pool capacity";
                this.logger.debug("{}", (Object)message);
                WatchRecord record = ctx.abortBeforeExecution(ExecutionState.FAILED, message);
                try {
                    if (ctx.overrideRecordOnConflict()) {
                        this.historyStore.forcePut(record);
                    } else {
                        this.historyStore.put(record);
                    }
                }
                catch (Exception exc) {
                    this.logger.error(() -> new ParameterizedMessage("Error storing watch history record for watch [{}] after thread pool rejection", (Object)triggeredWatch.id()), (Throwable)exc);
                }
                try {
                    this.triggeredWatchStore.delete(triggeredWatch.id());
                }
                catch (Exception exc) {
                    this.logger.error(() -> new ParameterizedMessage("Error deleting triggered watch store record for watch [{}] after thread pool rejection", (Object)triggeredWatch.id()), (Throwable)exc);
                }
            });
        }
    }

    WatchRecord executeInner(WatchExecutionContext ctx) {
        ctx.start();
        Watch watch = ctx.watch();
        ctx.beforeInput();
        Input.Result inputResult = ctx.inputResult();
        if (inputResult == null) {
            inputResult = watch.input().execute(ctx, ctx.payload());
            ctx.onInputResult(inputResult);
        }
        if (inputResult.status() == Input.Result.Status.FAILURE) {
            return ctx.abortFailedExecution("failed to execute watch input");
        }
        ctx.beforeCondition();
        Condition.Result conditionResult = ctx.conditionResult();
        if (conditionResult == null) {
            conditionResult = watch.condition().execute(ctx);
            ctx.onConditionResult(conditionResult);
        }
        if (conditionResult.status() == Condition.Result.Status.FAILURE) {
            return ctx.abortFailedExecution("failed to execute watch condition");
        }
        if (conditionResult.met()) {
            if (watch.actions().size() > 0 && watch.transform() != null) {
                ctx.beforeWatchTransform();
                Iterator<ActionWrapper> transformResult = watch.transform().execute(ctx, ctx.payload());
                ctx.onWatchTransformResult((Transform.Result)((Object)transformResult));
                if (((Transform.Result)((Object)transformResult)).status() == Transform.Result.Status.FAILURE) {
                    return ctx.abortFailedExecution("failed to execute watch transform");
                }
            }
            ctx.beforeActions();
            for (ActionWrapper action : watch.actions()) {
                long now = System.currentTimeMillis();
                ActionWrapper.Result actionResult = action.execute(ctx);
                long executionTime = System.currentTimeMillis() - now;
                String type = action.action().type();
                this.actionByTypeExecutionTime.putIfAbsent(type, new MeanMetric());
                this.actionByTypeExecutionTime.get(type).inc(executionTime);
                ctx.onActionResult(actionResult);
            }
        }
        WatchRecord record = ctx.finish();
        this.totalExecutionsTime.inc(record.result().executionDurationMs());
        return record;
    }

    void executeTriggeredWatches(Collection<TriggeredWatch> triggeredWatches) throws Exception {
        assert (triggeredWatches != null);
        int counter = 0;
        for (TriggeredWatch triggeredWatch : triggeredWatches) {
            Watch watch = this.watchStore.get(triggeredWatch.id().watchId());
            if (watch == null) {
                String message = "unable to find watch for record [" + triggeredWatch.id().watchId() + "]/[" + triggeredWatch.id() + "], perhaps it has been deleted, ignoring...";
                WatchRecord.MessageWatchRecord record = new WatchRecord.MessageWatchRecord(triggeredWatch.id(), triggeredWatch.triggerEvent(), ExecutionState.NOT_EXECUTED_WATCH_MISSING, message);
                this.historyStore.forcePut(record);
                this.triggeredWatchStore.delete(triggeredWatch.id());
                continue;
            }
            StartupExecutionContext ctx = new StartupExecutionContext(watch, this.clock.now(DateTimeZone.UTC), triggeredWatch.triggerEvent(), this.defaultThrottlePeriod);
            this.executeAsync(ctx, triggeredWatch);
            ++counter;
        }
        this.logger.debug("executed [{}] watches from the watch history", (Object)counter);
    }

    public Map<String, Object> usageStats() {
        Counters counters = new Counters(new String[0]);
        counters.inc("execution.actions._all.total", this.totalExecutionsTime.count());
        counters.inc("execution.actions._all.total_time_in_ms", this.totalExecutionsTime.sum());
        for (Map.Entry<String, MeanMetric> entry : this.actionByTypeExecutionTime.entrySet()) {
            counters.inc("execution.actions." + entry.getKey() + ".total", entry.getValue().count());
            counters.inc("execution.actions." + entry.getKey() + ".total_time_in_ms", entry.getValue().sum());
        }
        return counters.toMap();
    }

    public void clearExecutions() {
        this.currentExecutions.sealAndAwaitEmpty(this.maxStopTimeout);
        this.currentExecutions = new CurrentExecutions();
    }

    public static class WatchExecution {
        private final WatchExecutionContext context;
        private final Thread executionThread;

        public WatchExecution(WatchExecutionContext context, Thread executionThread) {
            this.context = context;
            this.executionThread = executionThread;
        }

        public WatchExecutionSnapshot createSnapshot() {
            return this.context.createSnapshot(this.executionThread);
        }
    }

    private final class WatchExecutionTask
    implements Runnable {
        private final WatchExecutionContext ctx;

        private WatchExecutionTask(WatchExecutionContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            try {
                ExecutionService.this.execute(this.ctx);
            }
            catch (Exception e) {
                ExecutionService.this.logger.error(() -> new ParameterizedMessage("could not execute watch [{}]/[{}]", (Object)this.ctx.watch().id(), (Object)this.ctx.id()), (Throwable)e);
            }
        }
    }

    private static final class StartupExecutionContext
    extends TriggeredExecutionContext {
        public StartupExecutionContext(Watch watch, DateTime executionTime, TriggerEvent triggerEvent, TimeValue defaultThrottlePeriod) {
            super(watch, executionTime, triggerEvent, defaultThrottlePeriod);
        }

        @Override
        public boolean overrideRecordOnConflict() {
            return true;
        }
    }
}

