/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.watcher.actions.index.IndexAction;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.ArrayObjectIterator;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;
import org.elasticsearch.xpack.watcher.support.xcontent.XContentSource;
import org.elasticsearch.xpack.watcher.watch.Payload;
import org.joda.time.DateTime;

public class ExecutableIndexAction
extends ExecutableAction<IndexAction> {
    private final WatcherClientProxy client;
    private final TimeValue timeout;

    public ExecutableIndexAction(IndexAction action, Logger logger, WatcherClientProxy client, @Nullable TimeValue defaultTimeout) {
        super(action, logger);
        this.client = client;
        this.timeout = action.timeout != null ? action.timeout : defaultTimeout;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        Map<String, Object> data = payload.data();
        if (data.containsKey("_doc")) {
            Object doc = data.get("_doc");
            if (doc instanceof Iterable) {
                return this.indexBulk((Iterable)doc, actionId, ctx);
            }
            if (doc.getClass().isArray()) {
                return this.indexBulk(new ArrayObjectIterator.Iterable(doc), actionId, ctx);
            }
            if (doc instanceof Map) {
                data = (Map<String, Object>)doc;
            } else {
                throw Exceptions.illegalState("could not execute action [{}] of watch [{}]. failed to index payload data.[_data] field must either hold a Map or an List/Array of Maps", actionId, ctx.watch().id());
            }
        }
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(((IndexAction)this.action).index);
        indexRequest.type(((IndexAction)this.action).docType);
        data = this.addTimestampToDocument(data, ctx.executionTime());
        indexRequest.source(XContentFactory.jsonBuilder().prettyPrint().map(data));
        if (ctx.simulateAction(actionId)) {
            return new IndexAction.Result.Simulated(indexRequest.index(), ((IndexAction)this.action).docType, new XContentSource(indexRequest.source(), XContentType.JSON));
        }
        IndexResponse response = this.client.index(indexRequest, this.timeout);
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
        ExecutableIndexAction.indexResponseToXContent(jsonBuilder, response);
        return new IndexAction.Result.Success(new XContentSource(jsonBuilder));
    }

    Action.Result indexBulk(Iterable list, String actionId, WatchExecutionContext ctx) throws Exception {
        BulkRequest bulkRequest = new BulkRequest();
        for (Object item : list) {
            if (!(item instanceof Map)) {
                throw Exceptions.illegalState("could not execute action [{}] of watch [{}]. failed to index payload data. [_data] field must either hold a Map or an List/Array of Maps", actionId, ctx.watch().id());
            }
            Map<String, Object> doc = (Map<String, Object>)item;
            IndexRequest indexRequest = new IndexRequest();
            indexRequest.index(((IndexAction)this.action).index);
            indexRequest.type(((IndexAction)this.action).docType);
            doc = this.addTimestampToDocument(doc, ctx.executionTime());
            indexRequest.source(XContentFactory.jsonBuilder().prettyPrint().map(doc));
            bulkRequest.add(indexRequest);
        }
        BulkResponse bulkResponse = this.client.bulk(bulkRequest, ((IndexAction)this.action).timeout);
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startArray();
        for (BulkItemResponse item : bulkResponse) {
            IndexResponse response = (IndexResponse)item.getResponse();
            ExecutableIndexAction.indexResponseToXContent(jsonBuilder, response);
        }
        jsonBuilder.endArray();
        return new IndexAction.Result.Success(new XContentSource(jsonBuilder.bytes(), XContentType.JSON));
    }

    private Map<String, Object> addTimestampToDocument(Map<String, Object> data, DateTime executionTime) {
        if (((IndexAction)this.action).executionTimeField != null) {
            if (!(data instanceof HashMap)) {
                data = new HashMap<String, Object>(data);
            }
            data.put(((IndexAction)this.action).executionTimeField, WatcherDateTimeUtils.formatDate(executionTime));
        }
        return data;
    }

    static void indexResponseToXContent(XContentBuilder builder, IndexResponse response) throws IOException {
        builder.startObject().field("created", response.getResult() == DocWriteResponse.Result.CREATED).field("result", response.getResult().getLowercase()).field("id", response.getId()).field("version", response.getVersion()).field("type", response.getType()).field("index", response.getIndex()).endObject();
    }
}

