/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.hipchat;

import com.google.common.base.Objects;
import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.text.TextTemplate;
import org.elasticsearch.xpack.notification.hipchat.HipChatMessage;
import org.elasticsearch.xpack.notification.hipchat.SentMessages;
import org.elasticsearch.xpack.watcher.actions.Action;

public class HipChatAction
implements Action {
    public static final String TYPE = "hipchat";
    @Nullable
    final String account;
    @Nullable
    final HttpProxy proxy;
    final HipChatMessage.Template message;

    public HipChatAction(@Nullable String account, HipChatMessage.Template message, @Nullable HttpProxy proxy) {
        this.account = account;
        this.message = message;
        this.proxy = proxy;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HipChatAction that = (HipChatAction)o;
        return Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.message, (Object)that.message) && Objects.equal((Object)this.proxy, (Object)that.proxy);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.account, this.message, this.proxy});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.account != null) {
            builder.field(Field.ACCOUNT.getPreferredName(), this.account);
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, params);
        }
        builder.field(Field.MESSAGE.getPreferredName(), (ToXContent)this.message);
        return builder.endObject();
    }

    public static HipChatAction parse(String watchId, String actionId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String account = null;
        HipChatMessage.Template message = null;
        HttpProxy proxy = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ACCOUNT)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    account = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. expected [{}] to be of type string, but found [{}] instead", new Object[]{TYPE, watchId, actionId, Field.ACCOUNT.getPreferredName(), token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.PROXY)) {
                proxy = HttpProxy.parse(parser);
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.MESSAGE)) {
                try {
                    message = HipChatMessage.Template.parse(parser);
                    continue;
                }
                catch (Exception e) {
                    throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. failed to parse [{}] field", (Throwable)e, new Object[]{TYPE, watchId, actionId, Field.MESSAGE.getPreferredName()});
                }
            }
            throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. unexpected token [{}]", new Object[]{TYPE, watchId, actionId, token});
        }
        if (message == null) {
            throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. missing required [{}] field", new Object[]{TYPE, watchId, actionId, Field.MESSAGE.getPreferredName()});
        }
        return new HipChatAction(account, message, proxy);
    }

    public static Builder builder(String account, TextTemplate body) {
        return new Builder(account, body);
    }

    public static interface Field {
        public static final ParseField ACCOUNT = new ParseField("account", new String[0]);
        public static final ParseField MESSAGE = new ParseField("message", new String[0]);
        public static final ParseField PROXY = new ParseField("proxy", new String[0]);
    }

    public static class Builder
    implements Action.Builder<HipChatAction> {
        final String account;
        final HipChatMessage.Template.Builder messageBuilder;
        private HttpProxy proxy;

        public Builder(String account, TextTemplate body) {
            this.account = account;
            this.messageBuilder = new HipChatMessage.Template.Builder(body);
        }

        public Builder addRooms(TextTemplate ... rooms) {
            this.messageBuilder.addRooms(rooms);
            return this;
        }

        public Builder addRooms(String ... rooms) {
            TextTemplate[] templates = new TextTemplate[rooms.length];
            for (int i = 0; i < rooms.length; ++i) {
                templates[i] = new TextTemplate(rooms[i]);
            }
            return this.addRooms(templates);
        }

        public Builder addUsers(TextTemplate ... users) {
            this.messageBuilder.addUsers(users);
            return this;
        }

        public Builder addUsers(String ... users) {
            TextTemplate[] templates = new TextTemplate[users.length];
            for (int i = 0; i < users.length; ++i) {
                templates[i] = new TextTemplate(users[i]);
            }
            return this.addUsers(templates);
        }

        public Builder setFrom(String from) {
            this.messageBuilder.setFrom(from);
            return this;
        }

        public Builder setFormat(HipChatMessage.Format format) {
            this.messageBuilder.setFormat(format);
            return this;
        }

        public Builder setColor(TextTemplate color) {
            this.messageBuilder.setColor(color);
            return this;
        }

        public Builder setColor(HipChatMessage.Color color) {
            return this.setColor(color.asTemplate());
        }

        public Builder setNotify(boolean notify) {
            this.messageBuilder.setNotify(notify);
            return this;
        }

        public Builder setProxy(HttpProxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @Override
        public HipChatAction build() {
            return new HipChatAction(this.account, this.messageBuilder.build(), this.proxy);
        }
    }

    public static interface Result {

        public static class Simulated
        extends Action.Result
        implements Result {
            private final HipChatMessage message;

            protected Simulated(HipChatMessage message) {
                super(HipChatAction.TYPE, Action.Result.Status.SIMULATED);
                this.message = message;
            }

            public HipChatMessage getMessage() {
                return this.message;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(Field.MESSAGE.getPreferredName(), (ToXContent)this.message, params).endObject();
            }
        }

        public static class Executed
        extends Action.Result
        implements Result {
            private final SentMessages sentMessages;

            public Executed(SentMessages sentMessages) {
                super(HipChatAction.TYPE, Executed.status(sentMessages));
                this.sentMessages = sentMessages;
            }

            public SentMessages sentMessages() {
                return this.sentMessages;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.field(this.type, (ToXContent)this.sentMessages, params);
            }

            static Action.Result.Status status(SentMessages sentMessages) {
                boolean hasSuccesses = false;
                boolean hasFailures = false;
                for (SentMessages.SentMessage message : sentMessages) {
                    if (message.successful()) {
                        hasSuccesses = true;
                    } else {
                        hasFailures = true;
                    }
                    if (!hasFailures || !hasSuccesses) continue;
                    return Action.Result.Status.PARTIAL_FAILURE;
                }
                return hasFailures ? Action.Result.Status.FAILURE : Action.Result.Status.SUCCESS;
            }
        }
    }
}

