/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.WatcherDateTimeUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class ActionStatus
implements ToXContent {
    private AckStatus ackStatus;
    @Nullable
    private Execution lastExecution;
    @Nullable
    private Execution lastSuccessfulExecution;
    @Nullable
    private Throttle lastThrottle;

    public ActionStatus(DateTime now) {
        this(new AckStatus(now, AckStatus.State.AWAITS_SUCCESSFUL_EXECUTION), null, null, null);
    }

    public ActionStatus(AckStatus ackStatus, @Nullable Execution lastExecution, @Nullable Execution lastSuccessfulExecution, @Nullable Throttle lastThrottle) {
        this.ackStatus = ackStatus;
        this.lastExecution = lastExecution;
        this.lastSuccessfulExecution = lastSuccessfulExecution;
        this.lastThrottle = lastThrottle;
    }

    public AckStatus ackStatus() {
        return this.ackStatus;
    }

    public Execution lastExecution() {
        return this.lastExecution;
    }

    public Execution lastSuccessfulExecution() {
        return this.lastSuccessfulExecution;
    }

    public Throttle lastThrottle() {
        return this.lastThrottle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionStatus that = (ActionStatus)o;
        return Objects.equals(this.ackStatus, that.ackStatus) && Objects.equals(this.lastExecution, that.lastExecution) && Objects.equals(this.lastSuccessfulExecution, that.lastSuccessfulExecution) && Objects.equals(this.lastThrottle, that.lastThrottle);
    }

    public int hashCode() {
        int result = this.ackStatus.hashCode();
        result = 31 * result + (this.lastExecution != null ? this.lastExecution.hashCode() : 0);
        result = 31 * result + (this.lastSuccessfulExecution != null ? this.lastSuccessfulExecution.hashCode() : 0);
        result = 31 * result + (this.lastThrottle != null ? this.lastThrottle.hashCode() : 0);
        return result;
    }

    public void update(DateTime timestamp, Action.Result result) {
        switch (result.status()) {
            case FAILURE: {
                String reason = result instanceof Action.Result.Failure ? ((Action.Result.Failure)result).reason() : "";
                this.lastExecution = Execution.failure(timestamp, reason);
                return;
            }
            case THROTTLED: {
                String reason = result instanceof Action.Result.Throttled ? ((Action.Result.Throttled)result).reason() : "";
                this.lastThrottle = new Throttle(timestamp, reason);
                return;
            }
            case SUCCESS: 
            case SIMULATED: {
                this.lastSuccessfulExecution = this.lastExecution = Execution.successful(timestamp);
                if (this.ackStatus.state != AckStatus.State.AWAITS_SUCCESSFUL_EXECUTION) break;
                this.ackStatus = new AckStatus(timestamp, AckStatus.State.ACKABLE);
            }
        }
    }

    public boolean onAck(DateTime timestamp) {
        if (this.ackStatus.state == AckStatus.State.ACKABLE) {
            this.ackStatus = new AckStatus(timestamp, AckStatus.State.ACKED);
            return true;
        }
        return false;
    }

    public boolean resetAckStatus(DateTime timestamp) {
        if (this.ackStatus.state != AckStatus.State.AWAITS_SUCCESSFUL_EXECUTION) {
            this.ackStatus = new AckStatus(timestamp, AckStatus.State.AWAITS_SUCCESSFUL_EXECUTION);
            return true;
        }
        return false;
    }

    public static void writeTo(ActionStatus status, StreamOutput out) throws IOException {
        AckStatus.writeTo(status.ackStatus, out);
        out.writeBoolean(status.lastExecution != null);
        if (status.lastExecution != null) {
            Execution.writeTo(status.lastExecution, out);
        }
        out.writeBoolean(status.lastSuccessfulExecution != null);
        if (status.lastSuccessfulExecution != null) {
            Execution.writeTo(status.lastSuccessfulExecution, out);
        }
        out.writeBoolean(status.lastThrottle != null);
        if (status.lastThrottle != null) {
            Throttle.writeTo(status.lastThrottle, out);
        }
    }

    public static ActionStatus readFrom(StreamInput in) throws IOException {
        AckStatus ackStatus = AckStatus.readFrom(in);
        Execution lastExecution = in.readBoolean() ? Execution.readFrom(in) : null;
        Execution lastSuccessfulExecution = in.readBoolean() ? Execution.readFrom(in) : null;
        Throttle lastThrottle = in.readBoolean() ? Throttle.readFrom(in) : null;
        return new ActionStatus(ackStatus, lastExecution, lastSuccessfulExecution, lastThrottle);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.ACK_STATUS.getPreferredName(), (ToXContent)this.ackStatus, params);
        if (this.lastExecution != null) {
            builder.field(Field.LAST_EXECUTION.getPreferredName(), (ToXContent)this.lastExecution, params);
        }
        if (this.lastSuccessfulExecution != null) {
            builder.field(Field.LAST_SUCCESSFUL_EXECUTION.getPreferredName(), (ToXContent)this.lastSuccessfulExecution, params);
        }
        if (this.lastThrottle != null) {
            builder.field(Field.LAST_THROTTLE.getPreferredName(), (ToXContent)this.lastThrottle, params);
        }
        return builder.endObject();
    }

    public static ActionStatus parse(String watchId, String actionId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        AckStatus ackStatus = null;
        Execution lastExecution = null;
        Execution lastSuccessfulExecution = null;
        Throttle lastThrottle = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ACK_STATUS)) {
                ackStatus = AckStatus.parse(watchId, actionId, parser);
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.LAST_EXECUTION)) {
                lastExecution = Execution.parse(watchId, actionId, parser);
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.LAST_SUCCESSFUL_EXECUTION)) {
                lastSuccessfulExecution = Execution.parse(watchId, actionId, parser);
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.LAST_THROTTLE)) {
                lastThrottle = Throttle.parse(watchId, actionId, parser);
                continue;
            }
            throw new ElasticsearchParseException("could not parse action status for [{}/{}]. unexpected field [{}]", new Object[]{watchId, actionId, currentFieldName});
        }
        if (ackStatus == null) {
            throw new ElasticsearchParseException("could not parse action status for [{}/{}]. missing required field [{}]", new Object[]{watchId, actionId, Field.ACK_STATUS.getPreferredName()});
        }
        return new ActionStatus(ackStatus, lastExecution, lastSuccessfulExecution, lastThrottle);
    }

    static interface Field {
        public static final ParseField ACK_STATUS = new ParseField("ack", new String[0]);
        public static final ParseField ACK_STATUS_STATE = new ParseField("state", new String[0]);
        public static final ParseField LAST_EXECUTION = new ParseField("last_execution", new String[0]);
        public static final ParseField LAST_SUCCESSFUL_EXECUTION = new ParseField("last_successful_execution", new String[0]);
        public static final ParseField EXECUTION_SUCCESSFUL = new ParseField("successful", new String[0]);
        public static final ParseField LAST_THROTTLE = new ParseField("last_throttle", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
        public static final ParseField REASON = new ParseField("reason", new String[0]);
    }

    public static class Throttle
    implements ToXContent {
        private final DateTime timestamp;
        private final String reason;

        public Throttle(DateTime timestamp, String reason) {
            this.timestamp = timestamp.toDateTime(DateTimeZone.UTC);
            this.reason = reason;
        }

        public DateTime timestamp() {
            return this.timestamp;
        }

        public String reason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Throttle throttle = (Throttle)o;
            if (!this.timestamp.equals((Object)throttle.timestamp)) {
                return false;
            }
            return this.reason.equals(throttle.reason);
        }

        public int hashCode() {
            int result = this.timestamp.hashCode();
            result = 31 * result + this.reason.hashCode();
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(Field.TIMESTAMP.getPreferredName()).value((ReadableInstant)this.timestamp, WatcherDateTimeUtils.dateTimeFormatter.printer()).field(Field.REASON.getPreferredName(), this.reason).endObject();
        }

        public static Throttle parse(String watchId, String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            DateTime timestamp = null;
            String reason = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TIMESTAMP)) {
                    timestamp = WatcherDateTimeUtils.dateTimeFormatter.parser().parseDateTime(parser.text());
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.REASON)) {
                    reason = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. unexpected field [{}.{}]", new Object[]{watchId, actionId, Field.LAST_THROTTLE.getPreferredName(), currentFieldName});
            }
            if (timestamp == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. missing required field [{}.{}]", new Object[]{watchId, actionId, Field.LAST_THROTTLE.getPreferredName(), Field.TIMESTAMP.getPreferredName()});
            }
            if (reason == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. missing required field [{}.{}]", new Object[]{watchId, actionId, Field.LAST_THROTTLE.getPreferredName(), Field.REASON.getPreferredName()});
            }
            return new Throttle(timestamp, reason);
        }

        static void writeTo(Throttle throttle, StreamOutput out) throws IOException {
            out.writeLong(throttle.timestamp.getMillis());
            out.writeString(throttle.reason);
        }

        static Throttle readFrom(StreamInput in) throws IOException {
            DateTime timestamp = new DateTime(in.readLong(), DateTimeZone.UTC);
            return new Throttle(timestamp, in.readString());
        }
    }

    public static class Execution
    implements ToXContent {
        private final DateTime timestamp;
        private final boolean successful;
        private final String reason;

        public static Execution successful(DateTime timestamp) {
            return new Execution(timestamp, true, null);
        }

        public static Execution failure(DateTime timestamp, String reason) {
            return new Execution(timestamp, false, reason);
        }

        private Execution(DateTime timestamp, boolean successful, String reason) {
            this.timestamp = timestamp.toDateTime(DateTimeZone.UTC);
            this.successful = successful;
            this.reason = reason;
        }

        public DateTime timestamp() {
            return this.timestamp;
        }

        public boolean successful() {
            return this.successful;
        }

        public String reason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Execution execution = (Execution)o;
            if (this.successful != execution.successful) {
                return false;
            }
            if (!this.timestamp.equals((Object)execution.timestamp)) {
                return false;
            }
            return !(this.reason == null ? execution.reason != null : !this.reason.equals(execution.reason));
        }

        public int hashCode() {
            int result = this.timestamp.hashCode();
            result = 31 * result + (this.successful ? 1 : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.TIMESTAMP.getPreferredName()).value((ReadableInstant)this.timestamp, WatcherDateTimeUtils.dateTimeFormatter.printer());
            builder.field(Field.EXECUTION_SUCCESSFUL.getPreferredName(), this.successful);
            if (this.reason != null) {
                builder.field(Field.REASON.getPreferredName(), this.reason);
            }
            return builder.endObject();
        }

        public static Execution parse(String watchId, String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            DateTime timestamp = null;
            Boolean successful = null;
            String reason = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TIMESTAMP)) {
                    timestamp = WatcherDateTimeUtils.dateTimeFormatter.parser().parseDateTime(parser.text());
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.EXECUTION_SUCCESSFUL)) {
                    successful = parser.booleanValue();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.REASON)) {
                    reason = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. unexpected field [{}.{}]", new Object[]{watchId, actionId, Field.LAST_EXECUTION.getPreferredName(), currentFieldName});
            }
            if (timestamp == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. missing required field [{}.{}]", new Object[]{watchId, actionId, Field.LAST_EXECUTION.getPreferredName(), Field.TIMESTAMP.getPreferredName()});
            }
            if (successful == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. missing required field [{}.{}]", new Object[]{watchId, actionId, Field.LAST_EXECUTION.getPreferredName(), Field.EXECUTION_SUCCESSFUL.getPreferredName()});
            }
            if (successful.booleanValue()) {
                return Execution.successful(timestamp);
            }
            if (reason == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. missing required field for unsuccessful execution [{}.{}]", new Object[]{watchId, actionId, Field.LAST_EXECUTION.getPreferredName(), Field.REASON.getPreferredName()});
            }
            return Execution.failure(timestamp, reason);
        }

        public static void writeTo(Execution execution, StreamOutput out) throws IOException {
            out.writeLong(execution.timestamp.getMillis());
            out.writeBoolean(execution.successful);
            if (!execution.successful) {
                out.writeString(execution.reason);
            }
        }

        public static Execution readFrom(StreamInput in) throws IOException {
            DateTime timestamp = new DateTime(in.readLong(), DateTimeZone.UTC);
            boolean successful = in.readBoolean();
            if (successful) {
                return Execution.successful(timestamp);
            }
            return Execution.failure(timestamp, in.readString());
        }
    }

    public static class AckStatus
    implements ToXContent {
        private final DateTime timestamp;
        private final State state;

        public AckStatus(DateTime timestamp, State state) {
            this.timestamp = timestamp.toDateTime(DateTimeZone.UTC);
            this.state = state;
        }

        public DateTime timestamp() {
            return this.timestamp;
        }

        public State state() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AckStatus ackStatus = (AckStatus)o;
            if (!this.timestamp.equals((Object)ackStatus.timestamp)) {
                return false;
            }
            return this.state == ackStatus.state;
        }

        public int hashCode() {
            int result = this.timestamp.hashCode();
            result = 31 * result + this.state.hashCode();
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(Field.TIMESTAMP.getPreferredName()).value((ReadableInstant)this.timestamp, WatcherDateTimeUtils.dateTimeFormatter.printer()).field(Field.ACK_STATUS_STATE.getPreferredName(), this.state.name().toLowerCase(Locale.ROOT)).endObject();
        }

        public static AckStatus parse(String watchId, String actionId, XContentParser parser) throws IOException {
            XContentParser.Token token;
            DateTime timestamp = null;
            State state = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.TIMESTAMP)) {
                    timestamp = WatcherDateTimeUtils.dateTimeFormatter.parser().parseDateTime(parser.text());
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ACK_STATUS_STATE)) {
                    state = State.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    continue;
                }
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. unexpected field [{}.{}]", new Object[]{watchId, actionId, Field.ACK_STATUS.getPreferredName(), currentFieldName});
            }
            if (timestamp == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. missing required field [{}.{}]", new Object[]{watchId, actionId, Field.ACK_STATUS.getPreferredName(), Field.TIMESTAMP.getPreferredName()});
            }
            if (state == null) {
                throw new ElasticsearchParseException("could not parse action status for [{}/{}]. missing required field [{}.{}]", new Object[]{watchId, actionId, Field.ACK_STATUS.getPreferredName(), Field.ACK_STATUS_STATE.getPreferredName()});
            }
            return new AckStatus(timestamp, state);
        }

        static void writeTo(AckStatus status, StreamOutput out) throws IOException {
            out.writeLong(status.timestamp.getMillis());
            out.writeByte(status.state.value);
        }

        static AckStatus readFrom(StreamInput in) throws IOException {
            DateTime timestamp = new DateTime(in.readLong(), DateTimeZone.UTC);
            State state = State.resolve(in.readByte());
            return new AckStatus(timestamp, state);
        }

        public static enum State {
            AWAITS_SUCCESSFUL_EXECUTION(1),
            ACKABLE(2),
            ACKED(3);

            private byte value;

            private State(byte value) {
                this.value = value;
            }

            static State resolve(byte value) {
                switch (value) {
                    case 1: {
                        return AWAITS_SUCCESSFUL_EXECUTION;
                    }
                    case 2: {
                        return ACKABLE;
                    }
                    case 3: {
                        return ACKED;
                    }
                }
                throw Exceptions.illegalArgument("unknown action ack status state value [{}]", value);
            }
        }
    }
}

