/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.ssl.DefaultJDKTrustConfig;
import org.elasticsearch.xpack.ssl.KeyConfig;
import org.elasticsearch.xpack.ssl.PEMKeyConfig;
import org.elasticsearch.xpack.ssl.PEMTrustConfig;
import org.elasticsearch.xpack.ssl.SSLClientAuth;
import org.elasticsearch.xpack.ssl.StoreKeyConfig;
import org.elasticsearch.xpack.ssl.StoreTrustConfig;
import org.elasticsearch.xpack.ssl.TrustAllConfig;
import org.elasticsearch.xpack.ssl.TrustConfig;
import org.elasticsearch.xpack.ssl.VerificationMode;

class SSLConfiguration {
    private static final Setting<List<String>> CIPHERS_SETTING = Setting.listSetting((String)"cipher_suites", Collections.emptyList(), s -> s, (Setting.Property[])new Setting.Property[0]);
    private static final Setting<List<String>> SUPPORTED_PROTOCOLS_SETTING = Setting.listSetting((String)"supported_protocols", Collections.emptyList(), s -> s, (Setting.Property[])new Setting.Property[0]);
    private static final Setting<Optional<String>> KEYSTORE_PATH_SETTING = new Setting("keystore.path", (String)null, Optional::ofNullable, new Setting.Property[0]);
    private static final Setting<Optional<String>> KEYSTORE_PASSWORD_SETTING = new Setting("keystore.password", (String)null, Optional::ofNullable, new Setting.Property[0]);
    private static final Setting<String> KEYSTORE_ALGORITHM_SETTING = new Setting("keystore.algorithm", s -> System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm()), Function.identity(), new Setting.Property[0]);
    private static final Setting<Optional<String>> KEYSTORE_KEY_PASSWORD_SETTING = new Setting("keystore.key_password", KEYSTORE_PASSWORD_SETTING, Optional::ofNullable, new Setting.Property[0]);
    private static final Setting<Optional<String>> TRUSTSTORE_PATH_SETTING = new Setting("truststore.path", (String)null, Optional::ofNullable, new Setting.Property[0]);
    private static final Setting<Optional<String>> TRUSTSTORE_PASSWORD_SETTING = new Setting("truststore.password", (String)null, Optional::ofNullable, new Setting.Property[0]);
    private static final Setting<String> TRUSTSTORE_ALGORITHM_SETTING = new Setting("truststore.algorithm", s -> System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm()), Function.identity(), new Setting.Property[0]);
    private static final Setting<Optional<String>> KEY_PATH_SETTING = new Setting("key", (String)null, Optional::ofNullable, new Setting.Property[0]);
    private static final Setting<Optional<String>> KEY_PASSWORD_SETTING = new Setting("key_passphrase", (String)null, Optional::ofNullable, new Setting.Property[0]);
    private static final Setting<Optional<String>> CERT_SETTING = new Setting("certificate", (String)null, Optional::ofNullable, new Setting.Property[0]);
    private static final Setting<List<String>> CA_PATHS_SETTING = Setting.listSetting((String)"certificate_authorities", Collections.emptyList(), s -> s, (Setting.Property[])new Setting.Property[0]);
    private static final Setting<Optional<SSLClientAuth>> CLIENT_AUTH_SETTING = new Setting("client_authentication", (String)null, s -> {
        if (s == null) {
            return Optional.ofNullable(null);
        }
        return Optional.of(SSLClientAuth.parse(s));
    }, new Setting.Property[0]);
    private static final Setting<Optional<VerificationMode>> VERIFICATION_MODE_SETTING = new Setting("verification_mode", (String)null, s -> {
        if (s == null) {
            return Optional.ofNullable(null);
        }
        return Optional.of(VerificationMode.parse(s));
    }, new Setting.Property[0]);
    private final KeyConfig keyConfig;
    private final TrustConfig trustConfig;
    private final List<String> ciphers;
    private final List<String> supportedProtocols;
    private final SSLClientAuth sslClientAuth;
    private final VerificationMode verificationMode;

    SSLConfiguration(Settings settings) {
        this.keyConfig = SSLConfiguration.createKeyConfig(settings, null);
        this.trustConfig = SSLConfiguration.createTrustConfig(settings, this.keyConfig, null);
        this.ciphers = SSLConfiguration.getListOrDefault(CIPHERS_SETTING, settings, XPackSettings.DEFAULT_CIPHERS);
        this.supportedProtocols = SSLConfiguration.getListOrDefault(SUPPORTED_PROTOCOLS_SETTING, settings, XPackSettings.DEFAULT_SUPPORTED_PROTOCOLS);
        this.sslClientAuth = ((Optional)CLIENT_AUTH_SETTING.get(settings)).orElse(XPackSettings.CLIENT_AUTH_DEFAULT);
        this.verificationMode = ((Optional)VERIFICATION_MODE_SETTING.get(settings)).orElse(XPackSettings.VERIFICATION_MODE_DEFAULT);
    }

    SSLConfiguration(Settings settings, SSLConfiguration globalSSLConfiguration) {
        Objects.requireNonNull(globalSSLConfiguration);
        this.keyConfig = SSLConfiguration.createKeyConfig(settings, globalSSLConfiguration);
        this.trustConfig = SSLConfiguration.createTrustConfig(settings, this.keyConfig, globalSSLConfiguration);
        this.ciphers = SSLConfiguration.getListOrDefault(CIPHERS_SETTING, settings, globalSSLConfiguration.cipherSuites());
        this.supportedProtocols = SSLConfiguration.getListOrDefault(SUPPORTED_PROTOCOLS_SETTING, settings, globalSSLConfiguration.supportedProtocols());
        this.sslClientAuth = ((Optional)CLIENT_AUTH_SETTING.get(settings)).orElse(globalSSLConfiguration.sslClientAuth());
        this.verificationMode = ((Optional)VERIFICATION_MODE_SETTING.get(settings)).orElse(globalSSLConfiguration.verificationMode());
    }

    KeyConfig keyConfig() {
        return this.keyConfig;
    }

    TrustConfig trustConfig() {
        return this.trustConfig;
    }

    List<String> cipherSuites() {
        return this.ciphers;
    }

    List<String> supportedProtocols() {
        return this.supportedProtocols;
    }

    VerificationMode verificationMode() {
        return this.verificationMode;
    }

    SSLClientAuth sslClientAuth() {
        return this.sslClientAuth;
    }

    List<Path> filesToMonitor(@Nullable Environment environment) {
        if (this.keyConfig() == this.trustConfig()) {
            return this.keyConfig().filesToMonitor(environment);
        }
        ArrayList<Path> paths = new ArrayList<Path>(this.keyConfig().filesToMonitor(environment));
        paths.addAll(this.trustConfig().filesToMonitor(environment));
        return paths;
    }

    public String toString() {
        return "SSLConfiguration{keyConfig=[" + this.keyConfig + "], trustConfig=" + this.trustConfig + "], cipherSuites=[" + this.ciphers + "], supportedProtocols=[" + this.supportedProtocols + "], sslClientAuth=[" + (Object)((Object)this.sslClientAuth) + "], verificationMode=[" + (Object)((Object)this.verificationMode) + "]}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SSLConfiguration)) {
            return false;
        }
        SSLConfiguration that = (SSLConfiguration)o;
        if (this.keyConfig() != null ? !this.keyConfig().equals(that.keyConfig()) : that.keyConfig() != null) {
            return false;
        }
        if (this.trustConfig() != null ? !this.trustConfig().equals(that.trustConfig()) : that.trustConfig() != null) {
            return false;
        }
        if (this.cipherSuites() != null ? !this.cipherSuites().equals(that.cipherSuites()) : that.cipherSuites() != null) {
            return false;
        }
        if (!this.supportedProtocols().equals(that.supportedProtocols())) {
            return false;
        }
        if (this.verificationMode() != that.verificationMode()) {
            return false;
        }
        if (this.sslClientAuth() != that.sslClientAuth()) {
            return false;
        }
        return this.supportedProtocols() != null ? this.supportedProtocols().equals(that.supportedProtocols()) : that.supportedProtocols() == null;
    }

    public int hashCode() {
        int result = this.keyConfig() != null ? this.keyConfig().hashCode() : 0;
        result = 31 * result + (this.trustConfig() != null ? this.trustConfig().hashCode() : 0);
        result = 31 * result + (this.cipherSuites() != null ? this.cipherSuites().hashCode() : 0);
        result = 31 * result + (this.supportedProtocols() != null ? this.supportedProtocols().hashCode() : 0);
        result = 31 * result + this.verificationMode().hashCode();
        result = 31 * result + this.sslClientAuth().hashCode();
        return result;
    }

    private static KeyConfig createKeyConfig(Settings settings, SSLConfiguration global) {
        String keyStorePath = ((Optional)KEYSTORE_PATH_SETTING.get(settings)).orElse(null);
        String keyPath = ((Optional)KEY_PATH_SETTING.get(settings)).orElse(null);
        if (keyPath != null && keyStorePath != null) {
            throw new IllegalArgumentException("you cannot specify a keystore and key file");
        }
        if (keyStorePath == null && keyPath == null) {
            if (global != null) {
                return global.keyConfig();
            }
            if (System.getProperty("javax.net.ssl.keyStore") != null) {
                return new StoreKeyConfig(System.getProperty("javax.net.ssl.keyStore"), System.getProperty("javax.net.ssl.keyStorePassword", ""), System.getProperty("javax.net.ssl.keyStorePassword", ""), System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm()), System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm()));
            }
            return KeyConfig.NONE;
        }
        if (keyPath != null) {
            String keyPassword = ((Optional)KEY_PASSWORD_SETTING.get(settings)).orElse(null);
            String certPath = ((Optional)CERT_SETTING.get(settings)).orElse(null);
            if (certPath == null) {
                throw new IllegalArgumentException("you must specify the certificates to use with the key");
            }
            return new PEMKeyConfig(keyPath, keyPassword, certPath);
        }
        String keyStorePassword = ((Optional)KEYSTORE_PASSWORD_SETTING.get(settings)).orElse(null);
        String keyStoreAlgorithm = (String)KEYSTORE_ALGORITHM_SETTING.get(settings);
        String keyStoreKeyPassword = ((Optional)KEYSTORE_KEY_PASSWORD_SETTING.get(settings)).orElse(keyStorePassword);
        String trustStoreAlgorithm = (String)TRUSTSTORE_ALGORITHM_SETTING.get(settings);
        return new StoreKeyConfig(keyStorePath, keyStorePassword, keyStoreKeyPassword, keyStoreAlgorithm, trustStoreAlgorithm);
    }

    private static TrustConfig createTrustConfig(Settings settings, KeyConfig keyConfig, SSLConfiguration global) {
        String trustStorePath = ((Optional)TRUSTSTORE_PATH_SETTING.get(settings)).orElse(null);
        List<String> caPaths = SSLConfiguration.getListOrNull(CA_PATHS_SETTING, settings);
        if (trustStorePath != null && caPaths != null) {
            throw new IllegalArgumentException("you cannot specify a truststore and ca files");
        }
        VerificationMode verificationMode = ((Optional)VERIFICATION_MODE_SETTING.get(settings)).orElseGet(() -> {
            if (global != null) {
                return global.verificationMode();
            }
            return XPackSettings.VERIFICATION_MODE_DEFAULT;
        });
        if (!verificationMode.isCertificateVerificationEnabled()) {
            return TrustAllConfig.INSTANCE;
        }
        if (caPaths != null) {
            return new PEMTrustConfig(caPaths);
        }
        if (trustStorePath != null) {
            String trustStorePassword = ((Optional)TRUSTSTORE_PASSWORD_SETTING.get(settings)).orElse(null);
            String trustStoreAlgorithm = (String)TRUSTSTORE_ALGORITHM_SETTING.get(settings);
            return new StoreTrustConfig(trustStorePath, trustStorePassword, trustStoreAlgorithm);
        }
        if (global == null && System.getProperty("javax.net.ssl.trustStore") != null) {
            return new StoreTrustConfig(System.getProperty("javax.net.ssl.trustStore"), System.getProperty("javax.net.ssl.trustStorePassword", ""), System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm()));
        }
        if (global != null && keyConfig == global.keyConfig()) {
            return global.trustConfig();
        }
        if (keyConfig != KeyConfig.NONE) {
            return DefaultJDKTrustConfig.merge(keyConfig);
        }
        return DefaultJDKTrustConfig.INSTANCE;
    }

    private static List<String> getListOrNull(Setting<List<String>> listSetting, Settings settings) {
        return SSLConfiguration.getListOrDefault(listSetting, settings, null);
    }

    private static List<String> getListOrDefault(Setting<List<String>> listSetting, Settings settings, List<String> defaultValue) {
        if (listSetting.exists(settings)) {
            return (List)listSetting.get(settings);
        }
        return defaultValue;
    }
}

