/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.DelegatingTransportChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.jboss.netty.channel.Channel;

public interface ServerTransportFilter {
    public void inbound(String var1, TransportRequest var2, TransportChannel var3, ActionListener<Void> var4) throws IOException;

    public static class ClientProfile
    extends NodeProfile {
        public ClientProfile(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations) {
            super(authcService, authzService, threadContext, extractClientCert, destructiveOperations);
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) throws IOException {
            boolean isInternalOrShardAction;
            boolean bl = isInternalOrShardAction = action.startsWith("internal:") || action.endsWith("]");
            if (isInternalOrShardAction) {
                throw Exceptions.authenticationError("executing internal/shard actions is considered malicious and forbidden", new Object[0]);
            }
            super.inbound(action, request, transportChannel, listener);
        }
    }

    public static class NodeProfile
    implements ServerTransportFilter {
        private static final Logger logger = Loggers.getLogger(NodeProfile.class);
        private final AuthenticationService authcService;
        private final AuthorizationService authzService;
        private final SecurityActionMapper actionMapper = new SecurityActionMapper();
        private final ThreadContext threadContext;
        private final boolean extractClientCert;
        private final DestructiveOperations destructiveOperations;

        public NodeProfile(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations) {
            this.authcService = authcService;
            this.authzService = authzService;
            this.threadContext = threadContext;
            this.extractClientCert = extractClientCert;
            this.destructiveOperations = destructiveOperations;
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) throws IOException {
            if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
                IndicesRequest indicesRequest = (IndicesRequest)request;
                try {
                    this.destructiveOperations.failDestructive(indicesRequest.indices());
                }
                catch (IllegalArgumentException e) {
                    listener.onFailure((Exception)e);
                }
            }
            String securityAction = this.actionMapper.action(action, request);
            TransportChannel unwrappedChannel = transportChannel;
            while (unwrappedChannel instanceof DelegatingTransportChannel) {
                unwrappedChannel = ((DelegatingTransportChannel)unwrappedChannel).getChannel();
            }
            if (this.extractClientCert && unwrappedChannel instanceof TcpTransportChannel) {
                if (((TcpTransportChannel)unwrappedChannel).getChannel() instanceof Channel) {
                    Channel channel = (Channel)((TcpTransportChannel)unwrappedChannel).getChannel();
                    org.jboss.netty.handler.ssl.SslHandler sslHandler = (org.jboss.netty.handler.ssl.SslHandler)channel.getPipeline().get(org.jboss.netty.handler.ssl.SslHandler.class);
                    assert (sslHandler != null);
                    this.extactClientCertificates(sslHandler.getEngine(), channel);
                } else if (((TcpTransportChannel)unwrappedChannel).getChannel() instanceof io.netty.channel.Channel) {
                    io.netty.channel.Channel channel = (io.netty.channel.Channel)((TcpTransportChannel)unwrappedChannel).getChannel();
                    SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
                    if (channel.isOpen()) {
                        assert (sslHandler != null) : "channel [" + channel + "] did not have a ssl handler. pipeline " + channel.pipeline();
                        this.extactClientCertificates(sslHandler.engine(), channel);
                    }
                }
            }
            this.authcService.authenticate(securityAction, (TransportMessage)request, null, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                AuthorizationUtils.AsyncAuthorizer asyncAuthorizer = new AuthorizationUtils.AsyncAuthorizer((Authentication)authentication, (ActionListener)listener, (userRoles, runAsRoles) -> {
                    this.authzService.authorize((Authentication)authentication, securityAction, request, (Collection<Role>)userRoles, (Collection<Role>)runAsRoles);
                    listener.onResponse(null);
                });
                asyncAuthorizer.authorize(this.authzService);
            }, arg_0 -> listener.onFailure(arg_0)));
        }

        private void extactClientCertificates(SSLEngine sslEngine, Object channel) {
            block6: {
                try {
                    Certificate[] certs = sslEngine.getSession().getPeerCertificates();
                    if (certs instanceof X509Certificate[]) {
                        this.threadContext.putTransient("__SECURITY_CLIENT_CERTIFICATE", (Object)certs);
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    assert (!sslEngine.getNeedClientAuth());
                    assert (sslEngine.getWantClientAuth());
                    if (logger.isTraceEnabled()) {
                        logger.trace(() -> new ParameterizedMessage("SSL Peer did not present a certificate on channel [{}]", channel), (Throwable)e);
                    }
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("SSL Peer did not present a certificate on channel [{}]", channel);
                }
            }
        }
    }
}

