/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.authz.accesscontrol.RequestContext;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;
import org.elasticsearch.xpack.security.transport.netty3.SecurityNetty3Transport;
import org.elasticsearch.xpack.security.user.SystemUser;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityServerTransportInterceptor
implements TransportInterceptor {
    private static final String SETTING_NAME = "xpack.security.type";
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final SSLService sslService;
    private final Map<String, ServerTransportFilter> profileFilters;
    private final XPackLicenseState licenseState;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final SecurityContext securityContext;

    public SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, XPackLicenseState licenseState, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.authcService = authcService;
        this.authzService = authzService;
        this.licenseState = licenseState;
        this.sslService = sslService;
        this.securityContext = securityContext;
        this.profileFilters = this.initializeProfileFilters(destructiveOperations);
    }

    public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                if (SecurityServerTransportInterceptor.this.licenseState.isAuthAllowed()) {
                    if (AuthorizationUtils.shouldReplaceUserWithSystem(SecurityServerTransportInterceptor.this.threadPool.getThreadContext(), action)) {
                        SecurityServerTransportInterceptor.this.securityContext.executeAsUser(SystemUser.INSTANCE, original -> SecurityServerTransportInterceptor.this.sendWithUser(node, action, request, options, new ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext(), (ThreadContext.StoredContext)original, handler), sender));
                    } else {
                        SecurityServerTransportInterceptor.this.sendWithUser(node, action, request, options, handler, sender);
                    }
                } else {
                    sender.sendRequest(node, action, request, options, handler);
                }
            }
        };
    }

    private <T extends TransportResponse> void sendWithUser(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler, TransportInterceptor.AsyncSender sender) {
        if (this.securityContext.getAuthentication() == null) {
            throw new IllegalStateException("there should always be a user when sending a message");
        }
        try {
            sender.sendRequest(node, action, request, options, handler);
        }
        catch (Exception e) {
            handler.handleException(new TransportException("failed sending request", (Throwable)e));
        }
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, TransportRequestHandler<T> actualHandler) {
        return new ProfileSecuredRequestHandler(action, executor, actualHandler, this.profileFilters, this.licenseState, this.threadPool);
    }

    protected Map<String, ServerTransportFilter> initializeProfileFilters(DestructiveOperations destructiveOperations) {
        Map profileSettingsMap = this.settings.getGroups("transport.profiles.", true);
        HashMap profileFilters = new HashMap(profileSettingsMap.size() + 1);
        Settings transportSSLSettings = this.settings.getByPrefix(Security.setting("transport.ssl."));
        block6: for (Map.Entry entry : profileSettingsMap.entrySet()) {
            String type;
            Settings profileSettings = (Settings)entry.getValue();
            boolean profileSsl = (Boolean)SecurityNetty3Transport.PROFILE_SSL_SETTING.get(profileSettings);
            Settings profileSslSettings = SecurityNetty3Transport.profileSslSettings(profileSettings);
            boolean clientAuth = this.sslService.isSSLClientAuthEnabled(profileSslSettings, transportSSLSettings);
            boolean extractClientCert = profileSsl && clientAuth;
            switch (type = ((Settings)entry.getValue()).get(SETTING_NAME, "node")) {
                case "client": {
                    profileFilters.put(entry.getKey(), new ServerTransportFilter.ClientProfile(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations));
                    continue block6;
                }
            }
            profileFilters.put(entry.getKey(), new ServerTransportFilter.NodeProfile(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations));
        }
        if (!profileFilters.containsKey("default")) {
            boolean profileSsl = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
            boolean clientAuth = this.sslService.isSSLClientAuthEnabled(transportSSLSettings);
            boolean extractClientCert = profileSsl && clientAuth;
            profileFilters.put("default", new ServerTransportFilter.NodeProfile(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations));
        }
        return Collections.unmodifiableMap(profileFilters);
    }

    ServerTransportFilter transportFilter(String profile) {
        return this.profileFilters.get(profile);
    }

    static final class ContextRestoreResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final TransportResponseHandler<T> delegate;
        private final ThreadContext.StoredContext context;
        private final ThreadContext threadContext;

        ContextRestoreResponseHandler(ThreadContext threadContext, ThreadContext.StoredContext context, TransportResponseHandler<T> delegate) {
            this.delegate = delegate;
            this.context = context;
            this.threadContext = threadContext;
        }

        public T newInstance() {
            return (T)this.delegate.newInstance();
        }

        public void handleResponse(T response) {
            try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
                this.context.restore();
                this.delegate.handleResponse(response);
            }
        }

        public void handleException(TransportException exp) {
            try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
                this.context.restore();
                this.delegate.handleException(exp);
            }
        }

        public String executor() {
            return this.delegate.executor();
        }

        public String toString() {
            return this.getClass().getName() + "/" + this.delegate.toString();
        }
    }

    public static class ProfileSecuredRequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        protected final String action;
        protected final TransportRequestHandler<T> handler;
        private final Map<String, ServerTransportFilter> profileFilters;
        private final XPackLicenseState licenseState;
        private final ThreadContext threadContext;
        private final String executorName;
        private final ThreadPool threadPool;

        private ProfileSecuredRequestHandler(String action, String executorName, TransportRequestHandler<T> handler, Map<String, ServerTransportFilter> profileFilters, XPackLicenseState licenseState, ThreadPool threadPool) {
            this.action = action;
            this.executorName = executorName;
            this.handler = handler;
            this.profileFilters = profileFilters;
            this.licenseState = licenseState;
            this.threadContext = threadPool.getThreadContext();
            this.threadPool = threadPool;
        }

        public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
            Consumer<Exception> onFailure = e -> {
                try {
                    channel.sendResponse(e);
                }
                catch (IOException e1) {
                    throw new UncheckedIOException(e1);
                }
            };
            Runnable receiveMessage = () -> {
                RequestContext context = new RequestContext((TransportRequest)request, this.threadContext);
                RequestContext.setCurrent(context);
                try {
                    this.handler.messageReceived(request, channel, task);
                }
                catch (Exception e) {
                    onFailure.accept(e);
                }
                finally {
                    RequestContext.removeCurrent();
                }
            };
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext();){
                if (this.licenseState.isAuthAllowed()) {
                    String profile = channel.getProfileName();
                    ServerTransportFilter filter = this.profileFilters.get(profile);
                    if (filter == null) {
                        if (".direct".equals(profile)) {
                            filter = this.profileFilters.get("default");
                        } else {
                            String msg = "transport profile [" + profile + "] is not associated with a transport filter";
                            throw new IllegalStateException(msg);
                        }
                    }
                    assert (filter != null);
                    Thread executingThread = Thread.currentThread();
                    Consumer<Void> consumer = x -> {
                        ExecutorService executor = executingThread == Thread.currentThread() ? this.threadPool.executor("same") : this.threadPool.executor(this.executorName);
                        try {
                            executor.execute(receiveMessage);
                        }
                        catch (Exception e) {
                            onFailure.accept(e);
                        }
                    };
                    ActionListener filterListener = ActionListener.wrap(consumer, onFailure);
                    filter.inbound(this.action, (TransportRequest)request, channel, (ActionListener<Void>)filterListener);
                } else {
                    receiveMessage.run();
                }
            }
            catch (Exception e2) {
                channel.sendResponse(e2);
            }
        }

        public void messageReceived(T request, TransportChannel channel) throws Exception {
            throw new UnsupportedOperationException("task parameter is required for this operation");
        }
    }
}

