/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.user.PutUserRequestBuilder;
import org.elasticsearch.xpack.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;

public class RestPutUserAction
extends BaseRestHandler {
    @Inject
    public RestPutUserAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, "/_xpack/security/user/{username}", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_shield/user/{username}", (RestHandler)this, "[POST /_shield/user/{username}] is deprecated! Use [POST /_xpack/security/user/{username}] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.PUT, "/_shield/user/{username}", (RestHandler)this, "[PUT /_shield/user/{username}] is deprecated! Use [PUT /_xpack/security/user/{username}] instead.", this.deprecationLogger);
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutUserRequestBuilder requestBuilder = new SecurityClient((ElasticsearchClient)client).preparePutUser(request.param("username"), request.content());
        requestBuilder.setRefreshPolicy(request.param("refresh"));
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<PutUserResponse>(channel){

            public RestResponse buildResponse(PutUserResponse putUserResponse, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field("user", (ToXContent)putUserResponse).endObject());
            }
        });
    }
}

