/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty3.Netty3HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityRestFilter
extends RestFilter {
    private final AuthenticationService service;
    private final Logger logger;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final RestController restController;
    private final boolean extractClientCertificate;

    @Inject
    public SecurityRestFilter(AuthenticationService service, RestController controller, Settings settings, ThreadPool threadPool, XPackLicenseState licenseState, SSLService sslService) {
        this.service = service;
        this.licenseState = licenseState;
        this.threadContext = threadPool.getThreadContext();
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (Settings)settings, (String[])new String[0]);
        boolean ssl = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings);
        Settings httpSSLSettings = SSLService.getHttpTransportSSLSettings(settings);
        this.extractClientCertificate = ssl && sslService.isSSLClientAuthEnabled(httpSSLSettings);
        controller.registerFilter((RestFilter)this);
        this.restController = controller;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public void process(RestRequest request, RestChannel channel, NodeClient client, RestFilterChain filterChain) throws Exception {
        if (this.licenseState.isAuthAllowed() && request.method() != RestRequest.Method.OPTIONS) {
            if (this.extractClientCertificate) {
                SecurityRestFilter.putClientCertificateInContext(request, this.threadContext, this.logger);
            }
            this.service.authenticate(request, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                RemoteHostHeader.process(request, this.threadContext);
                filterChain.continueProcessing(request, channel, client);
            }, e -> this.restController.sendErrorResponse(request, channel, e)));
        } else {
            filterChain.continueProcessing(request, channel, client);
        }
    }

    static void putClientCertificateInContext(RestRequest request, ThreadContext threadContext, Logger logger) throws Exception {
        assert (request instanceof Netty3HttpRequest || request instanceof Netty4HttpRequest);
        if (request instanceof Netty3HttpRequest) {
            Netty3HttpRequest nettyHttpRequest = (Netty3HttpRequest)request;
            org.jboss.netty.handler.ssl.SslHandler handler = (org.jboss.netty.handler.ssl.SslHandler)nettyHttpRequest.getChannel().getPipeline().get(org.jboss.netty.handler.ssl.SslHandler.class);
            assert (handler != null);
            SecurityRestFilter.extractClientCerts(handler.getEngine(), nettyHttpRequest.getChannel(), threadContext, logger);
        } else if (request instanceof Netty4HttpRequest) {
            Netty4HttpRequest nettyHttpRequest = (Netty4HttpRequest)request;
            SslHandler handler = (SslHandler)nettyHttpRequest.getChannel().pipeline().get(SslHandler.class);
            assert (handler != null);
            SecurityRestFilter.extractClientCerts(handler.engine(), nettyHttpRequest.getChannel(), threadContext, logger);
        }
    }

    private static void extractClientCerts(SSLEngine sslEngine, Object channel, ThreadContext threadContext, Logger logger) {
        block6: {
            try {
                Certificate[] certs = sslEngine.getSession().getPeerCertificates();
                if (certs instanceof X509Certificate[]) {
                    threadContext.putTransient("__SECURITY_CLIENT_CERTIFICATE", (Object)certs);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                assert (!sslEngine.getNeedClientAuth());
                assert (sslEngine.getWantClientAuth());
                if (logger.isTraceEnabled()) {
                    logger.trace(() -> new ParameterizedMessage("SSL Peer did not present a certificate on channel [{}]", channel), (Throwable)e);
                }
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("SSL Peer did not present a certificate on channel [{}]", channel);
            }
        }
    }
}

