/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.permission.IngestAdminRole;
import org.elasticsearch.xpack.security.authz.permission.KibanaRole;
import org.elasticsearch.xpack.security.authz.permission.KibanaUserRole;
import org.elasticsearch.xpack.security.authz.permission.MonitoringUserRole;
import org.elasticsearch.xpack.security.authz.permission.RemoteMonitoringAgentRole;
import org.elasticsearch.xpack.security.authz.permission.ReportingUserRole;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.permission.SuperuserRole;
import org.elasticsearch.xpack.security.authz.permission.TransportClientRole;
import org.elasticsearch.xpack.security.user.KibanaUser;
import org.elasticsearch.xpack.security.user.User;

public class ReservedRolesStore {
    private static final User DEFAULT_ENABLED_KIBANA_USER = new KibanaUser(true);
    private final SecurityContext securityContext;

    public ReservedRolesStore(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public Role role(String role) {
        switch (role) {
            case "superuser": {
                return SuperuserRole.INSTANCE;
            }
            case "transport_client": {
                return TransportClientRole.INSTANCE;
            }
            case "kibana_user": {
                return KibanaUserRole.INSTANCE;
            }
            case "monitoring_user": {
                return MonitoringUserRole.INSTANCE;
            }
            case "remote_monitoring_agent": {
                return RemoteMonitoringAgentRole.INSTANCE;
            }
            case "ingest_admin": {
                return IngestAdminRole.INSTANCE;
            }
            case "reporting_user": {
                return ReportingUserRole.INSTANCE;
            }
            case "kibana": {
                if (DEFAULT_ENABLED_KIBANA_USER.equals(this.securityContext.getUser())) {
                    return KibanaRole.INSTANCE;
                }
                return null;
            }
        }
        return null;
    }

    public Map<String, Object> usageStats() {
        return Collections.emptyMap();
    }

    public RoleDescriptor roleDescriptor(String role) {
        switch (role) {
            case "superuser": {
                return SuperuserRole.DESCRIPTOR;
            }
            case "transport_client": {
                return TransportClientRole.DESCRIPTOR;
            }
            case "kibana_user": {
                return KibanaUserRole.DESCRIPTOR;
            }
            case "monitoring_user": {
                return MonitoringUserRole.DESCRIPTOR;
            }
            case "remote_monitoring_agent": {
                return RemoteMonitoringAgentRole.DESCRIPTOR;
            }
            case "ingest_admin": {
                return IngestAdminRole.DESCRIPTOR;
            }
            case "reporting_user": {
                return ReportingUserRole.DESCRIPTOR;
            }
            case "kibana": {
                if (DEFAULT_ENABLED_KIBANA_USER.equals(this.securityContext.getUser())) {
                    return KibanaRole.DESCRIPTOR;
                }
                return null;
            }
        }
        return null;
    }

    public Collection<RoleDescriptor> roleDescriptors() {
        if (DEFAULT_ENABLED_KIBANA_USER.equals(this.securityContext.getUser())) {
            return Arrays.asList(SuperuserRole.DESCRIPTOR, TransportClientRole.DESCRIPTOR, KibanaUserRole.DESCRIPTOR, KibanaRole.DESCRIPTOR, MonitoringUserRole.DESCRIPTOR, RemoteMonitoringAgentRole.DESCRIPTOR, IngestAdminRole.DESCRIPTOR, ReportingUserRole.DESCRIPTOR);
        }
        return Arrays.asList(SuperuserRole.DESCRIPTOR, TransportClientRole.DESCRIPTOR, KibanaUserRole.DESCRIPTOR, MonitoringUserRole.DESCRIPTOR, RemoteMonitoringAgentRole.DESCRIPTOR, IngestAdminRole.DESCRIPTOR, ReportingUserRole.DESCRIPTOR);
    }

    public static Set<String> names() {
        return Sets.newHashSet((Object[])new String[]{"superuser", "kibana", "transport_client", "kibana_user", "monitoring_user", "remote_monitoring_agent", "ingest_admin", "reporting_user"});
    }

    public static boolean isReserved(String role) {
        switch (role) {
            case "superuser": 
            case "kibana": 
            case "kibana_user": 
            case "transport_client": 
            case "monitoring_user": 
            case "remote_monitoring_agent": 
            case "_system": 
            case "ingest_admin": 
            case "reporting_user": {
                return true;
            }
        }
        return false;
    }
}

