/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityTemplateService;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.client.SecurityClient;

public class NativeRolesStore
extends AbstractComponent
implements ClusterStateListener {
    private static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting((String)Security.setting("authz.store.roles.index.cache.max_size"), (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)Security.setting("authz.store.roles.index.cache.ttl"), (TimeValue)TimeValue.timeValueMinutes((long)20L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final String ROLE_DOC_TYPE = "role";
    private final InternalClient client;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final boolean isTribeNode;
    private final Cache<String, RoleAndVersion> roleCache;
    private final ReleasableLock readLock;
    private final ReleasableLock writeLock;
    private SecurityClient securityClient;
    private final AtomicLong numInvalidation;
    private volatile boolean securityIndexExists;
    private volatile boolean canWrite;

    public NativeRolesStore(Settings settings, InternalClient client) {
        super(settings);
        ReentrantReadWriteLock iterationLock = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(iterationLock.readLock());
        this.writeLock = new ReleasableLock(iterationLock.writeLock());
        this.numInvalidation = new AtomicLong(0L);
        this.securityIndexExists = false;
        this.canWrite = false;
        this.client = client;
        this.roleCache = CacheBuilder.builder().setMaximumWeight((long)((Integer)CACHE_SIZE_SETTING.get(settings)).intValue()).setExpireAfterWrite((TimeValue)CACHE_TTL_SETTING.get(settings)).build();
        this.isTribeNode = !settings.getGroups("tribe", true).isEmpty();
    }

    public boolean canStart(ClusterState clusterState, boolean master) {
        if (this.state() != State.INITIALIZED) {
            return false;
        }
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("native roles store waiting until gateway has recovered from disk");
            return false;
        }
        if (this.isTribeNode) {
            return true;
        }
        if (SecurityTemplateService.securityIndexMappingAndTemplateUpToDate(clusterState, this.logger)) {
            this.canWrite = true;
        } else if (SecurityTemplateService.securityIndexMappingAndTemplateSufficientToRead(clusterState, this.logger)) {
            this.canWrite = false;
        } else {
            this.canWrite = false;
            return false;
        }
        IndexMetaData metaData = clusterState.metaData().index(".security");
        if (metaData == null) {
            this.logger.debug("security index [{}] does not exist, so service can start", (Object)".security");
            return true;
        }
        if (clusterState.routingTable().index(".security").allPrimaryShardsActive()) {
            this.logger.debug("security index [{}] all primary shards started, so service can start", (Object)".security");
            this.securityIndexExists = true;
            return true;
        }
        return false;
    }

    public void start() {
        try {
            if (this.state.compareAndSet(State.INITIALIZED, State.STARTING)) {
                this.securityClient = new SecurityClient((ElasticsearchClient)this.client);
                this.state.set(State.STARTED);
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start ESNativeRolesStore", (Throwable)e);
            this.state.set(State.FAILED);
        }
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            this.state.set(State.STOPPED);
        }
    }

    public void getRoleDescriptors(String[] names, ActionListener<Collection<RoleDescriptor>> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to get roles before service was started");
            listener.onFailure((Exception)new IllegalStateException("roles cannot be retrieved as native role service has not been started"));
            return;
        }
        if (names != null && names.length == 1) {
            this.getRoleAndVersion(Objects.requireNonNull(names[0]), (ActionListener<RoleAndVersion>)ActionListener.wrap(roleAndVersion -> listener.onResponse(roleAndVersion == null || roleAndVersion.getRoleDescriptor() == null ? Collections.emptyList() : Collections.singletonList(roleAndVersion.getRoleDescriptor())), arg_0 -> listener.onFailure(arg_0)));
        } else {
            try {
                Object query = names == null || names.length == 0 ? QueryBuilders.matchAllQuery() : QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{ROLE_DOC_TYPE}).addIds(names));
                SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setTypes(new String[]{ROLE_DOC_TYPE}).setScroll(TimeValue.timeValueSeconds((long)10L)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                request.indicesOptions().ignoreUnavailable();
                InternalClient.fetchAllByEntity((Client)this.client, request, listener, hit -> NativeRolesStore.transformRole(hit.getId(), hit.getSourceRef(), this.logger));
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("unable to retrieve roles {}", (Object)Arrays.toString(names)), (Throwable)e);
                listener.onFailure(e);
            }
        }
    }

    public void deleteRole(final DeleteRoleRequest deleteRoleRequest, final ActionListener<Boolean> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to delete role [{}] before service was started", (Object)deleteRoleRequest.name());
            listener.onResponse((Object)false);
        } else {
            if (this.isTribeNode) {
                listener.onFailure((Exception)new UnsupportedOperationException("roles may not be deleted using a tribe node"));
                return;
            }
            if (!this.canWrite) {
                listener.onFailure((Exception)new IllegalStateException("role cannot be deleted as service cannot write until template and mappings are up to date"));
                return;
            }
        }
        try {
            DeleteRequest request = (DeleteRequest)this.client.prepareDelete(".security", ROLE_DOC_TYPE, deleteRoleRequest.name()).request();
            request.setRefreshPolicy(deleteRoleRequest.getRefreshPolicy());
            this.client.delete(request, (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    NativeRolesStore.this.clearRoleCache(deleteRoleRequest.name(), listener, deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
                }

                public void onFailure(Exception e) {
                    NativeRolesStore.this.logger.error("failed to delete role from the index", (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
        catch (IndexNotFoundException e) {
            this.logger.trace("security index does not exist", (Throwable)e);
            listener.onResponse((Object)false);
        }
        catch (Exception e) {
            this.logger.error("unable to remove role", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void putRole(final PutRoleRequest request, final RoleDescriptor role, final ActionListener<Boolean> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to put role [{}] before service was started", (Object)request.name());
            listener.onResponse((Object)false);
        } else {
            if (this.isTribeNode) {
                listener.onFailure((Exception)new UnsupportedOperationException("roles may not be created or modified using a tribe node"));
                return;
            }
            if (!this.canWrite) {
                listener.onFailure((Exception)new IllegalStateException("role cannot be created or modified as service cannot write until template and mappings are up to date"));
                return;
            }
        }
        try {
            ((IndexRequestBuilder)this.client.prepareIndex(".security", ROLE_DOC_TYPE, role.getName()).setSource(role.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setRefreshPolicy(request.getRefreshPolicy())).execute((ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    NativeRolesStore.this.clearRoleCache(role.getName(), listener, created);
                }

                public void onFailure(Exception e) {
                    NativeRolesStore.this.logger.error(() -> new ParameterizedMessage("failed to put role [{}]", (Object)request.name()), (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unable to put role [{}]", (Object)request.name()), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void role(String roleName, final ActionListener<Role> listener) {
        if (this.state() != State.STARTED) {
            listener.onResponse(null);
        } else {
            this.getRoleAndVersion(roleName, new ActionListener<RoleAndVersion>(){

                public void onResponse(RoleAndVersion roleAndVersion) {
                    listener.onResponse((Object)(roleAndVersion == null ? null : roleAndVersion.getRole()));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    public Map<String, Object> usageStats() {
        if (this.state() != State.STARTED) {
            return Collections.emptyMap();
        }
        boolean dls = false;
        boolean fls = false;
        HashMap<String, Object> usageStats = new HashMap<String, Object>();
        if (!this.securityIndexExists) {
            usageStats.put("size", 0L);
            usageStats.put("fls", fls);
            usageStats.put("dls", dls);
            return usageStats;
        }
        long count = 0L;
        try (ReleasableLock ignored = this.writeLock.acquire();){
            for (RoleAndVersion rv : this.roleCache.values()) {
                if (rv == RoleAndVersion.NON_EXISTENT) continue;
                ++count;
                Role role = rv.getRole();
                for (IndicesPermission.Group group : role.indices()) {
                    fls = fls || group.getFieldPermissions().hasFieldLevelSecurity();
                    dls = dls || group.hasQuery();
                }
            }
        }
        if (!fls || !dls) {
            MultiSearchRequestBuilder builder = this.client.prepareMultiSearch().add(this.client.prepareSearch(new String[]{".security"}).setTypes(new String[]{ROLE_DOC_TYPE}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(0));
            if (!fls) {
                builder.add(this.client.prepareSearch(new String[]{".security"}).setTypes(new String[]{ROLE_DOC_TYPE}).setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.field_security.grant")).should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.field_security.except")).should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.fields"))).setSize(0).setTerminateAfter(1));
            }
            if (!dls) {
                builder.add(this.client.prepareSearch(new String[]{".security"}).setTypes(new String[]{ROLE_DOC_TYPE}).setQuery((QueryBuilder)QueryBuilders.existsQuery((String)"indices.query")).setSize(0).setTerminateAfter(1));
            }
            MultiSearchResponse multiSearchResponse = (MultiSearchResponse)builder.get();
            int pos = 0;
            MultiSearchResponse.Item[] responses = multiSearchResponse.getResponses();
            if (!responses[pos].isFailure()) {
                count = responses[pos].getResponse().getHits().getTotalHits();
            }
            if (!fls && !responses[++pos].isFailure()) {
                boolean bl = fls = responses[pos].getResponse().getHits().getTotalHits() > 0L;
            }
            if (!dls && !responses[++pos].isFailure()) {
                dls = responses[pos].getResponse().getHits().getTotalHits() > 0L;
            }
        }
        usageStats.put("size", count);
        usageStats.put("fls", fls);
        usageStats.put("dls", dls);
        return usageStats;
    }

    private void getRoleAndVersion(final String roleId, final ActionListener<RoleAndVersion> roleActionListener) {
        if (!this.securityIndexExists) {
            roleActionListener.onResponse(null);
        } else {
            RoleAndVersion cachedRoleAndVersion = (RoleAndVersion)this.roleCache.get((Object)roleId);
            if (cachedRoleAndVersion == null) {
                final long invalidationCounter = this.numInvalidation.get();
                this.executeGetRoleRequest(roleId, new ActionListener<GetResponse>(){

                    public void onResponse(GetResponse response) {
                        RoleAndVersion roleAndVersion;
                        RoleDescriptor descriptor = NativeRolesStore.this.transformRole(response);
                        if (descriptor != null) {
                            NativeRolesStore.this.logger.debug("loaded role [{}] from index with version [{}]", (Object)roleId, (Object)response.getVersion());
                            roleAndVersion = new RoleAndVersion(descriptor, response.getVersion());
                        } else {
                            roleAndVersion = RoleAndVersion.NON_EXISTENT;
                        }
                        try (ReleasableLock ignored = NativeRolesStore.this.readLock.acquire();){
                            if (invalidationCounter == NativeRolesStore.this.numInvalidation.get()) {
                                NativeRolesStore.this.roleCache.computeIfAbsent((Object)roleId, k -> roleAndVersion);
                            }
                        }
                        catch (ExecutionException e) {
                            throw new AssertionError("failed to load constant non-null value", e);
                        }
                        roleActionListener.onResponse((Object)roleAndVersion);
                    }

                    public void onFailure(Exception e) {
                        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                            NativeRolesStore.this.logger.warn(() -> new ParameterizedMessage("failed to load role [{}] index not available", (Object)roleId), (Throwable)e);
                            roleActionListener.onResponse((Object)RoleAndVersion.NON_EXISTENT);
                        } else {
                            NativeRolesStore.this.logger.error(() -> new ParameterizedMessage("failed to load role [{}]", (Object)roleId), (Throwable)e);
                            roleActionListener.onFailure(e);
                        }
                    }
                });
            } else {
                roleActionListener.onResponse((Object)cachedRoleAndVersion);
            }
        }
    }

    void executeGetRoleRequest(String role, ActionListener<GetResponse> listener) {
        try {
            GetRequest request = (GetRequest)this.client.prepareGet(".security", ROLE_DOC_TYPE, role).request();
            this.client.get(request, (ActionListener)new ThreadedActionListener(this.logger, this.client.threadPool(), "listener", listener, true));
        }
        catch (IndexNotFoundException e) {
            this.logger.trace(() -> new ParameterizedMessage("unable to retrieve role [{}] since security index does not exist", (Object)role), (Throwable)e);
            listener.onResponse((Object)new GetResponse(new GetResult(".security", ROLE_DOC_TYPE, role, -1L, false, null, null)));
        }
        catch (Exception e) {
            this.logger.error("unable to retrieve role", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void reset() {
        State state = this.state();
        if (state != State.STOPPED && state != State.FAILED) {
            throw new IllegalStateException("can only reset if stopped!!!");
        }
        this.invalidateAll();
        this.securityIndexExists = false;
        this.canWrite = false;
        this.state.set(State.INITIALIZED);
    }

    public void invalidateAll() {
        this.logger.debug("invalidating all roles in cache");
        this.numInvalidation.incrementAndGet();
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.roleCache.invalidateAll();
        }
    }

    public void invalidate(String role) {
        this.logger.debug("invalidating role [{}] in cache", (Object)role);
        this.numInvalidation.incrementAndGet();
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.roleCache.invalidate((Object)role);
        }
    }

    private <Response> void clearRoleCache(final String role, final ActionListener<Response> listener, final Response response) {
        ClearRolesCacheRequest request = new ClearRolesCacheRequest().names(role);
        this.securityClient.clearRolesCache(request, new ActionListener<ClearRolesCacheResponse>(){

            public void onResponse(ClearRolesCacheResponse nodes) {
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                NativeRolesStore.this.logger.error(() -> new ParameterizedMessage("unable to clear cache for role [{}]", (Object)role), (Throwable)e);
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + role + "] failed. please clear the role cache manually", (Throwable)e, new Object[0]);
                listener.onFailure((Exception)((Object)exception));
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        this.securityIndexExists = event.state().metaData().indices().get((Object)".security") != null;
        this.canWrite = SecurityTemplateService.securityIndexMappingAndTemplateUpToDate(event.state(), this.logger);
    }

    public State state() {
        return this.state.get();
    }

    @Nullable
    private RoleDescriptor transformRole(GetResponse response) {
        if (!response.isExists()) {
            return null;
        }
        return NativeRolesStore.transformRole(response.getId(), response.getSourceAsBytesRef(), this.logger);
    }

    @Nullable
    static RoleDescriptor transformRole(String name, BytesReference sourceBytes, Logger logger) {
        try {
            return RoleDescriptor.parse(name, sourceBytes, true);
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("error in the format of data for role [{}]", (Object)name), (Throwable)e);
            return null;
        }
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(CACHE_SIZE_SETTING);
        settings.add(CACHE_TTL_SETTING);
    }

    private static class RoleAndVersion {
        private static final RoleAndVersion NON_EXISTENT = new RoleAndVersion();
        private final RoleDescriptor roleDescriptor;
        private final Role role;
        private final long version;

        private RoleAndVersion() {
            this.roleDescriptor = null;
            this.role = null;
            this.version = Long.MIN_VALUE;
        }

        RoleAndVersion(RoleDescriptor roleDescriptor, long version) {
            this.roleDescriptor = roleDescriptor;
            this.role = Role.builder(roleDescriptor).build();
            this.version = version;
        }

        RoleDescriptor getRoleDescriptor() {
            return this.roleDescriptor;
        }

        Role getRole() {
            return this.role;
        }

        long getVersion() {
            return this.version;
        }
    }

    public static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED;

    }
}

