/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.support.RefreshListener;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.security.support.NoOpLogger;
import org.elasticsearch.xpack.security.support.Validation;

public class FileRolesStore
extends AbstractLifecycleComponent {
    private static final Pattern IN_SEGMENT_LINE = Pattern.compile("^\\s+.+");
    private static final Pattern SKIP_LINE = Pattern.compile("(^#.*|^\\s*)");
    private final Path file;
    private final RefreshListener listener;
    private final ResourceWatcherService watcherService;
    private volatile Map<String, Role> permissions;

    public FileRolesStore(Settings settings, Environment env, ResourceWatcherService watcherService) {
        this(settings, env, watcherService, RefreshListener.NOOP);
    }

    public FileRolesStore(Settings settings, Environment env, ResourceWatcherService watcherService, RefreshListener listener) {
        super(settings);
        this.file = FileRolesStore.resolveFile(env);
        this.listener = listener;
        this.watcherService = watcherService;
        this.permissions = Collections.emptyMap();
    }

    protected void doStart() throws ElasticsearchException {
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            this.watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to setup roles file watcher", (Throwable)e, new Object[0]);
        }
        this.permissions = FileRolesStore.parseFile(this.file, this.logger, this.settings);
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    public Role role(String role) {
        return this.permissions.get(role);
    }

    public Map<String, Object> usageStats() {
        HashMap<String, Object> usageStats = new HashMap<String, Object>();
        usageStats.put("size", this.permissions.size());
        boolean dls = false;
        boolean fls = false;
        for (Role role : this.permissions.values()) {
            for (IndicesPermission.Group group : role.indices()) {
                fls = fls || group.getFieldPermissions().hasFieldLevelSecurity();
                dls = dls || group.hasQuery();
            }
            if (!fls || !dls) continue;
            break;
        }
        usageStats.put("fls", fls);
        usageStats.put("dls", dls);
        return usageStats;
    }

    public static Path resolveFile(Environment env) {
        return XPackPlugin.resolveConfigFile(env, "roles.yml");
    }

    public static Set<String> parseFileForRoleNames(Path path, Logger logger) {
        Map<String, Role> roleMap = FileRolesStore.parseFile(path, logger, false, Settings.EMPTY);
        if (roleMap == null) {
            return Collections.emptySet();
        }
        return roleMap.keySet();
    }

    public static Map<String, Role> parseFile(Path path, Logger logger, Settings settings) {
        return FileRolesStore.parseFile(path, logger, true, settings);
    }

    public static Map<String, Role> parseFile(Path path, Logger logger, boolean resolvePermission, Settings settings) {
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        HashMap<String, Role> roles = new HashMap<String, Role>();
        logger.debug("attempting to read roles file located at [{}]", (Object)path.toAbsolutePath());
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> roleSegments = FileRolesStore.roleSegments(path);
                for (String segment : roleSegments) {
                    Role role = FileRolesStore.parseRole(segment, path, logger, resolvePermission, settings);
                    if (role == null) continue;
                    if (ReservedRolesStore.isReserved(role.name())) {
                        logger.warn("role [{}] is reserved. the relevant role definition in the mapping file will be ignored", (Object)role.name());
                        continue;
                    }
                    roles.put(role.name(), role);
                }
            }
            catch (IOException ioe) {
                logger.error(() -> new ParameterizedMessage("failed to read roles file [{}]. skipping all roles...", (Object)path.toAbsolutePath()), (Throwable)ioe);
                return Collections.emptyMap();
            }
        } else {
            logger.debug("roles file does not exist");
            return Collections.emptyMap();
        }
        logger.debug("parsed [{}] roles from file [{}]", (Object)roles.size(), (Object)path.toAbsolutePath());
        return Collections.unmodifiableMap(roles);
    }

    public static Map<String, RoleDescriptor> parseRoleDescriptors(Path path, Logger logger, boolean resolvePermission, Settings settings) {
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        HashMap<String, RoleDescriptor> roles = new HashMap<String, RoleDescriptor>();
        logger.trace("attempting to read roles file located at [{}]", (Object)path.toAbsolutePath());
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> roleSegments = FileRolesStore.roleSegments(path);
                for (String segment : roleSegments) {
                    RoleDescriptor rd = FileRolesStore.parseRoleDescriptor(segment, path, logger, resolvePermission, settings);
                    if (rd == null) continue;
                    roles.put(rd.getName(), rd);
                }
            }
            catch (IOException ioe) {
                logger.error(() -> new ParameterizedMessage("failed to read roles file [{}]. skipping all roles...", (Object)path.toAbsolutePath()), (Throwable)ioe);
                return Collections.emptyMap();
            }
        }
        return Collections.unmodifiableMap(roles);
    }

    @Nullable
    private static Role parseRole(String segment, Path path, Logger logger, boolean resolvePermissions, Settings settings) {
        RoleDescriptor descriptor = FileRolesStore.parseRoleDescriptor(segment, path, logger, resolvePermissions, settings);
        if (descriptor != null) {
            String roleName = descriptor.getName();
            for (RoleDescriptor.IndicesPrivileges privilege : descriptor.getIndicesPrivileges()) {
                if (privilege.getQuery() == null && !privilege.getFieldPermissions().hasFieldLevelSecurity() || ((Boolean)XPackSettings.DLS_FLS_ENABLED.get(settings)).booleanValue()) continue;
                logger.error("invalid role definition [{}] in roles file [{}]. document and field level security is not enabled. set [{}] to [true] in the configuration file. skipping role...", (Object)roleName, (Object)path.toAbsolutePath(), (Object)XPackSettings.DLS_FLS_ENABLED.getKey());
                return null;
            }
            return Role.builder(descriptor).build();
        }
        return null;
    }

    @Nullable
    static RoleDescriptor parseRoleDescriptor(String segment, Path path, Logger logger, boolean resolvePermissions, Settings settings) {
        String roleName = null;
        try {
            XContentParser parser = YamlXContent.yamlXContent.createParser(segment);
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                roleName = parser.currentName();
                Validation.Error validationError = Validation.Roles.validateRoleName(roleName);
                if (validationError != null) {
                    logger.error("invalid role definition [{}] in roles file [{}]. invalid role name - {}. skipping role... ", (Object)roleName, (Object)path.toAbsolutePath(), (Object)validationError);
                    return null;
                }
                if (!resolvePermissions) {
                    return new RoleDescriptor(roleName, null, null, null);
                }
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    RoleDescriptor descriptor = RoleDescriptor.parse(roleName, parser, true);
                    return descriptor;
                }
                logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", (Object)roleName, (Object)path.toAbsolutePath());
                return null;
            }
            logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", roleName, (Object)path.toAbsolutePath());
        }
        catch (ElasticsearchParseException e) {
            assert (roleName != null);
            if (logger.isDebugEnabled()) {
                String finalRoleName = roleName;
                logger.debug(() -> new ParameterizedMessage("parsing exception for role [{}]", (Object)finalRoleName), (Throwable)e);
            } else {
                logger.error(e.getMessage() + ". skipping role...");
            }
        }
        catch (IOException e) {
            if (roleName != null) {
                String finalRoleName = roleName;
                logger.error(() -> new ParameterizedMessage("invalid role definition [{}] in roles file [{}]. skipping role...", (Object)finalRoleName, (Object)path), (Throwable)e);
            }
            logger.error(() -> new ParameterizedMessage("invalid role definition in roles file [{}]. skipping role...", (Object)path), (Throwable)e);
        }
        return null;
    }

    private static List<String> roleSegments(Path path) throws IOException {
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder builder = null;
        for (String line : Files.readAllLines(path, StandardCharsets.UTF_8)) {
            if (SKIP_LINE.matcher(line).matches()) continue;
            if (IN_SEGMENT_LINE.matcher(line).matches()) {
                if (builder == null) continue;
                builder.append(line).append("\n");
                continue;
            }
            if (builder != null) {
                segments.add(builder.toString());
            }
            builder = new StringBuilder(line).append("\n");
        }
        if (builder != null) {
            segments.add(builder.toString());
        }
        return segments;
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileRolesStore.this.file)) {
                try {
                    FileRolesStore.this.permissions = FileRolesStore.parseFile(file, FileRolesStore.this.logger, FileRolesStore.this.settings);
                    FileRolesStore.this.logger.info("updated roles (roles file [{}] changed)", (Object)file.toAbsolutePath());
                }
                catch (Exception e) {
                    FileRolesStore.this.logger.error(() -> new ParameterizedMessage("could not reload roles file [{}]. Current roles remain unmodified", (Object)file.toAbsolutePath()), (Throwable)e);
                    return;
                }
                FileRolesStore.this.listener.onRefresh();
            }
        }
    }
}

