/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.authz.store.ReservedRolesStore;

public class CompositeRolesStore
extends AbstractComponent {
    private final FileRolesStore fileRolesStore;
    private final NativeRolesStore nativeRolesStore;
    private final ReservedRolesStore reservedRolesStore;

    public CompositeRolesStore(Settings settings, FileRolesStore fileRolesStore, NativeRolesStore nativeRolesStore, ReservedRolesStore reservedRolesStore) {
        super(settings);
        this.fileRolesStore = fileRolesStore;
        this.nativeRolesStore = nativeRolesStore;
        this.reservedRolesStore = reservedRolesStore;
    }

    private Role getBuildInRole(String role) {
        Role builtIn = this.reservedRolesStore.role(role);
        if (builtIn != null) {
            this.logger.trace("loaded role [{}] from reserved roles store", (Object)role);
            return builtIn;
        }
        Role fileRole = this.fileRolesStore.role(role);
        if (fileRole != null) {
            this.logger.trace("loaded role [{}] from file roles store", (Object)role);
            return fileRole;
        }
        return null;
    }

    public void roles(String role, ActionListener<Role> roleActionListener) {
        Role storedRole = this.getBuildInRole(role);
        if (storedRole == null) {
            this.nativeRolesStore.role(role, roleActionListener);
        } else {
            roleActionListener.onResponse((Object)storedRole);
        }
    }

    public Map<String, Object> usageStats() {
        HashMap<String, Object> usage = new HashMap<String, Object>(2);
        usage.put("file", this.fileRolesStore.usageStats());
        usage.put("native", this.nativeRolesStore.usageStats());
        return usage;
    }
}

