/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.privilege;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;

public abstract class Privilege<P extends Privilege<P>> {
    protected final Name name;

    Privilege(Name name) {
        this.name = name;
    }

    public Name name() {
        return this.name;
    }

    public abstract Predicate<String> predicate();

    public abstract boolean implies(P var1);

    public boolean isAlias(P other) {
        return this.implies(other) && other.implies((Privilege)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return !(this.name != null ? !this.name.equals(privilege.name) : privilege.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    static String actionToPattern(String text) {
        return text + "*";
    }

    public static class Name {
        public static final Name NONE = new Name("none");
        public static final Name ALL = new Name("all");
        final Set<String> parts;

        public Name(String name) {
            assert (name != null && !name.contains(","));
            this.parts = Collections.singleton(name);
        }

        public Name(Set<String> parts) {
            assert (!parts.isEmpty());
            this.parts = Collections.unmodifiableSet(new HashSet<String>(parts));
        }

        public Name(String ... parts) {
            this(Collections.unmodifiableSet(Sets.newHashSet((Object[])parts)));
        }

        public String toString() {
            return Strings.collectionToCommaDelimitedString(this.parts);
        }

        public Name add(Name other) {
            return new Name(Sets.union(this.parts, other.parts));
        }

        public Name remove(Name other) {
            Set parts = Sets.difference(this.parts, other.parts);
            return parts.isEmpty() ? NONE : new Name(parts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name name = (Name)o;
            return this.parts.equals(name.parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }
    }
}

