/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.privilege;

import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.security.authz.privilege.AbstractAutomatonPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.security.support.Automatons;

public class IndexPrivilege
extends AbstractAutomatonPrivilege<IndexPrivilege> {
    private static final Automaton ALL_AUTOMATON = Automatons.patterns("indices:*");
    private static final Automaton READ_AUTOMATON = Automatons.patterns("indices:data/read/*");
    private static final Automaton CREATE_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:admin/mapping/put");
    private static final Automaton INDEX_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:data/write/update*", "indices:admin/mapping/put");
    private static final Automaton DELETE_AUTOMATON = Automatons.patterns("indices:data/write/delete*");
    private static final Automaton WRITE_AUTOMATON = Automatons.patterns("indices:data/write/*", "indices:admin/mapping/put");
    private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("indices:monitor/*");
    private static final Automaton MANAGE_AUTOMATON = Automatons.unionAndDeterminize(MONITOR_AUTOMATON, Automatons.patterns("indices:admin/*"));
    private static final Automaton CREATE_INDEX_AUTOMATON = Automatons.patterns("indices:admin/create");
    private static final Automaton DELETE_INDEX_AUTOMATON = Automatons.patterns("indices:admin/delete");
    private static final Automaton VIEW_METADATA_AUTOMATON = Automatons.patterns("indices:admin/aliases/get", "indices:admin/aliases/exists", "indices:admin/get", "indices:admin/exists", "indices:admin/mappings/fields/get*", "indices:admin/mappings/get", "indices:admin/shards/search_shards", "indices:admin/types/exists", "indices:admin/validate/query*", "indices:monitor/settings/get");
    public static final IndexPrivilege NONE = new IndexPrivilege(Privilege.Name.NONE, Automatons.EMPTY);
    public static final IndexPrivilege ALL = new IndexPrivilege(Privilege.Name.ALL, ALL_AUTOMATON);
    public static final IndexPrivilege READ = new IndexPrivilege("read", READ_AUTOMATON);
    public static final IndexPrivilege CREATE = new IndexPrivilege("create", CREATE_AUTOMATON);
    public static final IndexPrivilege INDEX = new IndexPrivilege("index", INDEX_AUTOMATON);
    public static final IndexPrivilege DELETE = new IndexPrivilege("delete", DELETE_AUTOMATON);
    public static final IndexPrivilege WRITE = new IndexPrivilege("write", WRITE_AUTOMATON);
    public static final IndexPrivilege MONITOR = new IndexPrivilege("monitor", MONITOR_AUTOMATON);
    public static final IndexPrivilege MANAGE = new IndexPrivilege("manage", MANAGE_AUTOMATON);
    public static final IndexPrivilege DELETE_INDEX = new IndexPrivilege("delete_index", DELETE_INDEX_AUTOMATON);
    public static final IndexPrivilege CREATE_INDEX = new IndexPrivilege("create_index", CREATE_INDEX_AUTOMATON);
    public static final IndexPrivilege VIEW_METADATA = new IndexPrivilege("view_index_metadata", VIEW_METADATA_AUTOMATON);
    private static final Set<IndexPrivilege> values = new CopyOnWriteArraySet<IndexPrivilege>();
    public static final Predicate<String> ACTION_MATCHER;
    public static final Predicate<String> CREATE_INDEX_MATCHER;
    private static final ConcurrentHashMap<Privilege.Name, IndexPrivilege> cache;

    static Set<IndexPrivilege> values() {
        return values;
    }

    private IndexPrivilege(String name, String ... patterns) {
        super(name, patterns);
    }

    private IndexPrivilege(String name, Automaton automaton) {
        super(new Privilege.Name(name), automaton);
    }

    private IndexPrivilege(Privilege.Name name, Automaton automaton) {
        super(name, automaton);
    }

    public static void addCustom(String name, String ... actionPatterns) {
        for (String pattern : actionPatterns) {
            if (ACTION_MATCHER.test(pattern)) continue;
            throw new IllegalArgumentException("cannot register custom index privilege [" + name + "]. index action must follow the 'indices:*' format");
        }
        IndexPrivilege custom = new IndexPrivilege(name, actionPatterns);
        if (values.contains(custom)) {
            throw new IllegalArgumentException("cannot register custom index privilege [" + name + "] as it already exists.");
        }
        values.add(custom);
    }

    @Override
    protected IndexPrivilege create(Privilege.Name name, Automaton automaton) {
        if (name == Privilege.Name.NONE) {
            return NONE;
        }
        return new IndexPrivilege(name, automaton);
    }

    @Override
    protected IndexPrivilege none() {
        return NONE;
    }

    public static IndexPrivilege action(String action) {
        return new IndexPrivilege(action, IndexPrivilege.actionToPattern(action));
    }

    public static IndexPrivilege get(Privilege.Name name) {
        return cache.computeIfAbsent(name, theName -> {
            IndexPrivilege index = NONE;
            for (String part : theName.parts) {
                index = index == NONE ? IndexPrivilege.resolve(part) : index.plus(IndexPrivilege.resolve(part));
            }
            return index;
        });
    }

    public static IndexPrivilege union(IndexPrivilege ... indices) {
        IndexPrivilege result = NONE;
        for (IndexPrivilege index : indices) {
            result = result.plus(index);
        }
        return result;
    }

    private static IndexPrivilege resolve(String name) {
        if (ACTION_MATCHER.test(name = name.toLowerCase(Locale.ROOT))) {
            return IndexPrivilege.action(name);
        }
        for (IndexPrivilege index : values) {
            if (!name.toLowerCase(Locale.ROOT).equals(index.name.toString())) continue;
            return index;
        }
        throw new IllegalArgumentException("unknown index privilege [" + name + "]. a privilege must be either one of the predefined fixed indices privileges [" + Strings.collectionToCommaDelimitedString(values) + "] or a pattern over one of the available index actions");
    }

    static {
        values.add(NONE);
        values.add(ALL);
        values.add(MANAGE);
        values.add(CREATE_INDEX);
        values.add(MONITOR);
        values.add(READ);
        values.add(INDEX);
        values.add(DELETE);
        values.add(WRITE);
        values.add(CREATE);
        values.add(DELETE_INDEX);
        values.add(VIEW_METADATA);
        ACTION_MATCHER = ALL.predicate();
        CREATE_INDEX_MATCHER = CREATE_INDEX.predicate();
        cache = new ConcurrentHashMap();
    }
}

