/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.privilege;

import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.security.authz.privilege.AbstractAutomatonPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.security.support.Automatons;

public class ClusterPrivilege
extends AbstractAutomatonPrivilege<ClusterPrivilege> {
    private static final Automaton MANAGE_SECURITY_AUTOMATON = Automatons.patterns("cluster:admin/xpack/security/*");
    private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("cluster:monitor/*");
    private static final Automaton ALL_CLUSTER_AUTOMATON = Automatons.patterns("cluster:*", "indices:admin/template/*");
    private static final Automaton MANAGE_AUTOMATON = Automatons.minusAndDeterminize(ALL_CLUSTER_AUTOMATON, MANAGE_SECURITY_AUTOMATON);
    private static final Automaton TRANSPORT_CLIENT_AUTOMATON = Automatons.patterns("cluster:monitor/nodes/liveness", "cluster:monitor/state");
    private static final Automaton MANAGE_IDX_TEMPLATE_AUTOMATON = Automatons.patterns("indices:admin/template/*");
    private static final Automaton MANAGE_INGEST_PIPELINE_AUTOMATON = Automatons.patterns("cluster:admin/ingest/pipeline/*");
    public static final ClusterPrivilege NONE = new ClusterPrivilege(Privilege.Name.NONE, Automatons.EMPTY);
    public static final ClusterPrivilege ALL = new ClusterPrivilege(Privilege.Name.ALL, ALL_CLUSTER_AUTOMATON);
    public static final ClusterPrivilege MONITOR = new ClusterPrivilege("monitor", MONITOR_AUTOMATON);
    public static final ClusterPrivilege MANAGE = new ClusterPrivilege("manage", MANAGE_AUTOMATON);
    public static final ClusterPrivilege MANAGE_IDX_TEMPLATES = new ClusterPrivilege("manage_index_templates", MANAGE_IDX_TEMPLATE_AUTOMATON);
    public static final ClusterPrivilege MANAGE_INGEST_PIPELINES = new ClusterPrivilege("manage_ingest_pipelines", MANAGE_INGEST_PIPELINE_AUTOMATON);
    public static final ClusterPrivilege TRANSPORT_CLIENT = new ClusterPrivilege("transport_client", TRANSPORT_CLIENT_AUTOMATON);
    public static final ClusterPrivilege MANAGE_SECURITY = new ClusterPrivilege("manage_security", MANAGE_SECURITY_AUTOMATON);
    public static final ClusterPrivilege MANAGE_PIPELINE = new ClusterPrivilege("manage_pipeline", "cluster:admin/ingest/pipeline/*");
    public static final Predicate<String> ACTION_MATCHER = ALL.predicate();
    private static final Set<ClusterPrivilege> values = new CopyOnWriteArraySet<ClusterPrivilege>();
    private static final ConcurrentHashMap<Privilege.Name, ClusterPrivilege> cache;

    static Set<ClusterPrivilege> values() {
        return values;
    }

    private ClusterPrivilege(String name, String ... patterns) {
        super(name, patterns);
    }

    private ClusterPrivilege(String name, Automaton automaton) {
        super(new Privilege.Name(name), automaton);
    }

    private ClusterPrivilege(Privilege.Name name, Automaton automaton) {
        super(name, automaton);
    }

    public static void addCustom(String name, String ... actionPatterns) {
        for (String pattern : actionPatterns) {
            if (ACTION_MATCHER.test(pattern)) continue;
            throw new IllegalArgumentException("cannot register custom cluster privilege [" + name + "]. cluster action must follow the 'cluster:*' format");
        }
        ClusterPrivilege custom = new ClusterPrivilege(name, actionPatterns);
        if (values.contains(custom)) {
            throw new IllegalArgumentException("cannot register custom cluster privilege [" + name + "] as it already exists.");
        }
        values.add(custom);
    }

    @Override
    protected ClusterPrivilege create(Privilege.Name name, Automaton automaton) {
        return new ClusterPrivilege(name, automaton);
    }

    @Override
    protected ClusterPrivilege none() {
        return NONE;
    }

    public static ClusterPrivilege action(String action) {
        String pattern = ClusterPrivilege.actionToPattern(action);
        return new ClusterPrivilege(action, pattern);
    }

    public static ClusterPrivilege get(Privilege.Name name) {
        return cache.computeIfAbsent(name, theName -> {
            ClusterPrivilege cluster = NONE;
            for (String part : theName.parts) {
                cluster = cluster == NONE ? ClusterPrivilege.resolve(part) : cluster.plus(ClusterPrivilege.resolve(part));
            }
            return cluster;
        });
    }

    private static ClusterPrivilege resolve(String name) {
        if (ACTION_MATCHER.test(name = name.toLowerCase(Locale.ROOT))) {
            return ClusterPrivilege.action(name);
        }
        for (ClusterPrivilege cluster : values) {
            if (!name.equals(cluster.name.toString())) continue;
            return cluster;
        }
        throw new IllegalArgumentException("unknown cluster privilege [" + name + "]. a privilege must be either one of the predefined fixed cluster privileges [" + Strings.collectionToCommaDelimitedString(values) + "] or a pattern over one of the available cluster actions");
    }

    static {
        values.add(NONE);
        values.add(ALL);
        values.add(MONITOR);
        values.add(MANAGE);
        values.add(MANAGE_IDX_TEMPLATES);
        values.add(MANAGE_INGEST_PIPELINES);
        values.add(TRANSPORT_CLIENT);
        values.add(MANAGE_SECURITY);
        values.add(MANAGE_PIPELINE);
        cache = new ConcurrentHashMap();
    }
}

