/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.privilege;

import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.xpack.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.security.support.AutomatonPredicate;
import org.elasticsearch.xpack.security.support.Automatons;

abstract class AbstractAutomatonPrivilege<P extends AbstractAutomatonPrivilege<P>>
extends Privilege<P> {
    protected final Automaton automaton;

    AbstractAutomatonPrivilege(String name, String ... patterns) {
        super(new Privilege.Name(name));
        this.automaton = Automatons.patterns(patterns);
    }

    AbstractAutomatonPrivilege(Privilege.Name name, String ... patterns) {
        super(name);
        this.automaton = Automatons.patterns(patterns);
    }

    AbstractAutomatonPrivilege(Privilege.Name name, Automaton automaton) {
        super(name);
        this.automaton = automaton;
    }

    @Override
    public Predicate<String> predicate() {
        return new AutomatonPredicate(this.automaton);
    }

    protected P plus(P other) {
        if (other.implies((P)this)) {
            return (P)other;
        }
        if (this.implies((P)other)) {
            return (P)this;
        }
        return this.create(this.name.add(other.name), Automatons.unionAndDeterminize(this.automaton, other.automaton));
    }

    @Override
    public boolean implies(P other) {
        return Operations.subsetOf((Automaton)((AbstractAutomatonPrivilege)other).automaton, (Automaton)this.automaton);
    }

    public String toString() {
        return this.name.toString();
    }

    protected abstract P create(Privilege.Name var1, Automaton var2);

    protected abstract P none();
}

