/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.xpack.security.authz.permission.GlobalPermission;
import org.elasticsearch.xpack.security.authz.permission.Permission;
import org.elasticsearch.xpack.security.authz.privilege.GeneralPrivilege;

public interface RunAsPermission
extends Permission {
    public boolean check(String var1);

    public static class Globals
    implements RunAsPermission {
        private final List<GlobalPermission> globals;

        public Globals(List<GlobalPermission> globals) {
            this.globals = globals;
        }

        @Override
        public boolean check(String username) {
            if (this.globals == null) {
                return false;
            }
            for (GlobalPermission global : this.globals) {
                if (!global.runAs().check(username)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            if (this.globals == null || this.globals.isEmpty()) {
                return true;
            }
            for (GlobalPermission global : this.globals) {
                if (global.isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    public static class Core
    implements RunAsPermission {
        public static final Core NONE = new Core(GeneralPrivilege.NONE);
        private final GeneralPrivilege privilege;
        private final Predicate<String> predicate;

        public Core(GeneralPrivilege privilege) {
            this.privilege = privilege;
            this.predicate = privilege.predicate();
        }

        @Override
        public boolean check(String username) {
            return this.predicate.test(username);
        }

        @Override
        public boolean isEmpty() {
            return this == NONE;
        }
    }
}

