/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.security.authz.permission.GlobalPermission;
import org.elasticsearch.xpack.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.GeneralPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.Privilege;

public class Role
extends GlobalPermission {
    private final String name;

    Role(String name, ClusterPermission.Core cluster, IndicesPermission.Core indices, RunAsPermission.Core runAs) {
        super(cluster, indices, runAs);
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public ClusterPermission.Core cluster() {
        return (ClusterPermission.Core)super.cluster();
    }

    @Override
    public IndicesPermission.Core indices() {
        return (IndicesPermission.Core)super.indices();
    }

    @Override
    public RunAsPermission.Core runAs() {
        return (RunAsPermission.Core)super.runAs();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(RoleDescriptor rd) {
        return new Builder(rd);
    }

    public static class Builder {
        private final String name;
        private ClusterPermission.Core cluster = ClusterPermission.Core.NONE;
        private RunAsPermission.Core runAs = RunAsPermission.Core.NONE;
        private List<IndicesPermission.Group> groups = new ArrayList<IndicesPermission.Group>();

        private Builder(String name) {
            this.name = name;
        }

        private Builder(RoleDescriptor rd) {
            this.name = rd.getName();
            if (rd.getClusterPrivileges().length == 0) {
                this.cluster = ClusterPermission.Core.NONE;
            } else {
                this.cluster(ClusterPrivilege.get(new Privilege.Name(rd.getClusterPrivileges())));
            }
            this.groups.addAll(Builder.convertFromIndicesPrivileges(rd.getIndicesPrivileges()));
            String[] rdRunAs = rd.getRunAs();
            if (rdRunAs != null && rdRunAs.length > 0) {
                this.runAs(new GeneralPrivilege(new Privilege.Name(rdRunAs), rdRunAs));
            }
        }

        public Builder cluster(ClusterPrivilege privilege) {
            this.cluster = new ClusterPermission.Core(privilege);
            return this;
        }

        public Builder runAs(GeneralPrivilege privilege) {
            this.runAs = new RunAsPermission.Core(privilege);
            return this;
        }

        public Builder add(IndexPrivilege privilege, String ... indices) {
            this.groups.add(new IndicesPermission.Group(privilege, new FieldPermissions(), null, indices));
            return this;
        }

        public Builder add(FieldPermissions fieldPermissions, BytesReference query, IndexPrivilege privilege, String ... indices) {
            this.groups.add(new IndicesPermission.Group(privilege, fieldPermissions, query, indices));
            return this;
        }

        public Role build() {
            IndicesPermission.Core indices = this.groups.isEmpty() ? IndicesPermission.Core.NONE : new IndicesPermission.Core(this.groups.toArray(new IndicesPermission.Group[this.groups.size()]));
            return new Role(this.name, this.cluster, indices, this.runAs);
        }

        static List<IndicesPermission.Group> convertFromIndicesPrivileges(RoleDescriptor.IndicesPrivileges[] indicesPrivileges) {
            ArrayList<IndicesPermission.Group> list = new ArrayList<IndicesPermission.Group>(indicesPrivileges.length);
            for (RoleDescriptor.IndicesPrivileges privilege : indicesPrivileges) {
                list.add(new IndicesPermission.Group(IndexPrivilege.get(new Privilege.Name(privilege.getPrivileges())), privilege.getFieldPermissions(), privilege.getQuery(), privilege.getIndices()));
            }
            return list;
        }
    }
}

