/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.security.authz.permission.GlobalPermission;
import org.elasticsearch.xpack.security.authz.permission.Permission;
import org.elasticsearch.xpack.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.security.support.AutomatonPredicate;
import org.elasticsearch.xpack.security.support.Automatons;

public interface IndicesPermission
extends Permission,
Iterable<Group> {
    public Map<String, IndicesAccessControl.IndexAccessControl> authorize(String var1, Set<String> var2, MetaData var3);

    public boolean check(String var1);

    public static class Group {
        private final IndexPrivilege privilege;
        private final Predicate<String> actionMatcher;
        private final String[] indices;
        private final Predicate<String> indexNameMatcher;
        private final FieldPermissions fieldPermissions;
        private final BytesReference query;

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        public Group(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable BytesReference query, String ... indices) {
            assert (indices.length != 0);
            this.privilege = privilege;
            this.actionMatcher = privilege.predicate();
            this.indices = indices;
            this.indexNameMatcher = new AutomatonPredicate(Automatons.patterns(indices));
            this.fieldPermissions = Objects.requireNonNull(fieldPermissions);
            this.query = query;
        }

        public IndexPrivilege privilege() {
            return this.privilege;
        }

        public String[] indices() {
            return this.indices;
        }

        @Nullable
        public BytesReference getQuery() {
            return this.query;
        }

        private boolean check(String action) {
            return this.actionMatcher.test(action);
        }

        private boolean check(String action, String index) {
            assert (index != null);
            return this.check(action) && this.indexNameMatcher.test(index);
        }

        public boolean hasQuery() {
            return this.query != null;
        }
    }

    public static class Globals
    implements IndicesPermission {
        private final List<GlobalPermission> globals;

        public Globals(List<GlobalPermission> globals) {
            this.globals = globals;
        }

        @Override
        public Iterator<Group> iterator() {
            return this.globals == null || this.globals.isEmpty() ? Collections.emptyIterator() : new Iter(this.globals);
        }

        @Override
        public boolean isEmpty() {
            if (this.globals == null || this.globals.isEmpty()) {
                return true;
            }
            for (GlobalPermission global : this.globals) {
                if (global.indices().isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean check(String action) {
            if (this.globals == null) {
                return false;
            }
            for (GlobalPermission global : this.globals) {
                Objects.requireNonNull(global, "global must not be null");
                Objects.requireNonNull(global.indices(), "global.indices() must not be null");
                if (!global.indices().check(action)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map<String, IndicesAccessControl.IndexAccessControl> authorize(String action, Set<String> requestedIndicesOrAliases, MetaData metaData) {
            if (this.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, IndicesAccessControl.IndexAccessControl> indicesAccessControl = null;
            for (GlobalPermission permission : this.globals) {
                Map<String, IndicesAccessControl.IndexAccessControl> temp = permission.indices().authorize(action, requestedIndicesOrAliases, metaData);
                if (indicesAccessControl == null) {
                    indicesAccessControl = new HashMap<String, IndicesAccessControl.IndexAccessControl>(temp);
                    continue;
                }
                for (Map.Entry<String, IndicesAccessControl.IndexAccessControl> entry : temp.entrySet()) {
                    IndicesAccessControl.IndexAccessControl existing = (IndicesAccessControl.IndexAccessControl)indicesAccessControl.get(entry.getKey());
                    if (existing != null) {
                        indicesAccessControl.put(entry.getKey(), existing.merge(entry.getValue()));
                        continue;
                    }
                    indicesAccessControl.put(entry.getKey(), entry.getValue());
                }
            }
            if (indicesAccessControl == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(indicesAccessControl);
        }

        static class Iter
        implements Iterator<Group> {
            private final Iterator<GlobalPermission> globals;
            private Iterator<Group> current;

            Iter(List<GlobalPermission> globals) {
                this.globals = globals.iterator();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current.hasNext();
            }

            @Override
            public Group next() {
                Group group = this.current.next();
                this.advance();
                return group;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void advance() {
                if (this.current != null && this.current.hasNext()) {
                    return;
                }
                if (!this.globals.hasNext()) {
                    this.current = null;
                    return;
                }
                while (this.globals.hasNext()) {
                    IndicesPermission indices = this.globals.next().indices();
                    if (indices.isEmpty()) continue;
                    this.current = indices.iterator();
                    return;
                }
                this.current = null;
            }
        }
    }

    public static class Core
    implements IndicesPermission {
        public static final Core NONE = new Core(new Group[0]){

            @Override
            public Iterator<Group> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
        private final Function<String, Predicate<String>> loadingFunction;
        private final ConcurrentHashMap<String, Predicate<String>> allowedIndicesMatchersForAction = new ConcurrentHashMap();
        private final Group[] groups;

        public Core(List<Group> groups) {
            this(groups.toArray(new Group[groups.size()]));
        }

        public Core(Group ... groups) {
            this.groups = groups;
            this.loadingFunction = action -> {
                ArrayList<String> indices = new ArrayList<String>();
                for (Group group : groups) {
                    if (!group.actionMatcher.test(action)) continue;
                    indices.addAll(Arrays.asList(group.indices));
                }
                return new AutomatonPredicate(Automatons.patterns(Collections.unmodifiableList(indices)));
            };
        }

        @Override
        public Iterator<Group> iterator() {
            return Arrays.asList(this.groups).iterator();
        }

        public Group[] groups() {
            return this.groups;
        }

        @Override
        public boolean isEmpty() {
            return this.groups == null || this.groups.length == 0;
        }

        public Predicate<String> allowedIndicesMatcher(String action) {
            return this.allowedIndicesMatchersForAction.computeIfAbsent(action, this.loadingFunction);
        }

        @Override
        public boolean check(String action) {
            for (Group group : this.groups) {
                if (!group.check(action)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map<String, IndicesAccessControl.IndexAccessControl> authorize(String action, Set<String> requestedIndicesOrAliases, MetaData metaData) {
            SortedMap allAliasesAndIndices = metaData.getAliasAndIndexLookup();
            HashMap fieldPermissionsByIndex = new HashMap();
            HashMap<String, HashSet<BytesReference>> roleQueriesByIndex = new HashMap<String, HashSet<BytesReference>>();
            HashMap<String, Boolean> grantedBuilder = new HashMap<String, Boolean>();
            for (String indexOrAlias : requestedIndicesOrAliases) {
                boolean granted = false;
                HashSet<String> concreteIndices = new HashSet<String>();
                AliasOrIndex aliasOrIndex = (AliasOrIndex)allAliasesAndIndices.get(indexOrAlias);
                if (aliasOrIndex != null) {
                    for (IndexMetaData indexMetaData : aliasOrIndex.getIndices()) {
                        concreteIndices.add(indexMetaData.getIndex().getName());
                    }
                }
                for (Group group : this.groups) {
                    if (!group.check(action, indexOrAlias)) continue;
                    granted = true;
                    for (String index : concreteIndices) {
                        if (fieldPermissionsByIndex.get(index) == null) {
                            fieldPermissionsByIndex.put(index, new HashSet());
                        }
                        ((Set)fieldPermissionsByIndex.get(index)).add(group.getFieldPermissions());
                        if (!group.hasQuery()) continue;
                        HashSet<BytesReference> roleQueries = (HashSet<BytesReference>)roleQueriesByIndex.get(index);
                        if (roleQueries == null) {
                            roleQueries = new HashSet<BytesReference>();
                            roleQueriesByIndex.put(index, roleQueries);
                        }
                        roleQueries.add(group.getQuery());
                    }
                }
                if (concreteIndices.isEmpty()) {
                    grantedBuilder.put(indexOrAlias, granted);
                    continue;
                }
                for (String concreteIndex : concreteIndices) {
                    grantedBuilder.put(concreteIndex, granted);
                }
            }
            HashMap<String, IndicesAccessControl.IndexAccessControl> indexPermissions = new HashMap<String, IndicesAccessControl.IndexAccessControl>();
            for (Map.Entry entry : grantedBuilder.entrySet()) {
                String index = (String)entry.getKey();
                Set<BytesReference> roleQueries = (Set<BytesReference>)roleQueriesByIndex.get(index);
                if (roleQueries != null) {
                    roleQueries = Collections.unmodifiableSet(roleQueries);
                }
                FieldPermissions fieldPermissions = new FieldPermissions();
                Set indexFieldPermissions = (Set)fieldPermissionsByIndex.get(index);
                if (indexFieldPermissions != null) {
                    fieldPermissions = (FieldPermissions)indexFieldPermissions.iterator().next();
                    for (FieldPermissions fp : indexFieldPermissions) {
                        fieldPermissions = FieldPermissions.merge(fieldPermissions, fp);
                    }
                }
                indexPermissions.put(index, new IndicesAccessControl.IndexAccessControl((Boolean)entry.getValue(), fieldPermissions, roleQueries));
            }
            return Collections.unmodifiableMap(indexPermissions);
        }
    }
}

