/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.security.authz.permission.Permission;
import org.elasticsearch.xpack.security.authz.permission.RunAsPermission;

public class GlobalPermission
implements Permission {
    public static final GlobalPermission NONE = new GlobalPermission(ClusterPermission.Core.NONE, IndicesPermission.Core.NONE, RunAsPermission.Core.NONE);
    private final ClusterPermission cluster;
    private final IndicesPermission indices;
    private final RunAsPermission runAs;

    GlobalPermission(ClusterPermission cluster, IndicesPermission indices, RunAsPermission runAs) {
        this.cluster = cluster;
        this.indices = indices;
        this.runAs = runAs;
    }

    public ClusterPermission cluster() {
        return this.cluster;
    }

    public IndicesPermission indices() {
        return this.indices;
    }

    public RunAsPermission runAs() {
        return this.runAs;
    }

    @Override
    public boolean isEmpty() {
        return !(this.cluster != null && !this.cluster.isEmpty() || this.indices != null && !this.indices.isEmpty() || this.runAs != null && !this.runAs.isEmpty());
    }

    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, MetaData metaData) {
        Map<String, IndicesAccessControl.IndexAccessControl> indexPermissions = this.indices.authorize(action, requestedIndicesOrAliases, metaData);
        boolean granted = true;
        for (Map.Entry<String, IndicesAccessControl.IndexAccessControl> entry : indexPermissions.entrySet()) {
            if (entry.getValue().isGranted()) continue;
            granted = false;
            break;
        }
        return new IndicesAccessControl(granted, indexPermissions);
    }

    public static class Compound
    extends GlobalPermission {
        Compound(List<GlobalPermission> globals) {
            super(new ClusterPermission.Globals(globals), new IndicesPermission.Globals(globals), new RunAsPermission.Globals(globals));
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private List<GlobalPermission> globals = new ArrayList<GlobalPermission>();

            private Builder() {
            }

            public Builder add(GlobalPermission global) {
                this.globals.add(global);
                return this;
            }

            public Compound build() {
                return new Compound(Collections.unmodifiableList(this.globals));
            }
        }
    }
}

