/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.support.Automatons;

public class FieldPermissions
implements Writeable,
ToXContent {
    String[] grantedFieldsArray;
    String[] deniedFieldsArray;
    Automaton permittedFieldsAutomaton;
    boolean allFieldIsAllowed = false;

    public FieldPermissions(StreamInput in) throws IOException {
        this(in.readOptionalStringArray(), in.readOptionalStringArray());
    }

    public FieldPermissions(@Nullable String[] grantedFieldsArray, @Nullable String[] deniedFieldsArray) {
        this.grantedFieldsArray = grantedFieldsArray;
        this.deniedFieldsArray = deniedFieldsArray;
        this.permittedFieldsAutomaton = FieldPermissions.initializePermittedFieldsAutomaton(grantedFieldsArray, deniedFieldsArray);
        this.allFieldIsAllowed = FieldPermissions.checkAllFieldIsAllowed(grantedFieldsArray, deniedFieldsArray);
    }

    private static boolean checkAllFieldIsAllowed(String[] grantedFieldsArray, String[] deniedFieldsArray) {
        if (deniedFieldsArray != null) {
            for (String fieldName : deniedFieldsArray) {
                if (!fieldName.equals("_all")) continue;
                return false;
            }
        }
        if (grantedFieldsArray != null) {
            for (String fieldName : grantedFieldsArray) {
                if (!fieldName.equals("_all")) continue;
                return true;
            }
        }
        return false;
    }

    private static Automaton initializePermittedFieldsAutomaton(String[] grantedFieldsArray, String[] deniedFieldsArray) {
        Automaton grantedFieldsAutomaton;
        Automaton deniedFieldsAutomaton = deniedFieldsArray == null || deniedFieldsArray.length == 0 ? Automatons.EMPTY : Automatons.patterns(deniedFieldsArray);
        if (!Operations.subsetOf((Automaton)deniedFieldsAutomaton, (Automaton)(grantedFieldsAutomaton = grantedFieldsArray == null || FieldPermissions.containsWildcard(grantedFieldsArray) ? Automatons.MATCH_ALL : Automatons.patterns(grantedFieldsArray)))) {
            throw new ElasticsearchSecurityException("Exceptions for field permissions must be a subset of the granted fields but " + Arrays.toString(deniedFieldsArray) + " is not a subset of " + Arrays.toString(grantedFieldsArray), new Object[0]);
        }
        grantedFieldsAutomaton = Automatons.minusAndDeterminize(grantedFieldsAutomaton, deniedFieldsAutomaton);
        return grantedFieldsAutomaton;
    }

    private static boolean containsWildcard(String[] grantedFieldsArray) {
        for (String fieldPattern : grantedFieldsArray) {
            if (!Regex.isMatchAllPattern((String)fieldPattern)) continue;
            return true;
        }
        return false;
    }

    public FieldPermissions() {
        this(null, null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringArray(this.grantedFieldsArray);
        out.writeOptionalStringArray(this.deniedFieldsArray);
    }

    @Nullable
    String[] getGrantedFieldsArray() {
        return this.grantedFieldsArray;
    }

    @Nullable
    String[] getDeniedFieldsArray() {
        return this.deniedFieldsArray;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.grantedFieldsArray != null || this.deniedFieldsArray != null) {
            sb.append(RoleDescriptor.Fields.FIELD_PERMISSIONS).append("=[");
            if (this.grantedFieldsArray == null) {
                sb.append(RoleDescriptor.Fields.GRANT_FIELDS).append("=null");
            } else {
                sb.append(RoleDescriptor.Fields.GRANT_FIELDS).append("=[").append(Strings.arrayToCommaDelimitedString((Object[])this.grantedFieldsArray));
                sb.append("]");
            }
            if (this.deniedFieldsArray == null) {
                sb.append(", ").append(RoleDescriptor.Fields.EXCEPT_FIELDS).append("=null");
            } else {
                sb.append(", ").append(RoleDescriptor.Fields.EXCEPT_FIELDS).append("=[").append(Strings.arrayToCommaDelimitedString((Object[])this.deniedFieldsArray));
                sb.append("]");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.grantedFieldsArray != null || this.deniedFieldsArray != null) {
            builder.startObject(RoleDescriptor.Fields.FIELD_PERMISSIONS.getPreferredName());
            if (this.grantedFieldsArray != null) {
                builder.array(RoleDescriptor.Fields.GRANT_FIELDS.getPreferredName(), this.grantedFieldsArray);
            }
            if (this.deniedFieldsArray != null) {
                builder.array(RoleDescriptor.Fields.EXCEPT_FIELDS.getPreferredName(), this.deniedFieldsArray);
            }
            builder.endObject();
        }
        return builder;
    }

    public boolean grantsAccessTo(String fieldName) {
        return Operations.isTotal((Automaton)this.permittedFieldsAutomaton) || Operations.run((Automaton)this.permittedFieldsAutomaton, (String)fieldName);
    }

    public static FieldPermissions merge(FieldPermissions p1, FieldPermissions p2) {
        Automaton mergedPermittedFieldsAutomaton = Operations.union((Automaton)p1.permittedFieldsAutomaton, (Automaton)p2.permittedFieldsAutomaton);
        mergedPermittedFieldsAutomaton = MinimizationOperations.minimize((Automaton)mergedPermittedFieldsAutomaton, (int)10000);
        boolean allFieldIsAllowedInMerged = p1.allFieldIsAllowed || p2.allFieldIsAllowed;
        return new MergedFieldPermissions(mergedPermittedFieldsAutomaton, allFieldIsAllowedInMerged);
    }

    public boolean hasFieldLevelSecurity() {
        return !Operations.isTotal((Automaton)this.permittedFieldsAutomaton);
    }

    public Set<String> resolveAllowedFields(Set<String> allowedMetaFields, MapperService mapperService) {
        HashSet<String> finalAllowedFields = new HashSet<String>();
        finalAllowedFields.addAll(allowedMetaFields);
        Collection allFields = mapperService.simpleMatchToIndexNames("*");
        for (String fieldName : allFields) {
            if (!this.grantsAccessTo(fieldName)) continue;
            finalAllowedFields.add(fieldName);
        }
        if (!this.allFieldIsAllowed) {
            finalAllowedFields.remove("_all");
        }
        return finalAllowedFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPermissions that = (FieldPermissions)o;
        if (this.allFieldIsAllowed != that.allFieldIsAllowed) {
            return false;
        }
        if (!Arrays.equals(this.grantedFieldsArray, that.grantedFieldsArray)) {
            return false;
        }
        if (!Arrays.equals(this.deniedFieldsArray, that.deniedFieldsArray)) {
            return false;
        }
        return Operations.sameLanguage((Automaton)this.permittedFieldsAutomaton, (Automaton)that.permittedFieldsAutomaton);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.grantedFieldsArray);
        result = 31 * result + Arrays.hashCode(this.deniedFieldsArray);
        result = 31 * result + this.permittedFieldsAutomaton.hashCode();
        result = 31 * result + (this.allFieldIsAllowed ? 1 : 0);
        return result;
    }

    public static class MergedFieldPermissions
    extends FieldPermissions {
        public MergedFieldPermissions(Automaton grantedFields, boolean allFieldIsAllowed) {
            assert (grantedFields != null);
            this.permittedFieldsAutomaton = grantedFields;
            this.grantedFieldsArray = null;
            this.deniedFieldsArray = null;
            this.allFieldIsAllowed = allFieldIsAllowed;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException("Cannot build xcontent for merged field permissions");
        }

        @Override
        public String toString() {
            throw new UnsupportedOperationException("Cannot build string for merged field permissions");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("Cannot stream for merged field permissions");
        }

        @Override
        @Nullable
        public String[] getGrantedFieldsArray() {
            throw new UnsupportedOperationException("Merged field permissions does not maintain sets");
        }

        @Override
        @Nullable
        public String[] getDeniedFieldsArray() {
            throw new UnsupportedOperationException("Merged field permissions does not maintain sets");
        }
    }
}

