/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.permission;

import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.action.user.UserRequest;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.security.authz.privilege.Privilege;

public class DefaultRole
extends Role {
    private static final ClusterPermission.Core CLUSTER_PERMISSION = new SameUserClusterPermission(ClusterPrivilege.get(new Privilege.Name("cluster:admin/xpack/security/user/change_password", "cluster:admin/xpack/security/user/authenticate")));
    private static final IndicesPermission.Core INDICES_PERMISSION = IndicesPermission.Core.NONE;
    private static final RunAsPermission.Core RUN_AS_PERMISSION = RunAsPermission.Core.NONE;
    public static final String NAME = "__default_role";
    public static final DefaultRole INSTANCE = new DefaultRole();

    private DefaultRole() {
        super(NAME, CLUSTER_PERMISSION, INDICES_PERMISSION, RUN_AS_PERMISSION);
    }

    static boolean checkChangePasswordAction(Authentication authentication) {
        boolean isRunAs = authentication.isRunAs();
        String realmType = isRunAs ? authentication.getLookedUpBy().getType() : authentication.getAuthenticatedBy().getType();
        assert (realmType != null);
        return "reserved".equals(realmType) || "native".equals(realmType);
    }

    private static class SameUserClusterPermission
    extends ClusterPermission.Core {
        private SameUserClusterPermission(ClusterPrivilege privilege) {
            super(privilege);
        }

        @Override
        public boolean check(String action, TransportRequest request, Authentication authentication) {
            boolean actionAllowed = super.check(action, request, authentication);
            if (actionAllowed) {
                if (!(request instanceof UserRequest)) {
                    assert (false) : "right now only a user request should be allowed";
                    return false;
                }
                UserRequest userRequest = (UserRequest)request;
                String[] usernames = userRequest.usernames();
                if (usernames == null || usernames.length != 1 || usernames[0] == null) {
                    assert (false) : "this role should only be used for actions to apply to a single user";
                    return false;
                }
                String username = usernames[0];
                boolean sameUsername = authentication.getRunAsUser().principal().equals(username);
                if (sameUsername && "cluster:admin/xpack/security/user/change_password".equals(action)) {
                    return DefaultRole.checkChangePasswordAction(authentication);
                }
                assert ("cluster:admin/xpack/security/user/authenticate".equals(action) || !sameUsername);
                return sameUsername;
            }
            return false;
        }
    }
}

